/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cloudfront.model.CloudFrontResponse;
import software.amazon.awssdk.services.cloudfront.model.ConnectionFunctionSummary;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateConnectionFunctionResponse
extends CloudFrontResponse
implements ToCopyableBuilder<Builder, CreateConnectionFunctionResponse> {
    private static final SdkField<ConnectionFunctionSummary> CONNECTION_FUNCTION_SUMMARY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ConnectionFunctionSummary").getter(CreateConnectionFunctionResponse.getter(CreateConnectionFunctionResponse::connectionFunctionSummary)).setter(CreateConnectionFunctionResponse.setter(Builder::connectionFunctionSummary)).constructor(ConnectionFunctionSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectionFunctionSummary").unmarshallLocationName("ConnectionFunctionSummary").build(), PayloadTrait.create()}).build();
    private static final SdkField<String> LOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Location").getter(CreateConnectionFunctionResponse.getter(CreateConnectionFunctionResponse::location)).setter(CreateConnectionFunctionResponse.setter(Builder::location)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("Location").unmarshallLocationName("Location").build()}).build();
    private static final SdkField<String> E_TAG_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ETag").getter(CreateConnectionFunctionResponse.getter(CreateConnectionFunctionResponse::eTag)).setter(CreateConnectionFunctionResponse.setter(Builder::eTag)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("ETag").unmarshallLocationName("ETag").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONNECTION_FUNCTION_SUMMARY_FIELD, LOCATION_FIELD, E_TAG_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateConnectionFunctionResponse.memberNameToFieldInitializer();
    private final ConnectionFunctionSummary connectionFunctionSummary;
    private final String location;
    private final String eTag;

    private CreateConnectionFunctionResponse(BuilderImpl builder) {
        super(builder);
        this.connectionFunctionSummary = builder.connectionFunctionSummary;
        this.location = builder.location;
        this.eTag = builder.eTag;
    }

    public final ConnectionFunctionSummary connectionFunctionSummary() {
        return this.connectionFunctionSummary;
    }

    public final String location() {
        return this.location;
    }

    public final String eTag() {
        return this.eTag;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.connectionFunctionSummary());
        hashCode = 31 * hashCode + Objects.hashCode(this.location());
        hashCode = 31 * hashCode + Objects.hashCode(this.eTag());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateConnectionFunctionResponse)) {
            return false;
        }
        CreateConnectionFunctionResponse other = (CreateConnectionFunctionResponse)((Object)obj);
        return Objects.equals(this.connectionFunctionSummary(), other.connectionFunctionSummary()) && Objects.equals(this.location(), other.location()) && Objects.equals(this.eTag(), other.eTag());
    }

    public final String toString() {
        return ToString.builder((String)"CreateConnectionFunctionResponse").add("ConnectionFunctionSummary", (Object)this.connectionFunctionSummary()).add("Location", (Object)this.location()).add("ETag", (Object)this.eTag()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ConnectionFunctionSummary": {
                return Optional.ofNullable(clazz.cast(this.connectionFunctionSummary()));
            }
            case "Location": {
                return Optional.ofNullable(clazz.cast(this.location()));
            }
            case "ETag": {
                return Optional.ofNullable(clazz.cast(this.eTag()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ConnectionFunctionSummary", CONNECTION_FUNCTION_SUMMARY_FIELD);
        map.put("Location", LOCATION_FIELD);
        map.put("ETag", E_TAG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateConnectionFunctionResponse, T> g) {
        return obj -> g.apply((CreateConnectionFunctionResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudFrontResponse.BuilderImpl
    implements Builder {
        private ConnectionFunctionSummary connectionFunctionSummary;
        private String location;
        private String eTag;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateConnectionFunctionResponse model) {
            super(model);
            this.connectionFunctionSummary(model.connectionFunctionSummary);
            this.location(model.location);
            this.eTag(model.eTag);
        }

        public final ConnectionFunctionSummary.Builder getConnectionFunctionSummary() {
            return this.connectionFunctionSummary != null ? this.connectionFunctionSummary.toBuilder() : null;
        }

        public final void setConnectionFunctionSummary(ConnectionFunctionSummary.BuilderImpl connectionFunctionSummary) {
            this.connectionFunctionSummary = connectionFunctionSummary != null ? connectionFunctionSummary.build() : null;
        }

        @Override
        public final Builder connectionFunctionSummary(ConnectionFunctionSummary connectionFunctionSummary) {
            this.connectionFunctionSummary = connectionFunctionSummary;
            return this;
        }

        public final String getLocation() {
            return this.location;
        }

        public final void setLocation(String location) {
            this.location = location;
        }

        @Override
        public final Builder location(String location) {
            this.location = location;
            return this;
        }

        public final String getETag() {
            return this.eTag;
        }

        public final void setETag(String eTag) {
            this.eTag = eTag;
        }

        @Override
        public final Builder eTag(String eTag) {
            this.eTag = eTag;
            return this;
        }

        @Override
        public CreateConnectionFunctionResponse build() {
            return new CreateConnectionFunctionResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends CloudFrontResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateConnectionFunctionResponse> {
        public Builder connectionFunctionSummary(ConnectionFunctionSummary var1);

        default public Builder connectionFunctionSummary(Consumer<ConnectionFunctionSummary.Builder> connectionFunctionSummary) {
            return this.connectionFunctionSummary((ConnectionFunctionSummary)((ConnectionFunctionSummary.Builder)ConnectionFunctionSummary.builder().applyMutation(connectionFunctionSummary)).build());
        }

        public Builder location(String var1);

        public Builder eTag(String var1);
    }
}

