/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cloudfront.model.FunctionConfig;
import software.amazon.awssdk.services.cloudfront.model.FunctionStage;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ConnectionFunctionSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ConnectionFunctionSummary> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(ConnectionFunctionSummary.getter(ConnectionFunctionSummary::name)).setter(ConnectionFunctionSummary.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").unmarshallLocationName("Name").build()}).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Id").getter(ConnectionFunctionSummary.getter(ConnectionFunctionSummary::id)).setter(ConnectionFunctionSummary.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").unmarshallLocationName("Id").build()}).build();
    private static final SdkField<FunctionConfig> CONNECTION_FUNCTION_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ConnectionFunctionConfig").getter(ConnectionFunctionSummary.getter(ConnectionFunctionSummary::connectionFunctionConfig)).setter(ConnectionFunctionSummary.setter(Builder::connectionFunctionConfig)).constructor(FunctionConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectionFunctionConfig").unmarshallLocationName("ConnectionFunctionConfig").build()}).build();
    private static final SdkField<String> CONNECTION_FUNCTION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ConnectionFunctionArn").getter(ConnectionFunctionSummary.getter(ConnectionFunctionSummary::connectionFunctionArn)).setter(ConnectionFunctionSummary.setter(Builder::connectionFunctionArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectionFunctionArn").unmarshallLocationName("ConnectionFunctionArn").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(ConnectionFunctionSummary.getter(ConnectionFunctionSummary::status)).setter(ConnectionFunctionSummary.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").unmarshallLocationName("Status").build()}).build();
    private static final SdkField<String> STAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Stage").getter(ConnectionFunctionSummary.getter(ConnectionFunctionSummary::stageAsString)).setter(ConnectionFunctionSummary.setter(Builder::stage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Stage").unmarshallLocationName("Stage").build()}).build();
    private static final SdkField<Instant> CREATED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedTime").getter(ConnectionFunctionSummary.getter(ConnectionFunctionSummary::createdTime)).setter(ConnectionFunctionSummary.setter(Builder::createdTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTime").unmarshallLocationName("CreatedTime").build()}).build();
    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastModifiedTime").getter(ConnectionFunctionSummary.getter(ConnectionFunctionSummary::lastModifiedTime)).setter(ConnectionFunctionSummary.setter(Builder::lastModifiedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime").unmarshallLocationName("LastModifiedTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, ID_FIELD, CONNECTION_FUNCTION_CONFIG_FIELD, CONNECTION_FUNCTION_ARN_FIELD, STATUS_FIELD, STAGE_FIELD, CREATED_TIME_FIELD, LAST_MODIFIED_TIME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ConnectionFunctionSummary.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String id;
    private final FunctionConfig connectionFunctionConfig;
    private final String connectionFunctionArn;
    private final String status;
    private final String stage;
    private final Instant createdTime;
    private final Instant lastModifiedTime;

    private ConnectionFunctionSummary(BuilderImpl builder) {
        this.name = builder.name;
        this.id = builder.id;
        this.connectionFunctionConfig = builder.connectionFunctionConfig;
        this.connectionFunctionArn = builder.connectionFunctionArn;
        this.status = builder.status;
        this.stage = builder.stage;
        this.createdTime = builder.createdTime;
        this.lastModifiedTime = builder.lastModifiedTime;
    }

    public final String name() {
        return this.name;
    }

    public final String id() {
        return this.id;
    }

    public final FunctionConfig connectionFunctionConfig() {
        return this.connectionFunctionConfig;
    }

    public final String connectionFunctionArn() {
        return this.connectionFunctionArn;
    }

    public final String status() {
        return this.status;
    }

    public final FunctionStage stage() {
        return FunctionStage.fromValue(this.stage);
    }

    public final String stageAsString() {
        return this.stage;
    }

    public final Instant createdTime() {
        return this.createdTime;
    }

    public final Instant lastModifiedTime() {
        return this.lastModifiedTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.connectionFunctionConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.connectionFunctionArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.stageAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConnectionFunctionSummary)) {
            return false;
        }
        ConnectionFunctionSummary other = (ConnectionFunctionSummary)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.connectionFunctionConfig(), other.connectionFunctionConfig()) && Objects.equals(this.connectionFunctionArn(), other.connectionFunctionArn()) && Objects.equals(this.status(), other.status()) && Objects.equals(this.stageAsString(), other.stageAsString()) && Objects.equals(this.createdTime(), other.createdTime()) && Objects.equals(this.lastModifiedTime(), other.lastModifiedTime());
    }

    public final String toString() {
        return ToString.builder((String)"ConnectionFunctionSummary").add("Name", (Object)this.name()).add("Id", (Object)this.id()).add("ConnectionFunctionConfig", (Object)this.connectionFunctionConfig()).add("ConnectionFunctionArn", (Object)this.connectionFunctionArn()).add("Status", (Object)this.status()).add("Stage", (Object)this.stageAsString()).add("CreatedTime", (Object)this.createdTime()).add("LastModifiedTime", (Object)this.lastModifiedTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "ConnectionFunctionConfig": {
                return Optional.ofNullable(clazz.cast(this.connectionFunctionConfig()));
            }
            case "ConnectionFunctionArn": {
                return Optional.ofNullable(clazz.cast(this.connectionFunctionArn()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
            case "Stage": {
                return Optional.ofNullable(clazz.cast(this.stageAsString()));
            }
            case "CreatedTime": {
                return Optional.ofNullable(clazz.cast(this.createdTime()));
            }
            case "LastModifiedTime": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Name", NAME_FIELD);
        map.put("Id", ID_FIELD);
        map.put("ConnectionFunctionConfig", CONNECTION_FUNCTION_CONFIG_FIELD);
        map.put("ConnectionFunctionArn", CONNECTION_FUNCTION_ARN_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("Stage", STAGE_FIELD);
        map.put("CreatedTime", CREATED_TIME_FIELD);
        map.put("LastModifiedTime", LAST_MODIFIED_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ConnectionFunctionSummary, T> g) {
        return obj -> g.apply((ConnectionFunctionSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String id;
        private FunctionConfig connectionFunctionConfig;
        private String connectionFunctionArn;
        private String status;
        private String stage;
        private Instant createdTime;
        private Instant lastModifiedTime;

        private BuilderImpl() {
        }

        private BuilderImpl(ConnectionFunctionSummary model) {
            this.name(model.name);
            this.id(model.id);
            this.connectionFunctionConfig(model.connectionFunctionConfig);
            this.connectionFunctionArn(model.connectionFunctionArn);
            this.status(model.status);
            this.stage(model.stage);
            this.createdTime(model.createdTime);
            this.lastModifiedTime(model.lastModifiedTime);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final FunctionConfig.Builder getConnectionFunctionConfig() {
            return this.connectionFunctionConfig != null ? this.connectionFunctionConfig.toBuilder() : null;
        }

        public final void setConnectionFunctionConfig(FunctionConfig.BuilderImpl connectionFunctionConfig) {
            this.connectionFunctionConfig = connectionFunctionConfig != null ? connectionFunctionConfig.build() : null;
        }

        @Override
        public final Builder connectionFunctionConfig(FunctionConfig connectionFunctionConfig) {
            this.connectionFunctionConfig = connectionFunctionConfig;
            return this;
        }

        public final String getConnectionFunctionArn() {
            return this.connectionFunctionArn;
        }

        public final void setConnectionFunctionArn(String connectionFunctionArn) {
            this.connectionFunctionArn = connectionFunctionArn;
        }

        @Override
        public final Builder connectionFunctionArn(String connectionFunctionArn) {
            this.connectionFunctionArn = connectionFunctionArn;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final String getStage() {
            return this.stage;
        }

        public final void setStage(String stage) {
            this.stage = stage;
        }

        @Override
        public final Builder stage(String stage) {
            this.stage = stage;
            return this;
        }

        @Override
        public final Builder stage(FunctionStage stage) {
            this.stage(stage == null ? null : stage.toString());
            return this;
        }

        public final Instant getCreatedTime() {
            return this.createdTime;
        }

        public final void setCreatedTime(Instant createdTime) {
            this.createdTime = createdTime;
        }

        @Override
        public final Builder createdTime(Instant createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        public final Instant getLastModifiedTime() {
            return this.lastModifiedTime;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public ConnectionFunctionSummary build() {
            return new ConnectionFunctionSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ConnectionFunctionSummary> {
        public Builder name(String var1);

        public Builder id(String var1);

        public Builder connectionFunctionConfig(FunctionConfig var1);

        default public Builder connectionFunctionConfig(Consumer<FunctionConfig.Builder> connectionFunctionConfig) {
            return this.connectionFunctionConfig((FunctionConfig)((FunctionConfig.Builder)FunctionConfig.builder().applyMutation(connectionFunctionConfig)).build());
        }

        public Builder connectionFunctionArn(String var1);

        public Builder status(String var1);

        public Builder stage(String var1);

        public Builder stage(FunctionStage var1);

        public Builder createdTime(Instant var1);

        public Builder lastModifiedTime(Instant var1);
    }
}

