/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

/**
 * <p>
 * <fullname>Amazon CloudFront</fullname>
 * <p>
 * This is the <i>Amazon CloudFront API Reference</i>. This guide is for developers who need detailed information about
 * CloudFront API actions, data types, and errors. For detailed information about CloudFront features, see the <a
 * href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Introduction.html">Amazon CloudFront
 * Developer Guide</a>.
 * </p>
 * </p>
 *
 * <h2>Code Examples</h2>
 * <p>
 * For code examples demonstrating how to use this service with the AWS SDK for Java v2, see:
 * </p>
 * <h3>API Actions</h3>
 * <ul>
 * <li><a
 * href="https://docs.aws.amazon.com/code-library/latest/ug/cloudfront_example_cloudfront_CreateFunction_section.html"
 * target="_top">Use CreateFunction</a></li>
 * <li><a href=
 * "https://docs.aws.amazon.com/code-library/latest/ug/cloudfront_example_cloudfront_UpdateDistribution_section.html"
 * target="_top">Use UpdateDistribution</a></li>
 * <li><a href=
 * "https://docs.aws.amazon.com/code-library/latest/ug/cloudfront_example_cloudfront_CreateDistribution_section.html"
 * target="_top">Use CreateDistribution</a></li>
 * <li><a
 * href="https://docs.aws.amazon.com/code-library/latest/ug/cloudfront_example_cloudfront_CreateKeyGroup_section.html"
 * target="_top">Use CreateKeyGroup</a></li>
 * <li><a href=
 * "https://docs.aws.amazon.com/code-library/latest/ug/cloudfront_example_cloudfront_CreatePublicKey_section.html"
 * target="_top">Use CreatePublicKey</a></li>
 * <li><a href=
 * "https://docs.aws.amazon.com/code-library/latest/ug/cloudfront_example_cloudfront_DeleteDistribution_section.html"
 * target="_top">Use DeleteDistribution</a></li>
 * </ul>
 * <h3>Scenarios</h3>
 * <ul>
 * <li><a href=
 * "https://docs.aws.amazon.com/code-library/latest/ug/cloudfront_example_cloudfront_CreateSaasResources_section.html"
 * target="_top">Create SaaS manager resources AWS SDK</a></li>
 * <li><a href=
 * "https://docs.aws.amazon.com/code-library/latest/ug/cloudfront_example_cloudfront_DeleteSigningResources_section.html"
 * target="_top">Delete CloudFront signing resources using AWS SDK</a></li>
 * <li><a href=
 * "https://docs.aws.amazon.com/code-library/latest/ug/cloudfront_example_cloudfront_CloudFrontUtilities_section.html"
 * target="_top">Create signed URLs and cookies using an AWS SDK</a></li>
 * </ul>
 */
package software.amazon.awssdk.services.cloudfront;