/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfront.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The WAF web ACL customization specified for the distribution tenant.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class WebAclCustomization implements SdkPojo, Serializable,
        ToCopyableBuilder<WebAclCustomization.Builder, WebAclCustomization> {
    private static final SdkField<String> ACTION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Action")
            .getter(getter(WebAclCustomization::actionAsString))
            .setter(setter(Builder::action))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Action")
                    .unmarshallLocationName("Action").build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Arn")
            .getter(getter(WebAclCustomization::arn))
            .setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").unmarshallLocationName("Arn")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTION_FIELD, ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String action;

    private final String arn;

    private WebAclCustomization(BuilderImpl builder) {
        this.action = builder.action;
        this.arn = builder.arn;
    }

    /**
     * <p>
     * The action for the WAF web ACL customization. You can specify <code>override</code> to specify a separate WAF web
     * ACL for the distribution tenant. If you specify <code>disable</code>, the distribution tenant won't have WAF web
     * ACL protections and won't inherit from the multi-tenant distribution.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #action} will
     * return {@link CustomizationActionType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #actionAsString}.
     * </p>
     * 
     * @return The action for the WAF web ACL customization. You can specify <code>override</code> to specify a separate
     *         WAF web ACL for the distribution tenant. If you specify <code>disable</code>, the distribution tenant
     *         won't have WAF web ACL protections and won't inherit from the multi-tenant distribution.
     * @see CustomizationActionType
     */
    public final CustomizationActionType action() {
        return CustomizationActionType.fromValue(action);
    }

    /**
     * <p>
     * The action for the WAF web ACL customization. You can specify <code>override</code> to specify a separate WAF web
     * ACL for the distribution tenant. If you specify <code>disable</code>, the distribution tenant won't have WAF web
     * ACL protections and won't inherit from the multi-tenant distribution.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #action} will
     * return {@link CustomizationActionType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #actionAsString}.
     * </p>
     * 
     * @return The action for the WAF web ACL customization. You can specify <code>override</code> to specify a separate
     *         WAF web ACL for the distribution tenant. If you specify <code>disable</code>, the distribution tenant
     *         won't have WAF web ACL protections and won't inherit from the multi-tenant distribution.
     * @see CustomizationActionType
     */
    public final String actionAsString() {
        return action;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the WAF web ACL.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the WAF web ACL.
     */
    public final String arn() {
        return arn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(actionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WebAclCustomization)) {
            return false;
        }
        WebAclCustomization other = (WebAclCustomization) obj;
        return Objects.equals(actionAsString(), other.actionAsString()) && Objects.equals(arn(), other.arn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("WebAclCustomization").add("Action", actionAsString()).add("Arn", arn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Action":
            return Optional.ofNullable(clazz.cast(actionAsString()));
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Action", ACTION_FIELD);
        map.put("Arn", ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<WebAclCustomization, T> g) {
        return obj -> g.apply((WebAclCustomization) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, WebAclCustomization> {
        /**
         * <p>
         * The action for the WAF web ACL customization. You can specify <code>override</code> to specify a separate WAF
         * web ACL for the distribution tenant. If you specify <code>disable</code>, the distribution tenant won't have
         * WAF web ACL protections and won't inherit from the multi-tenant distribution.
         * </p>
         * 
         * @param action
         *        The action for the WAF web ACL customization. You can specify <code>override</code> to specify a
         *        separate WAF web ACL for the distribution tenant. If you specify <code>disable</code>, the
         *        distribution tenant won't have WAF web ACL protections and won't inherit from the multi-tenant
         *        distribution.
         * @see CustomizationActionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CustomizationActionType
         */
        Builder action(String action);

        /**
         * <p>
         * The action for the WAF web ACL customization. You can specify <code>override</code> to specify a separate WAF
         * web ACL for the distribution tenant. If you specify <code>disable</code>, the distribution tenant won't have
         * WAF web ACL protections and won't inherit from the multi-tenant distribution.
         * </p>
         * 
         * @param action
         *        The action for the WAF web ACL customization. You can specify <code>override</code> to specify a
         *        separate WAF web ACL for the distribution tenant. If you specify <code>disable</code>, the
         *        distribution tenant won't have WAF web ACL protections and won't inherit from the multi-tenant
         *        distribution.
         * @see CustomizationActionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CustomizationActionType
         */
        Builder action(CustomizationActionType action);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the WAF web ACL.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the WAF web ACL.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);
    }

    static final class BuilderImpl implements Builder {
        private String action;

        private String arn;

        private BuilderImpl() {
        }

        private BuilderImpl(WebAclCustomization model) {
            action(model.action);
            arn(model.arn);
        }

        public final String getAction() {
            return action;
        }

        public final void setAction(String action) {
            this.action = action;
        }

        @Override
        public final Builder action(String action) {
            this.action = action;
            return this;
        }

        @Override
        public final Builder action(CustomizationActionType action) {
            this.action(action == null ? null : action.toString());
            return this;
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        @Override
        public WebAclCustomization build() {
            return new WebAclCustomization(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
