/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfront.model;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class TestConnectionFunctionRequest extends CloudFrontRequest implements
        ToCopyableBuilder<TestConnectionFunctionRequest.Builder, TestConnectionFunctionRequest> {
    private static final SdkField<String> ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Id")
            .getter(getter(TestConnectionFunctionRequest::id))
            .setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("Id").unmarshallLocationName("Id")
                    .build()).build();

    private static final SdkField<String> IF_MATCH_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("IfMatch")
            .getter(getter(TestConnectionFunctionRequest::ifMatch))
            .setter(setter(Builder::ifMatch))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("If-Match")
                    .unmarshallLocationName("If-Match").build()).build();

    private static final SdkField<String> STAGE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Stage")
            .getter(getter(TestConnectionFunctionRequest::stageAsString))
            .setter(setter(Builder::stage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Stage")
                    .unmarshallLocationName("Stage").build()).build();

    private static final SdkField<SdkBytes> CONNECTION_OBJECT_FIELD = SdkField
            .<SdkBytes> builder(MarshallingType.SDK_BYTES)
            .memberName("ConnectionObject")
            .getter(getter(TestConnectionFunctionRequest::connectionObject))
            .setter(setter(Builder::connectionObject))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectionObject")
                    .unmarshallLocationName("ConnectionObject").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, IF_MATCH_FIELD,
            STAGE_FIELD, CONNECTION_OBJECT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String id;

    private final String ifMatch;

    private final String stage;

    private final SdkBytes connectionObject;

    private TestConnectionFunctionRequest(BuilderImpl builder) {
        super(builder);
        this.id = builder.id;
        this.ifMatch = builder.ifMatch;
        this.stage = builder.stage;
        this.connectionObject = builder.connectionObject;
    }

    /**
     * <p>
     * The connection function ID.
     * </p>
     * 
     * @return The connection function ID.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The current version (<code>ETag</code> value) of the connection function.
     * </p>
     * 
     * @return The current version (<code>ETag</code> value) of the connection function.
     */
    public final String ifMatch() {
        return ifMatch;
    }

    /**
     * <p>
     * The connection function stage.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #stage} will return
     * {@link FunctionStage#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stageAsString}.
     * </p>
     * 
     * @return The connection function stage.
     * @see FunctionStage
     */
    public final FunctionStage stage() {
        return FunctionStage.fromValue(stage);
    }

    /**
     * <p>
     * The connection function stage.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #stage} will return
     * {@link FunctionStage#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stageAsString}.
     * </p>
     * 
     * @return The connection function stage.
     * @see FunctionStage
     */
    public final String stageAsString() {
        return stage;
    }

    /**
     * <p>
     * The connection object.
     * </p>
     * 
     * @return The connection object.
     */
    public final SdkBytes connectionObject() {
        return connectionObject;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(ifMatch());
        hashCode = 31 * hashCode + Objects.hashCode(stageAsString());
        hashCode = 31 * hashCode + Objects.hashCode(connectionObject());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TestConnectionFunctionRequest)) {
            return false;
        }
        TestConnectionFunctionRequest other = (TestConnectionFunctionRequest) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(ifMatch(), other.ifMatch())
                && Objects.equals(stageAsString(), other.stageAsString())
                && Objects.equals(connectionObject(), other.connectionObject());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TestConnectionFunctionRequest").add("Id", id()).add("IfMatch", ifMatch())
                .add("Stage", stageAsString())
                .add("ConnectionObject", connectionObject() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "IfMatch":
            return Optional.ofNullable(clazz.cast(ifMatch()));
        case "Stage":
            return Optional.ofNullable(clazz.cast(stageAsString()));
        case "ConnectionObject":
            return Optional.ofNullable(clazz.cast(connectionObject()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Id", ID_FIELD);
        map.put("If-Match", IF_MATCH_FIELD);
        map.put("Stage", STAGE_FIELD);
        map.put("ConnectionObject", CONNECTION_OBJECT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TestConnectionFunctionRequest, T> g) {
        return obj -> g.apply((TestConnectionFunctionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends CloudFrontRequest.Builder, SdkPojo, CopyableBuilder<Builder, TestConnectionFunctionRequest> {
        /**
         * <p>
         * The connection function ID.
         * </p>
         * 
         * @param id
         *        The connection function ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The current version (<code>ETag</code> value) of the connection function.
         * </p>
         * 
         * @param ifMatch
         *        The current version (<code>ETag</code> value) of the connection function.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ifMatch(String ifMatch);

        /**
         * <p>
         * The connection function stage.
         * </p>
         * 
         * @param stage
         *        The connection function stage.
         * @see FunctionStage
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FunctionStage
         */
        Builder stage(String stage);

        /**
         * <p>
         * The connection function stage.
         * </p>
         * 
         * @param stage
         *        The connection function stage.
         * @see FunctionStage
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FunctionStage
         */
        Builder stage(FunctionStage stage);

        /**
         * <p>
         * The connection object.
         * </p>
         * 
         * @param connectionObject
         *        The connection object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectionObject(SdkBytes connectionObject);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CloudFrontRequest.BuilderImpl implements Builder {
        private String id;

        private String ifMatch;

        private String stage;

        private SdkBytes connectionObject;

        private BuilderImpl() {
        }

        private BuilderImpl(TestConnectionFunctionRequest model) {
            super(model);
            id(model.id);
            ifMatch(model.ifMatch);
            stage(model.stage);
            connectionObject(model.connectionObject);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getIfMatch() {
            return ifMatch;
        }

        public final void setIfMatch(String ifMatch) {
            this.ifMatch = ifMatch;
        }

        @Override
        public final Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public final String getStage() {
            return stage;
        }

        public final void setStage(String stage) {
            this.stage = stage;
        }

        @Override
        public final Builder stage(String stage) {
            this.stage = stage;
            return this;
        }

        @Override
        public final Builder stage(FunctionStage stage) {
            this.stage(stage == null ? null : stage.toString());
            return this;
        }

        public final ByteBuffer getConnectionObject() {
            return connectionObject == null ? null : connectionObject.asByteBuffer();
        }

        public final void setConnectionObject(ByteBuffer connectionObject) {
            connectionObject(connectionObject == null ? null : SdkBytes.fromByteBuffer(connectionObject));
        }

        @Override
        public final Builder connectionObject(SdkBytes connectionObject) {
            this.connectionObject = connectionObject;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public TestConnectionFunctionRequest build() {
            return new TestConnectionFunctionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
