/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfront.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The configuration IPAM settings that includes the quantity of CIDR configurations and the list of IPAM CIDR
 * configurations.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class IpamConfig implements SdkPojo, Serializable, ToCopyableBuilder<IpamConfig.Builder, IpamConfig> {
    private static final SdkField<Integer> QUANTITY_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("Quantity")
            .getter(getter(IpamConfig::quantity))
            .setter(setter(Builder::quantity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Quantity")
                    .unmarshallLocationName("Quantity").build()).build();

    private static final SdkField<List<IpamCidrConfig>> IPAM_CIDR_CONFIGS_FIELD = SdkField
            .<List<IpamCidrConfig>> builder(MarshallingType.LIST)
            .memberName("IpamCidrConfigs")
            .getter(getter(IpamConfig::ipamCidrConfigs))
            .setter(setter(Builder::ipamCidrConfigs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpamCidrConfigs")
                    .unmarshallLocationName("IpamCidrConfigs").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("IpamCidrConfig")
                            .memberFieldInfo(
                                    SdkField.<IpamCidrConfig> builder(MarshallingType.SDK_POJO)
                                            .constructor(IpamCidrConfig::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("IpamCidrConfig").unmarshallLocationName("IpamCidrConfig")
                                                    .build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(QUANTITY_FIELD,
            IPAM_CIDR_CONFIGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Integer quantity;

    private final List<IpamCidrConfig> ipamCidrConfigs;

    private IpamConfig(BuilderImpl builder) {
        this.quantity = builder.quantity;
        this.ipamCidrConfigs = builder.ipamCidrConfigs;
    }

    /**
     * <p>
     * The number of IPAM CIDR configurations in the <code>IpamCidrConfigs</code> list.
     * </p>
     * 
     * @return The number of IPAM CIDR configurations in the <code>IpamCidrConfigs</code> list.
     */
    public final Integer quantity() {
        return quantity;
    }

    /**
     * For responses, this returns true if the service returned a value for the IpamCidrConfigs property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasIpamCidrConfigs() {
        return ipamCidrConfigs != null && !(ipamCidrConfigs instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of IPAM CIDR configurations that define the IP address ranges, IPAM pools, and associated Anycast IP
     * addresses.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasIpamCidrConfigs} method.
     * </p>
     * 
     * @return A list of IPAM CIDR configurations that define the IP address ranges, IPAM pools, and associated Anycast
     *         IP addresses.
     */
    public final List<IpamCidrConfig> ipamCidrConfigs() {
        return ipamCidrConfigs;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(quantity());
        hashCode = 31 * hashCode + Objects.hashCode(hasIpamCidrConfigs() ? ipamCidrConfigs() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IpamConfig)) {
            return false;
        }
        IpamConfig other = (IpamConfig) obj;
        return Objects.equals(quantity(), other.quantity()) && hasIpamCidrConfigs() == other.hasIpamCidrConfigs()
                && Objects.equals(ipamCidrConfigs(), other.ipamCidrConfigs());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("IpamConfig").add("Quantity", quantity())
                .add("IpamCidrConfigs", hasIpamCidrConfigs() ? ipamCidrConfigs() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Quantity":
            return Optional.ofNullable(clazz.cast(quantity()));
        case "IpamCidrConfigs":
            return Optional.ofNullable(clazz.cast(ipamCidrConfigs()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Quantity", QUANTITY_FIELD);
        map.put("IpamCidrConfigs", IPAM_CIDR_CONFIGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<IpamConfig, T> g) {
        return obj -> g.apply((IpamConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, IpamConfig> {
        /**
         * <p>
         * The number of IPAM CIDR configurations in the <code>IpamCidrConfigs</code> list.
         * </p>
         * 
         * @param quantity
         *        The number of IPAM CIDR configurations in the <code>IpamCidrConfigs</code> list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder quantity(Integer quantity);

        /**
         * <p>
         * A list of IPAM CIDR configurations that define the IP address ranges, IPAM pools, and associated Anycast IP
         * addresses.
         * </p>
         * 
         * @param ipamCidrConfigs
         *        A list of IPAM CIDR configurations that define the IP address ranges, IPAM pools, and associated
         *        Anycast IP addresses.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipamCidrConfigs(Collection<IpamCidrConfig> ipamCidrConfigs);

        /**
         * <p>
         * A list of IPAM CIDR configurations that define the IP address ranges, IPAM pools, and associated Anycast IP
         * addresses.
         * </p>
         * 
         * @param ipamCidrConfigs
         *        A list of IPAM CIDR configurations that define the IP address ranges, IPAM pools, and associated
         *        Anycast IP addresses.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipamCidrConfigs(IpamCidrConfig... ipamCidrConfigs);

        /**
         * <p>
         * A list of IPAM CIDR configurations that define the IP address ranges, IPAM pools, and associated Anycast IP
         * addresses.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.cloudfront.model.IpamCidrConfig.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.cloudfront.model.IpamCidrConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.cloudfront.model.IpamCidrConfig.Builder#build()} is called immediately
         * and its result is passed to {@link #ipamCidrConfigs(List<IpamCidrConfig>)}.
         * 
         * @param ipamCidrConfigs
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.cloudfront.model.IpamCidrConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ipamCidrConfigs(java.util.Collection<IpamCidrConfig>)
         */
        Builder ipamCidrConfigs(Consumer<IpamCidrConfig.Builder>... ipamCidrConfigs);
    }

    static final class BuilderImpl implements Builder {
        private Integer quantity;

        private List<IpamCidrConfig> ipamCidrConfigs = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(IpamConfig model) {
            quantity(model.quantity);
            ipamCidrConfigs(model.ipamCidrConfigs);
        }

        public final Integer getQuantity() {
            return quantity;
        }

        public final void setQuantity(Integer quantity) {
            this.quantity = quantity;
        }

        @Override
        public final Builder quantity(Integer quantity) {
            this.quantity = quantity;
            return this;
        }

        public final List<IpamCidrConfig.Builder> getIpamCidrConfigs() {
            List<IpamCidrConfig.Builder> result = IpamCidrConfigListCopier.copyToBuilder(this.ipamCidrConfigs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setIpamCidrConfigs(Collection<IpamCidrConfig.BuilderImpl> ipamCidrConfigs) {
            this.ipamCidrConfigs = IpamCidrConfigListCopier.copyFromBuilder(ipamCidrConfigs);
        }

        @Override
        public final Builder ipamCidrConfigs(Collection<IpamCidrConfig> ipamCidrConfigs) {
            this.ipamCidrConfigs = IpamCidrConfigListCopier.copy(ipamCidrConfigs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipamCidrConfigs(IpamCidrConfig... ipamCidrConfigs) {
            ipamCidrConfigs(Arrays.asList(ipamCidrConfigs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipamCidrConfigs(Consumer<IpamCidrConfig.Builder>... ipamCidrConfigs) {
            ipamCidrConfigs(Stream.of(ipamCidrConfigs).map(c -> IpamCidrConfig.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public IpamConfig build() {
            return new IpamConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
