/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfront.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Configuration for an IPAM CIDR that defines a specific IP address range, IPAM pool, and associated Anycast IP
 * address.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class IpamCidrConfig implements SdkPojo, Serializable, ToCopyableBuilder<IpamCidrConfig.Builder, IpamCidrConfig> {
    private static final SdkField<String> CIDR_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Cidr")
            .getter(getter(IpamCidrConfig::cidr))
            .setter(setter(Builder::cidr))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Cidr")
                    .unmarshallLocationName("Cidr").build()).build();

    private static final SdkField<String> IPAM_POOL_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("IpamPoolArn")
            .getter(getter(IpamCidrConfig::ipamPoolArn))
            .setter(setter(Builder::ipamPoolArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpamPoolArn")
                    .unmarshallLocationName("IpamPoolArn").build()).build();

    private static final SdkField<String> ANYCAST_IP_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("AnycastIp")
            .getter(getter(IpamCidrConfig::anycastIp))
            .setter(setter(Builder::anycastIp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AnycastIp")
                    .unmarshallLocationName("AnycastIp").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Status")
            .getter(getter(IpamCidrConfig::statusAsString))
            .setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status")
                    .unmarshallLocationName("Status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CIDR_FIELD,
            IPAM_POOL_ARN_FIELD, ANYCAST_IP_FIELD, STATUS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String cidr;

    private final String ipamPoolArn;

    private final String anycastIp;

    private final String status;

    private IpamCidrConfig(BuilderImpl builder) {
        this.cidr = builder.cidr;
        this.ipamPoolArn = builder.ipamPoolArn;
        this.anycastIp = builder.anycastIp;
        this.status = builder.status;
    }

    /**
     * <p>
     * The CIDR that specifies the IP address range for this IPAM configuration.
     * </p>
     * 
     * @return The CIDR that specifies the IP address range for this IPAM configuration.
     */
    public final String cidr() {
        return cidr;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the IPAM pool that the CIDR block is assigned to.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the IPAM pool that the CIDR block is assigned to.
     */
    public final String ipamPoolArn() {
        return ipamPoolArn;
    }

    /**
     * <p>
     * The specified Anycast IP address allocated from the IPAM pool for this CIDR configuration.
     * </p>
     * 
     * @return The specified Anycast IP address allocated from the IPAM pool for this CIDR configuration.
     */
    public final String anycastIp() {
        return anycastIp;
    }

    /**
     * <p>
     * The current status of the IPAM CIDR configuration.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link IpamCidrStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the IPAM CIDR configuration.
     * @see IpamCidrStatus
     */
    public final IpamCidrStatus status() {
        return IpamCidrStatus.fromValue(status);
    }

    /**
     * <p>
     * The current status of the IPAM CIDR configuration.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link IpamCidrStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the IPAM CIDR configuration.
     * @see IpamCidrStatus
     */
    public final String statusAsString() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(cidr());
        hashCode = 31 * hashCode + Objects.hashCode(ipamPoolArn());
        hashCode = 31 * hashCode + Objects.hashCode(anycastIp());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IpamCidrConfig)) {
            return false;
        }
        IpamCidrConfig other = (IpamCidrConfig) obj;
        return Objects.equals(cidr(), other.cidr()) && Objects.equals(ipamPoolArn(), other.ipamPoolArn())
                && Objects.equals(anycastIp(), other.anycastIp()) && Objects.equals(statusAsString(), other.statusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("IpamCidrConfig").add("Cidr", cidr()).add("IpamPoolArn", ipamPoolArn())
                .add("AnycastIp", anycastIp()).add("Status", statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Cidr":
            return Optional.ofNullable(clazz.cast(cidr()));
        case "IpamPoolArn":
            return Optional.ofNullable(clazz.cast(ipamPoolArn()));
        case "AnycastIp":
            return Optional.ofNullable(clazz.cast(anycastIp()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Cidr", CIDR_FIELD);
        map.put("IpamPoolArn", IPAM_POOL_ARN_FIELD);
        map.put("AnycastIp", ANYCAST_IP_FIELD);
        map.put("Status", STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<IpamCidrConfig, T> g) {
        return obj -> g.apply((IpamCidrConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, IpamCidrConfig> {
        /**
         * <p>
         * The CIDR that specifies the IP address range for this IPAM configuration.
         * </p>
         * 
         * @param cidr
         *        The CIDR that specifies the IP address range for this IPAM configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cidr(String cidr);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the IPAM pool that the CIDR block is assigned to.
         * </p>
         * 
         * @param ipamPoolArn
         *        The Amazon Resource Name (ARN) of the IPAM pool that the CIDR block is assigned to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipamPoolArn(String ipamPoolArn);

        /**
         * <p>
         * The specified Anycast IP address allocated from the IPAM pool for this CIDR configuration.
         * </p>
         * 
         * @param anycastIp
         *        The specified Anycast IP address allocated from the IPAM pool for this CIDR configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder anycastIp(String anycastIp);

        /**
         * <p>
         * The current status of the IPAM CIDR configuration.
         * </p>
         * 
         * @param status
         *        The current status of the IPAM CIDR configuration.
         * @see IpamCidrStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IpamCidrStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The current status of the IPAM CIDR configuration.
         * </p>
         * 
         * @param status
         *        The current status of the IPAM CIDR configuration.
         * @see IpamCidrStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IpamCidrStatus
         */
        Builder status(IpamCidrStatus status);
    }

    static final class BuilderImpl implements Builder {
        private String cidr;

        private String ipamPoolArn;

        private String anycastIp;

        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(IpamCidrConfig model) {
            cidr(model.cidr);
            ipamPoolArn(model.ipamPoolArn);
            anycastIp(model.anycastIp);
            status(model.status);
        }

        public final String getCidr() {
            return cidr;
        }

        public final void setCidr(String cidr) {
            this.cidr = cidr;
        }

        @Override
        public final Builder cidr(String cidr) {
            this.cidr = cidr;
            return this;
        }

        public final String getIpamPoolArn() {
            return ipamPoolArn;
        }

        public final void setIpamPoolArn(String ipamPoolArn) {
            this.ipamPoolArn = ipamPoolArn;
        }

        @Override
        public final Builder ipamPoolArn(String ipamPoolArn) {
            this.ipamPoolArn = ipamPoolArn;
            return this;
        }

        public final String getAnycastIp() {
            return anycastIp;
        }

        public final void setAnycastIp(String anycastIp) {
            this.anycastIp = anycastIp;
        }

        @Override
        public final Builder anycastIp(String anycastIp) {
            this.anycastIp = anycastIp;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(IpamCidrStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        @Override
        public IpamCidrConfig build() {
            return new IpamCidrConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
