/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfront.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreatePublicKeyRequest extends CloudFrontRequest implements
        ToCopyableBuilder<CreatePublicKeyRequest.Builder, CreatePublicKeyRequest> {
    private static final SdkField<PublicKeyConfig> PUBLIC_KEY_CONFIG_FIELD = SdkField
            .<PublicKeyConfig> builder(MarshallingType.SDK_POJO)
            .memberName("PublicKeyConfig")
            .getter(getter(CreatePublicKeyRequest::publicKeyConfig))
            .setter(setter(Builder::publicKeyConfig))
            .constructor(PublicKeyConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PublicKeyConfig")
                    .unmarshallLocationName("PublicKeyConfig").build(), PayloadTrait.create()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PUBLIC_KEY_CONFIG_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final PublicKeyConfig publicKeyConfig;

    private CreatePublicKeyRequest(BuilderImpl builder) {
        super(builder);
        this.publicKeyConfig = builder.publicKeyConfig;
    }

    /**
     * <p>
     * A CloudFront public key configuration.
     * </p>
     * 
     * @return A CloudFront public key configuration.
     */
    public final PublicKeyConfig publicKeyConfig() {
        return publicKeyConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(publicKeyConfig());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreatePublicKeyRequest)) {
            return false;
        }
        CreatePublicKeyRequest other = (CreatePublicKeyRequest) obj;
        return Objects.equals(publicKeyConfig(), other.publicKeyConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreatePublicKeyRequest").add("PublicKeyConfig", publicKeyConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PublicKeyConfig":
            return Optional.ofNullable(clazz.cast(publicKeyConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("PublicKeyConfig", PUBLIC_KEY_CONFIG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreatePublicKeyRequest, T> g) {
        return obj -> g.apply((CreatePublicKeyRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends CloudFrontRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreatePublicKeyRequest> {
        /**
         * <p>
         * A CloudFront public key configuration.
         * </p>
         * 
         * @param publicKeyConfig
         *        A CloudFront public key configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder publicKeyConfig(PublicKeyConfig publicKeyConfig);

        /**
         * <p>
         * A CloudFront public key configuration.
         * </p>
         * This is a convenience method that creates an instance of the {@link PublicKeyConfig.Builder} avoiding the
         * need to create one manually via {@link PublicKeyConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PublicKeyConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #publicKeyConfig(PublicKeyConfig)}.
         * 
         * @param publicKeyConfig
         *        a consumer that will call methods on {@link PublicKeyConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #publicKeyConfig(PublicKeyConfig)
         */
        default Builder publicKeyConfig(Consumer<PublicKeyConfig.Builder> publicKeyConfig) {
            return publicKeyConfig(PublicKeyConfig.builder().applyMutation(publicKeyConfig).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CloudFrontRequest.BuilderImpl implements Builder {
        private PublicKeyConfig publicKeyConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(CreatePublicKeyRequest model) {
            super(model);
            publicKeyConfig(model.publicKeyConfig);
        }

        public final PublicKeyConfig.Builder getPublicKeyConfig() {
            return publicKeyConfig != null ? publicKeyConfig.toBuilder() : null;
        }

        public final void setPublicKeyConfig(PublicKeyConfig.BuilderImpl publicKeyConfig) {
            this.publicKeyConfig = publicKeyConfig != null ? publicKeyConfig.build() : null;
        }

        @Override
        public final Builder publicKeyConfig(PublicKeyConfig publicKeyConfig) {
            this.publicKeyConfig = publicKeyConfig;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreatePublicKeyRequest build() {
            return new CreatePublicKeyRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
