/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfront.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateAnycastIpListRequest extends CloudFrontRequest implements
        ToCopyableBuilder<CreateAnycastIpListRequest.Builder, CreateAnycastIpListRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Name")
            .getter(getter(CreateAnycastIpListRequest::name))
            .setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name")
                    .unmarshallLocationName("Name").build()).build();

    private static final SdkField<Integer> IP_COUNT_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("IpCount")
            .getter(getter(CreateAnycastIpListRequest::ipCount))
            .setter(setter(Builder::ipCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpCount")
                    .unmarshallLocationName("IpCount").build()).build();

    private static final SdkField<Tags> TAGS_FIELD = SdkField
            .<Tags> builder(MarshallingType.SDK_POJO)
            .memberName("Tags")
            .getter(getter(CreateAnycastIpListRequest::tags))
            .setter(setter(Builder::tags))
            .constructor(Tags::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags")
                    .unmarshallLocationName("Tags").build()).build();

    private static final SdkField<String> IP_ADDRESS_TYPE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("IpAddressType")
            .getter(getter(CreateAnycastIpListRequest::ipAddressTypeAsString))
            .setter(setter(Builder::ipAddressType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpAddressType")
                    .unmarshallLocationName("IpAddressType").build()).build();

    private static final SdkField<List<IpamCidrConfig>> IPAM_CIDR_CONFIGS_FIELD = SdkField
            .<List<IpamCidrConfig>> builder(MarshallingType.LIST)
            .memberName("IpamCidrConfigs")
            .getter(getter(CreateAnycastIpListRequest::ipamCidrConfigs))
            .setter(setter(Builder::ipamCidrConfigs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpamCidrConfigs")
                    .unmarshallLocationName("IpamCidrConfigs").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("IpamCidrConfig")
                            .memberFieldInfo(
                                    SdkField.<IpamCidrConfig> builder(MarshallingType.SDK_POJO)
                                            .constructor(IpamCidrConfig::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("IpamCidrConfig").unmarshallLocationName("IpamCidrConfig")
                                                    .build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, IP_COUNT_FIELD,
            TAGS_FIELD, IP_ADDRESS_TYPE_FIELD, IPAM_CIDR_CONFIGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String name;

    private final Integer ipCount;

    private final Tags tags;

    private final String ipAddressType;

    private final List<IpamCidrConfig> ipamCidrConfigs;

    private CreateAnycastIpListRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.ipCount = builder.ipCount;
        this.tags = builder.tags;
        this.ipAddressType = builder.ipAddressType;
        this.ipamCidrConfigs = builder.ipamCidrConfigs;
    }

    /**
     * <p>
     * Name of the Anycast static IP list.
     * </p>
     * 
     * @return Name of the Anycast static IP list.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The number of static IP addresses that are allocated to the Anycast static IP list. Valid values: 21 or 3.
     * </p>
     * 
     * @return The number of static IP addresses that are allocated to the Anycast static IP list. Valid values: 21 or
     *         3.
     */
    public final Integer ipCount() {
        return ipCount;
    }

    /**
     * Returns the value of the Tags property for this object.
     * 
     * @return The value of the Tags property for this object.
     */
    public final Tags tags() {
        return tags;
    }

    /**
     * <p>
     * The IP address type for the Anycast static IP list. You can specify one of the following options:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ipv4</code> only
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ipv6</code> only
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>dualstack</code> - Allocate a list of both IPv4 and IPv6 addresses
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #ipAddressType}
     * will return {@link IpAddressType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #ipAddressTypeAsString}.
     * </p>
     * 
     * @return The IP address type for the Anycast static IP list. You can specify one of the following options:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ipv4</code> only
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ipv6</code> only
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>dualstack</code> - Allocate a list of both IPv4 and IPv6 addresses
     *         </p>
     *         </li>
     * @see IpAddressType
     */
    public final IpAddressType ipAddressType() {
        return IpAddressType.fromValue(ipAddressType);
    }

    /**
     * <p>
     * The IP address type for the Anycast static IP list. You can specify one of the following options:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ipv4</code> only
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ipv6</code> only
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>dualstack</code> - Allocate a list of both IPv4 and IPv6 addresses
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #ipAddressType}
     * will return {@link IpAddressType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #ipAddressTypeAsString}.
     * </p>
     * 
     * @return The IP address type for the Anycast static IP list. You can specify one of the following options:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ipv4</code> only
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ipv6</code> only
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>dualstack</code> - Allocate a list of both IPv4 and IPv6 addresses
     *         </p>
     *         </li>
     * @see IpAddressType
     */
    public final String ipAddressTypeAsString() {
        return ipAddressType;
    }

    /**
     * For responses, this returns true if the service returned a value for the IpamCidrConfigs property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasIpamCidrConfigs() {
        return ipamCidrConfigs != null && !(ipamCidrConfigs instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of IPAM CIDR configurations that specify the IP address ranges and IPAM pool settings for creating the
     * Anycast static IP list.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasIpamCidrConfigs} method.
     * </p>
     * 
     * @return A list of IPAM CIDR configurations that specify the IP address ranges and IPAM pool settings for creating
     *         the Anycast static IP list.
     */
    public final List<IpamCidrConfig> ipamCidrConfigs() {
        return ipamCidrConfigs;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(ipCount());
        hashCode = 31 * hashCode + Objects.hashCode(tags());
        hashCode = 31 * hashCode + Objects.hashCode(ipAddressTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasIpamCidrConfigs() ? ipamCidrConfigs() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateAnycastIpListRequest)) {
            return false;
        }
        CreateAnycastIpListRequest other = (CreateAnycastIpListRequest) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(ipCount(), other.ipCount())
                && Objects.equals(tags(), other.tags()) && Objects.equals(ipAddressTypeAsString(), other.ipAddressTypeAsString())
                && hasIpamCidrConfigs() == other.hasIpamCidrConfigs()
                && Objects.equals(ipamCidrConfigs(), other.ipamCidrConfigs());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateAnycastIpListRequest").add("Name", name()).add("IpCount", ipCount()).add("Tags", tags())
                .add("IpAddressType", ipAddressTypeAsString())
                .add("IpamCidrConfigs", hasIpamCidrConfigs() ? ipamCidrConfigs() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "IpCount":
            return Optional.ofNullable(clazz.cast(ipCount()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "IpAddressType":
            return Optional.ofNullable(clazz.cast(ipAddressTypeAsString()));
        case "IpamCidrConfigs":
            return Optional.ofNullable(clazz.cast(ipamCidrConfigs()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Name", NAME_FIELD);
        map.put("IpCount", IP_COUNT_FIELD);
        map.put("Tags", TAGS_FIELD);
        map.put("IpAddressType", IP_ADDRESS_TYPE_FIELD);
        map.put("IpamCidrConfigs", IPAM_CIDR_CONFIGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateAnycastIpListRequest, T> g) {
        return obj -> g.apply((CreateAnycastIpListRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends CloudFrontRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateAnycastIpListRequest> {
        /**
         * <p>
         * Name of the Anycast static IP list.
         * </p>
         * 
         * @param name
         *        Name of the Anycast static IP list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The number of static IP addresses that are allocated to the Anycast static IP list. Valid values: 21 or 3.
         * </p>
         * 
         * @param ipCount
         *        The number of static IP addresses that are allocated to the Anycast static IP list. Valid values: 21
         *        or 3.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipCount(Integer ipCount);

        /**
         * Sets the value of the Tags property for this object.
         *
         * @param tags
         *        The new value for the Tags property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tags tags);

        /**
         * Sets the value of the Tags property for this object.
         *
         * This is a convenience method that creates an instance of the {@link Tags.Builder} avoiding the need to create
         * one manually via {@link Tags#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Tags.Builder#build()} is called immediately and its result is
         * passed to {@link #tags(Tags)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link Tags.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(Tags)
         */
        default Builder tags(Consumer<Tags.Builder> tags) {
            return tags(Tags.builder().applyMutation(tags).build());
        }

        /**
         * <p>
         * The IP address type for the Anycast static IP list. You can specify one of the following options:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ipv4</code> only
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ipv6</code> only
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>dualstack</code> - Allocate a list of both IPv4 and IPv6 addresses
         * </p>
         * </li>
         * </ul>
         * 
         * @param ipAddressType
         *        The IP address type for the Anycast static IP list. You can specify one of the following options:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ipv4</code> only
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ipv6</code> only
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>dualstack</code> - Allocate a list of both IPv4 and IPv6 addresses
         *        </p>
         *        </li>
         * @see IpAddressType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IpAddressType
         */
        Builder ipAddressType(String ipAddressType);

        /**
         * <p>
         * The IP address type for the Anycast static IP list. You can specify one of the following options:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ipv4</code> only
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ipv6</code> only
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>dualstack</code> - Allocate a list of both IPv4 and IPv6 addresses
         * </p>
         * </li>
         * </ul>
         * 
         * @param ipAddressType
         *        The IP address type for the Anycast static IP list. You can specify one of the following options:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ipv4</code> only
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ipv6</code> only
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>dualstack</code> - Allocate a list of both IPv4 and IPv6 addresses
         *        </p>
         *        </li>
         * @see IpAddressType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IpAddressType
         */
        Builder ipAddressType(IpAddressType ipAddressType);

        /**
         * <p>
         * A list of IPAM CIDR configurations that specify the IP address ranges and IPAM pool settings for creating the
         * Anycast static IP list.
         * </p>
         * 
         * @param ipamCidrConfigs
         *        A list of IPAM CIDR configurations that specify the IP address ranges and IPAM pool settings for
         *        creating the Anycast static IP list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipamCidrConfigs(Collection<IpamCidrConfig> ipamCidrConfigs);

        /**
         * <p>
         * A list of IPAM CIDR configurations that specify the IP address ranges and IPAM pool settings for creating the
         * Anycast static IP list.
         * </p>
         * 
         * @param ipamCidrConfigs
         *        A list of IPAM CIDR configurations that specify the IP address ranges and IPAM pool settings for
         *        creating the Anycast static IP list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipamCidrConfigs(IpamCidrConfig... ipamCidrConfigs);

        /**
         * <p>
         * A list of IPAM CIDR configurations that specify the IP address ranges and IPAM pool settings for creating the
         * Anycast static IP list.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.cloudfront.model.IpamCidrConfig.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.cloudfront.model.IpamCidrConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.cloudfront.model.IpamCidrConfig.Builder#build()} is called immediately
         * and its result is passed to {@link #ipamCidrConfigs(List<IpamCidrConfig>)}.
         * 
         * @param ipamCidrConfigs
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.cloudfront.model.IpamCidrConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ipamCidrConfigs(java.util.Collection<IpamCidrConfig>)
         */
        Builder ipamCidrConfigs(Consumer<IpamCidrConfig.Builder>... ipamCidrConfigs);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CloudFrontRequest.BuilderImpl implements Builder {
        private String name;

        private Integer ipCount;

        private Tags tags;

        private String ipAddressType;

        private List<IpamCidrConfig> ipamCidrConfigs = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateAnycastIpListRequest model) {
            super(model);
            name(model.name);
            ipCount(model.ipCount);
            tags(model.tags);
            ipAddressType(model.ipAddressType);
            ipamCidrConfigs(model.ipamCidrConfigs);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Integer getIpCount() {
            return ipCount;
        }

        public final void setIpCount(Integer ipCount) {
            this.ipCount = ipCount;
        }

        @Override
        public final Builder ipCount(Integer ipCount) {
            this.ipCount = ipCount;
            return this;
        }

        public final Tags.Builder getTags() {
            return tags != null ? tags.toBuilder() : null;
        }

        public final void setTags(Tags.BuilderImpl tags) {
            this.tags = tags != null ? tags.build() : null;
        }

        @Override
        public final Builder tags(Tags tags) {
            this.tags = tags;
            return this;
        }

        public final String getIpAddressType() {
            return ipAddressType;
        }

        public final void setIpAddressType(String ipAddressType) {
            this.ipAddressType = ipAddressType;
        }

        @Override
        public final Builder ipAddressType(String ipAddressType) {
            this.ipAddressType = ipAddressType;
            return this;
        }

        @Override
        public final Builder ipAddressType(IpAddressType ipAddressType) {
            this.ipAddressType(ipAddressType == null ? null : ipAddressType.toString());
            return this;
        }

        public final List<IpamCidrConfig.Builder> getIpamCidrConfigs() {
            List<IpamCidrConfig.Builder> result = IpamCidrConfigListCopier.copyToBuilder(this.ipamCidrConfigs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setIpamCidrConfigs(Collection<IpamCidrConfig.BuilderImpl> ipamCidrConfigs) {
            this.ipamCidrConfigs = IpamCidrConfigListCopier.copyFromBuilder(ipamCidrConfigs);
        }

        @Override
        public final Builder ipamCidrConfigs(Collection<IpamCidrConfig> ipamCidrConfigs) {
            this.ipamCidrConfigs = IpamCidrConfigListCopier.copy(ipamCidrConfigs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipamCidrConfigs(IpamCidrConfig... ipamCidrConfigs) {
            ipamCidrConfigs(Arrays.asList(ipamCidrConfigs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipamCidrConfigs(Consumer<IpamCidrConfig.Builder>... ipamCidrConfigs) {
            ipamCidrConfigs(Stream.of(ipamCidrConfigs).map(c -> IpamCidrConfig.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateAnycastIpListRequest build() {
            return new CreateAnycastIpListRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
