/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cloudfront.model.CloudFrontRequest;
import software.amazon.awssdk.services.cloudfront.model.ResponseHeadersPolicyConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateResponseHeadersPolicyRequest
extends CloudFrontRequest
implements ToCopyableBuilder<Builder, CreateResponseHeadersPolicyRequest> {
    private static final SdkField<ResponseHeadersPolicyConfig> RESPONSE_HEADERS_POLICY_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ResponseHeadersPolicyConfig").getter(CreateResponseHeadersPolicyRequest.getter(CreateResponseHeadersPolicyRequest::responseHeadersPolicyConfig)).setter(CreateResponseHeadersPolicyRequest.setter(Builder::responseHeadersPolicyConfig)).constructor(ResponseHeadersPolicyConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResponseHeadersPolicyConfig").unmarshallLocationName("ResponseHeadersPolicyConfig").build(), PayloadTrait.create()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESPONSE_HEADERS_POLICY_CONFIG_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateResponseHeadersPolicyRequest.memberNameToFieldInitializer();
    private final ResponseHeadersPolicyConfig responseHeadersPolicyConfig;

    private CreateResponseHeadersPolicyRequest(BuilderImpl builder) {
        super(builder);
        this.responseHeadersPolicyConfig = builder.responseHeadersPolicyConfig;
    }

    public final ResponseHeadersPolicyConfig responseHeadersPolicyConfig() {
        return this.responseHeadersPolicyConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.responseHeadersPolicyConfig());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateResponseHeadersPolicyRequest)) {
            return false;
        }
        CreateResponseHeadersPolicyRequest other = (CreateResponseHeadersPolicyRequest)((Object)obj);
        return Objects.equals(this.responseHeadersPolicyConfig(), other.responseHeadersPolicyConfig());
    }

    public final String toString() {
        return ToString.builder((String)"CreateResponseHeadersPolicyRequest").add("ResponseHeadersPolicyConfig", (Object)this.responseHeadersPolicyConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ResponseHeadersPolicyConfig": {
                return Optional.ofNullable(clazz.cast(this.responseHeadersPolicyConfig()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<ResponseHeadersPolicyConfig>> map = new HashMap<String, SdkField<ResponseHeadersPolicyConfig>>();
        map.put("ResponseHeadersPolicyConfig", RESPONSE_HEADERS_POLICY_CONFIG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateResponseHeadersPolicyRequest, T> g) {
        return obj -> g.apply((CreateResponseHeadersPolicyRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudFrontRequest.BuilderImpl
    implements Builder {
        private ResponseHeadersPolicyConfig responseHeadersPolicyConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateResponseHeadersPolicyRequest model) {
            super(model);
            this.responseHeadersPolicyConfig(model.responseHeadersPolicyConfig);
        }

        public final ResponseHeadersPolicyConfig.Builder getResponseHeadersPolicyConfig() {
            return this.responseHeadersPolicyConfig != null ? this.responseHeadersPolicyConfig.toBuilder() : null;
        }

        public final void setResponseHeadersPolicyConfig(ResponseHeadersPolicyConfig.BuilderImpl responseHeadersPolicyConfig) {
            this.responseHeadersPolicyConfig = responseHeadersPolicyConfig != null ? responseHeadersPolicyConfig.build() : null;
        }

        @Override
        public final Builder responseHeadersPolicyConfig(ResponseHeadersPolicyConfig responseHeadersPolicyConfig) {
            this.responseHeadersPolicyConfig = responseHeadersPolicyConfig;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateResponseHeadersPolicyRequest build() {
            return new CreateResponseHeadersPolicyRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends CloudFrontRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateResponseHeadersPolicyRequest> {
        public Builder responseHeadersPolicyConfig(ResponseHeadersPolicyConfig var1);

        default public Builder responseHeadersPolicyConfig(Consumer<ResponseHeadersPolicyConfig.Builder> responseHeadersPolicyConfig) {
            return this.responseHeadersPolicyConfig((ResponseHeadersPolicyConfig)((ResponseHeadersPolicyConfig.Builder)ResponseHeadersPolicyConfig.builder().applyMutation(responseHeadersPolicyConfig)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

