/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cloudfront.model.EndPoint;
import software.amazon.awssdk.services.cloudfront.model.EndPointListCopier;
import software.amazon.awssdk.services.cloudfront.model.FieldListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RealtimeLogConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RealtimeLogConfig> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ARN").getter(RealtimeLogConfig.getter(RealtimeLogConfig::arn)).setter(RealtimeLogConfig.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ARN").unmarshallLocationName("ARN").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(RealtimeLogConfig.getter(RealtimeLogConfig::name)).setter(RealtimeLogConfig.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").unmarshallLocationName("Name").build()}).build();
    private static final SdkField<Long> SAMPLING_RATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("SamplingRate").getter(RealtimeLogConfig.getter(RealtimeLogConfig::samplingRate)).setter(RealtimeLogConfig.setter(Builder::samplingRate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SamplingRate").unmarshallLocationName("SamplingRate").build()}).build();
    private static final SdkField<List<EndPoint>> END_POINTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("EndPoints").getter(RealtimeLogConfig.getter(RealtimeLogConfig::endPoints)).setter(RealtimeLogConfig.setter(Builder::endPoints)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndPoints").unmarshallLocationName("EndPoints").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(EndPoint::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").unmarshallLocationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> FIELDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Fields").getter(RealtimeLogConfig.getter(RealtimeLogConfig::fields)).setter(RealtimeLogConfig.setter(Builder::fields)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Fields").unmarshallLocationName("Fields").build(), ListTrait.builder().memberLocationName("Field").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Field").unmarshallLocationName("Field").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, NAME_FIELD, SAMPLING_RATE_FIELD, END_POINTS_FIELD, FIELDS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = RealtimeLogConfig.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String arn;
    private final String name;
    private final Long samplingRate;
    private final List<EndPoint> endPoints;
    private final List<String> fields;

    private RealtimeLogConfig(BuilderImpl builder) {
        this.arn = builder.arn;
        this.name = builder.name;
        this.samplingRate = builder.samplingRate;
        this.endPoints = builder.endPoints;
        this.fields = builder.fields;
    }

    public final String arn() {
        return this.arn;
    }

    public final String name() {
        return this.name;
    }

    public final Long samplingRate() {
        return this.samplingRate;
    }

    public final boolean hasEndPoints() {
        return this.endPoints != null && !(this.endPoints instanceof SdkAutoConstructList);
    }

    public final List<EndPoint> endPoints() {
        return this.endPoints;
    }

    public final boolean hasFields() {
        return this.fields != null && !(this.fields instanceof SdkAutoConstructList);
    }

    public final List<String> fields() {
        return this.fields;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.samplingRate());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEndPoints() ? this.endPoints() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFields() ? this.fields() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RealtimeLogConfig)) {
            return false;
        }
        RealtimeLogConfig other = (RealtimeLogConfig)obj;
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.samplingRate(), other.samplingRate()) && this.hasEndPoints() == other.hasEndPoints() && Objects.equals(this.endPoints(), other.endPoints()) && this.hasFields() == other.hasFields() && Objects.equals(this.fields(), other.fields());
    }

    public final String toString() {
        return ToString.builder((String)"RealtimeLogConfig").add("ARN", (Object)this.arn()).add("Name", (Object)this.name()).add("SamplingRate", (Object)this.samplingRate()).add("EndPoints", this.hasEndPoints() ? this.endPoints() : null).add("Fields", this.hasFields() ? this.fields() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ARN": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "SamplingRate": {
                return Optional.ofNullable(clazz.cast(this.samplingRate()));
            }
            case "EndPoints": {
                return Optional.ofNullable(clazz.cast(this.endPoints()));
            }
            case "Fields": {
                return Optional.ofNullable(clazz.cast(this.fields()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ARN", ARN_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("SamplingRate", SAMPLING_RATE_FIELD);
        map.put("EndPoints", END_POINTS_FIELD);
        map.put("Fields", FIELDS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RealtimeLogConfig, T> g) {
        return obj -> g.apply((RealtimeLogConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String arn;
        private String name;
        private Long samplingRate;
        private List<EndPoint> endPoints = DefaultSdkAutoConstructList.getInstance();
        private List<String> fields = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RealtimeLogConfig model) {
            this.arn(model.arn);
            this.name(model.name);
            this.samplingRate(model.samplingRate);
            this.endPoints(model.endPoints);
            this.fields(model.fields);
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Long getSamplingRate() {
            return this.samplingRate;
        }

        public final void setSamplingRate(Long samplingRate) {
            this.samplingRate = samplingRate;
        }

        @Override
        public final Builder samplingRate(Long samplingRate) {
            this.samplingRate = samplingRate;
            return this;
        }

        public final List<EndPoint.Builder> getEndPoints() {
            List<EndPoint.Builder> result = EndPointListCopier.copyToBuilder(this.endPoints);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEndPoints(Collection<EndPoint.BuilderImpl> endPoints) {
            this.endPoints = EndPointListCopier.copyFromBuilder(endPoints);
        }

        @Override
        public final Builder endPoints(Collection<EndPoint> endPoints) {
            this.endPoints = EndPointListCopier.copy(endPoints);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder endPoints(EndPoint ... endPoints) {
            this.endPoints(Arrays.asList(endPoints));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder endPoints(Consumer<EndPoint.Builder> ... endPoints) {
            this.endPoints(Stream.of(endPoints).map(c -> (EndPoint)((EndPoint.Builder)EndPoint.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getFields() {
            if (this.fields instanceof SdkAutoConstructList) {
                return null;
            }
            return this.fields;
        }

        public final void setFields(Collection<String> fields) {
            this.fields = FieldListCopier.copy(fields);
        }

        @Override
        public final Builder fields(Collection<String> fields) {
            this.fields = FieldListCopier.copy(fields);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fields(String ... fields) {
            this.fields(Arrays.asList(fields));
            return this;
        }

        public RealtimeLogConfig build() {
            return new RealtimeLogConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RealtimeLogConfig> {
        public Builder arn(String var1);

        public Builder name(String var1);

        public Builder samplingRate(Long var1);

        public Builder endPoints(Collection<EndPoint> var1);

        public Builder endPoints(EndPoint ... var1);

        public Builder endPoints(Consumer<EndPoint.Builder> ... var1);

        public Builder fields(Collection<String> var1);

        public Builder fields(String ... var1);
    }
}

