/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cloudfront.model.CloudFrontResponse;
import software.amazon.awssdk.services.cloudfront.model.DistributionList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListDistributionsByAnycastIpListIdResponse
extends CloudFrontResponse
implements ToCopyableBuilder<Builder, ListDistributionsByAnycastIpListIdResponse> {
    private static final SdkField<DistributionList> DISTRIBUTION_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DistributionList").getter(ListDistributionsByAnycastIpListIdResponse.getter(ListDistributionsByAnycastIpListIdResponse::distributionList)).setter(ListDistributionsByAnycastIpListIdResponse.setter(Builder::distributionList)).constructor(DistributionList::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DistributionList").unmarshallLocationName("DistributionList").build(), PayloadTrait.create()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DISTRIBUTION_LIST_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListDistributionsByAnycastIpListIdResponse.memberNameToFieldInitializer();
    private final DistributionList distributionList;

    private ListDistributionsByAnycastIpListIdResponse(BuilderImpl builder) {
        super(builder);
        this.distributionList = builder.distributionList;
    }

    public final DistributionList distributionList() {
        return this.distributionList;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.distributionList());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDistributionsByAnycastIpListIdResponse)) {
            return false;
        }
        ListDistributionsByAnycastIpListIdResponse other = (ListDistributionsByAnycastIpListIdResponse)((Object)obj);
        return Objects.equals(this.distributionList(), other.distributionList());
    }

    public final String toString() {
        return ToString.builder((String)"ListDistributionsByAnycastIpListIdResponse").add("DistributionList", (Object)this.distributionList()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DistributionList": {
                return Optional.ofNullable(clazz.cast(this.distributionList()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<DistributionList>> map = new HashMap<String, SdkField<DistributionList>>();
        map.put("DistributionList", DISTRIBUTION_LIST_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListDistributionsByAnycastIpListIdResponse, T> g) {
        return obj -> g.apply((ListDistributionsByAnycastIpListIdResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudFrontResponse.BuilderImpl
    implements Builder {
        private DistributionList distributionList;

        private BuilderImpl() {
        }

        private BuilderImpl(ListDistributionsByAnycastIpListIdResponse model) {
            super(model);
            this.distributionList(model.distributionList);
        }

        public final DistributionList.Builder getDistributionList() {
            return this.distributionList != null ? this.distributionList.toBuilder() : null;
        }

        public final void setDistributionList(DistributionList.BuilderImpl distributionList) {
            this.distributionList = distributionList != null ? distributionList.build() : null;
        }

        @Override
        public final Builder distributionList(DistributionList distributionList) {
            this.distributionList = distributionList;
            return this;
        }

        @Override
        public ListDistributionsByAnycastIpListIdResponse build() {
            return new ListDistributionsByAnycastIpListIdResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends CloudFrontResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListDistributionsByAnycastIpListIdResponse> {
        public Builder distributionList(DistributionList var1);

        default public Builder distributionList(Consumer<DistributionList.Builder> distributionList) {
            return this.distributionList((DistributionList)((DistributionList.Builder)DistributionList.builder().applyMutation(distributionList)).build());
        }
    }
}

