/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfront.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about what CloudFront resources your connection groups are associated with.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ConnectionGroupAssociationFilter implements SdkPojo, Serializable,
        ToCopyableBuilder<ConnectionGroupAssociationFilter.Builder, ConnectionGroupAssociationFilter> {
    private static final SdkField<String> ANYCAST_IP_LIST_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("AnycastIpListId")
            .getter(getter(ConnectionGroupAssociationFilter::anycastIpListId))
            .setter(setter(Builder::anycastIpListId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AnycastIpListId")
                    .unmarshallLocationName("AnycastIpListId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ANYCAST_IP_LIST_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String anycastIpListId;

    private ConnectionGroupAssociationFilter(BuilderImpl builder) {
        this.anycastIpListId = builder.anycastIpListId;
    }

    /**
     * <p>
     * The ID of the Anycast static IP list.
     * </p>
     * 
     * @return The ID of the Anycast static IP list.
     */
    public final String anycastIpListId() {
        return anycastIpListId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(anycastIpListId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConnectionGroupAssociationFilter)) {
            return false;
        }
        ConnectionGroupAssociationFilter other = (ConnectionGroupAssociationFilter) obj;
        return Objects.equals(anycastIpListId(), other.anycastIpListId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ConnectionGroupAssociationFilter").add("AnycastIpListId", anycastIpListId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AnycastIpListId":
            return Optional.ofNullable(clazz.cast(anycastIpListId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AnycastIpListId", ANYCAST_IP_LIST_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ConnectionGroupAssociationFilter, T> g) {
        return obj -> g.apply((ConnectionGroupAssociationFilter) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ConnectionGroupAssociationFilter> {
        /**
         * <p>
         * The ID of the Anycast static IP list.
         * </p>
         * 
         * @param anycastIpListId
         *        The ID of the Anycast static IP list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder anycastIpListId(String anycastIpListId);
    }

    static final class BuilderImpl implements Builder {
        private String anycastIpListId;

        private BuilderImpl() {
        }

        private BuilderImpl(ConnectionGroupAssociationFilter model) {
            anycastIpListId(model.anycastIpListId);
        }

        public final String getAnycastIpListId() {
            return anycastIpListId;
        }

        public final void setAnycastIpListId(String anycastIpListId) {
            this.anycastIpListId = anycastIpListId;
        }

        @Override
        public final Builder anycastIpListId(String anycastIpListId) {
            this.anycastIpListId = anycastIpListId;
            return this;
        }

        @Override
        public ConnectionGroupAssociationFilter build() {
            return new ConnectionGroupAssociationFilter(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
