/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfront.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class AssociateAliasRequest extends CloudFrontRequest implements
        ToCopyableBuilder<AssociateAliasRequest.Builder, AssociateAliasRequest> {
    private static final SdkField<String> TARGET_DISTRIBUTION_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("TargetDistributionId")
            .getter(getter(AssociateAliasRequest::targetDistributionId))
            .setter(setter(Builder::targetDistributionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("TargetDistributionId")
                    .unmarshallLocationName("TargetDistributionId").build()).build();

    private static final SdkField<String> ALIAS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Alias")
            .getter(getter(AssociateAliasRequest::alias))
            .setter(setter(Builder::alias))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("Alias")
                    .unmarshallLocationName("Alias").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TARGET_DISTRIBUTION_ID_FIELD,
            ALIAS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String targetDistributionId;

    private final String alias;

    private AssociateAliasRequest(BuilderImpl builder) {
        super(builder);
        this.targetDistributionId = builder.targetDistributionId;
        this.alias = builder.alias;
    }

    /**
     * <p>
     * The ID of the distribution that you're associating the alias with.
     * </p>
     * 
     * @return The ID of the distribution that you're associating the alias with.
     */
    public final String targetDistributionId() {
        return targetDistributionId;
    }

    /**
     * <p>
     * The alias (also known as a CNAME) to add to the target distribution.
     * </p>
     * 
     * @return The alias (also known as a CNAME) to add to the target distribution.
     */
    public final String alias() {
        return alias;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(targetDistributionId());
        hashCode = 31 * hashCode + Objects.hashCode(alias());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssociateAliasRequest)) {
            return false;
        }
        AssociateAliasRequest other = (AssociateAliasRequest) obj;
        return Objects.equals(targetDistributionId(), other.targetDistributionId()) && Objects.equals(alias(), other.alias());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AssociateAliasRequest").add("TargetDistributionId", targetDistributionId())
                .add("Alias", alias()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TargetDistributionId":
            return Optional.ofNullable(clazz.cast(targetDistributionId()));
        case "Alias":
            return Optional.ofNullable(clazz.cast(alias()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("TargetDistributionId", TARGET_DISTRIBUTION_ID_FIELD);
        map.put("Alias", ALIAS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AssociateAliasRequest, T> g) {
        return obj -> g.apply((AssociateAliasRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends CloudFrontRequest.Builder, SdkPojo, CopyableBuilder<Builder, AssociateAliasRequest> {
        /**
         * <p>
         * The ID of the distribution that you're associating the alias with.
         * </p>
         * 
         * @param targetDistributionId
         *        The ID of the distribution that you're associating the alias with.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetDistributionId(String targetDistributionId);

        /**
         * <p>
         * The alias (also known as a CNAME) to add to the target distribution.
         * </p>
         * 
         * @param alias
         *        The alias (also known as a CNAME) to add to the target distribution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder alias(String alias);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CloudFrontRequest.BuilderImpl implements Builder {
        private String targetDistributionId;

        private String alias;

        private BuilderImpl() {
        }

        private BuilderImpl(AssociateAliasRequest model) {
            super(model);
            targetDistributionId(model.targetDistributionId);
            alias(model.alias);
        }

        public final String getTargetDistributionId() {
            return targetDistributionId;
        }

        public final void setTargetDistributionId(String targetDistributionId) {
            this.targetDistributionId = targetDistributionId;
        }

        @Override
        public final Builder targetDistributionId(String targetDistributionId) {
            this.targetDistributionId = targetDistributionId;
            return this;
        }

        public final String getAlias() {
            return alias;
        }

        public final void setAlias(String alias) {
            this.alias = alias;
        }

        @Override
        public final Builder alias(String alias) {
            this.alias = alias;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AssociateAliasRequest build() {
            return new AssociateAliasRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
