/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfront.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListDomainConflictsRequest extends CloudFrontRequest implements
        ToCopyableBuilder<ListDomainConflictsRequest.Builder, ListDomainConflictsRequest> {
    private static final SdkField<String> DOMAIN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Domain")
            .getter(getter(ListDomainConflictsRequest::domain))
            .setter(setter(Builder::domain))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Domain")
                    .unmarshallLocationName("Domain").build()).build();

    private static final SdkField<DistributionResourceId> DOMAIN_CONTROL_VALIDATION_RESOURCE_FIELD = SdkField
            .<DistributionResourceId> builder(MarshallingType.SDK_POJO)
            .memberName("DomainControlValidationResource")
            .getter(getter(ListDomainConflictsRequest::domainControlValidationResource))
            .setter(setter(Builder::domainControlValidationResource))
            .constructor(DistributionResourceId::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainControlValidationResource")
                    .unmarshallLocationName("DomainControlValidationResource").build()).build();

    private static final SdkField<Integer> MAX_ITEMS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxItems")
            .getter(getter(ListDomainConflictsRequest::maxItems))
            .setter(setter(Builder::maxItems))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxItems")
                    .unmarshallLocationName("MaxItems").build()).build();

    private static final SdkField<String> MARKER_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Marker")
            .getter(getter(ListDomainConflictsRequest::marker))
            .setter(setter(Builder::marker))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker")
                    .unmarshallLocationName("Marker").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_FIELD,
            DOMAIN_CONTROL_VALIDATION_RESOURCE_FIELD, MAX_ITEMS_FIELD, MARKER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String domain;

    private final DistributionResourceId domainControlValidationResource;

    private final Integer maxItems;

    private final String marker;

    private ListDomainConflictsRequest(BuilderImpl builder) {
        super(builder);
        this.domain = builder.domain;
        this.domainControlValidationResource = builder.domainControlValidationResource;
        this.maxItems = builder.maxItems;
        this.marker = builder.marker;
    }

    /**
     * <p>
     * The domain to check for conflicts.
     * </p>
     * 
     * @return The domain to check for conflicts.
     */
    public final String domain() {
        return domain;
    }

    /**
     * <p>
     * The distribution resource identifier. This can be the distribution or distribution tenant that has a valid
     * certificate, which covers the domain that you specify.
     * </p>
     * 
     * @return The distribution resource identifier. This can be the distribution or distribution tenant that has a
     *         valid certificate, which covers the domain that you specify.
     */
    public final DistributionResourceId domainControlValidationResource() {
        return domainControlValidationResource;
    }

    /**
     * <p>
     * The maximum number of domain conflicts to return.
     * </p>
     * 
     * @return The maximum number of domain conflicts to return.
     */
    public final Integer maxItems() {
        return maxItems;
    }

    /**
     * <p>
     * The marker for the next set of domain conflicts.
     * </p>
     * 
     * @return The marker for the next set of domain conflicts.
     */
    public final String marker() {
        return marker;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(domain());
        hashCode = 31 * hashCode + Objects.hashCode(domainControlValidationResource());
        hashCode = 31 * hashCode + Objects.hashCode(maxItems());
        hashCode = 31 * hashCode + Objects.hashCode(marker());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDomainConflictsRequest)) {
            return false;
        }
        ListDomainConflictsRequest other = (ListDomainConflictsRequest) obj;
        return Objects.equals(domain(), other.domain())
                && Objects.equals(domainControlValidationResource(), other.domainControlValidationResource())
                && Objects.equals(maxItems(), other.maxItems()) && Objects.equals(marker(), other.marker());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListDomainConflictsRequest").add("Domain", domain())
                .add("DomainControlValidationResource", domainControlValidationResource()).add("MaxItems", maxItems())
                .add("Marker", marker()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Domain":
            return Optional.ofNullable(clazz.cast(domain()));
        case "DomainControlValidationResource":
            return Optional.ofNullable(clazz.cast(domainControlValidationResource()));
        case "MaxItems":
            return Optional.ofNullable(clazz.cast(maxItems()));
        case "Marker":
            return Optional.ofNullable(clazz.cast(marker()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Domain", DOMAIN_FIELD);
        map.put("DomainControlValidationResource", DOMAIN_CONTROL_VALIDATION_RESOURCE_FIELD);
        map.put("MaxItems", MAX_ITEMS_FIELD);
        map.put("Marker", MARKER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListDomainConflictsRequest, T> g) {
        return obj -> g.apply((ListDomainConflictsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends CloudFrontRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListDomainConflictsRequest> {
        /**
         * <p>
         * The domain to check for conflicts.
         * </p>
         * 
         * @param domain
         *        The domain to check for conflicts.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domain(String domain);

        /**
         * <p>
         * The distribution resource identifier. This can be the distribution or distribution tenant that has a valid
         * certificate, which covers the domain that you specify.
         * </p>
         * 
         * @param domainControlValidationResource
         *        The distribution resource identifier. This can be the distribution or distribution tenant that has a
         *        valid certificate, which covers the domain that you specify.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainControlValidationResource(DistributionResourceId domainControlValidationResource);

        /**
         * <p>
         * The distribution resource identifier. This can be the distribution or distribution tenant that has a valid
         * certificate, which covers the domain that you specify.
         * </p>
         * This is a convenience method that creates an instance of the {@link DistributionResourceId.Builder} avoiding
         * the need to create one manually via {@link DistributionResourceId#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DistributionResourceId.Builder#build()} is called immediately and
         * its result is passed to {@link #domainControlValidationResource(DistributionResourceId)}.
         * 
         * @param domainControlValidationResource
         *        a consumer that will call methods on {@link DistributionResourceId.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #domainControlValidationResource(DistributionResourceId)
         */
        default Builder domainControlValidationResource(Consumer<DistributionResourceId.Builder> domainControlValidationResource) {
            return domainControlValidationResource(DistributionResourceId.builder()
                    .applyMutation(domainControlValidationResource).build());
        }

        /**
         * <p>
         * The maximum number of domain conflicts to return.
         * </p>
         * 
         * @param maxItems
         *        The maximum number of domain conflicts to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxItems(Integer maxItems);

        /**
         * <p>
         * The marker for the next set of domain conflicts.
         * </p>
         * 
         * @param marker
         *        The marker for the next set of domain conflicts.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder marker(String marker);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CloudFrontRequest.BuilderImpl implements Builder {
        private String domain;

        private DistributionResourceId domainControlValidationResource;

        private Integer maxItems;

        private String marker;

        private BuilderImpl() {
        }

        private BuilderImpl(ListDomainConflictsRequest model) {
            super(model);
            domain(model.domain);
            domainControlValidationResource(model.domainControlValidationResource);
            maxItems(model.maxItems);
            marker(model.marker);
        }

        public final String getDomain() {
            return domain;
        }

        public final void setDomain(String domain) {
            this.domain = domain;
        }

        @Override
        public final Builder domain(String domain) {
            this.domain = domain;
            return this;
        }

        public final DistributionResourceId.Builder getDomainControlValidationResource() {
            return domainControlValidationResource != null ? domainControlValidationResource.toBuilder() : null;
        }

        public final void setDomainControlValidationResource(DistributionResourceId.BuilderImpl domainControlValidationResource) {
            this.domainControlValidationResource = domainControlValidationResource != null ? domainControlValidationResource
                    .build() : null;
        }

        @Override
        public final Builder domainControlValidationResource(DistributionResourceId domainControlValidationResource) {
            this.domainControlValidationResource = domainControlValidationResource;
            return this;
        }

        public final Integer getMaxItems() {
            return maxItems;
        }

        public final void setMaxItems(Integer maxItems) {
            this.maxItems = maxItems;
        }

        @Override
        public final Builder maxItems(Integer maxItems) {
            this.maxItems = maxItems;
            return this;
        }

        public final String getMarker() {
            return marker;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListDomainConflictsRequest build() {
            return new ListDomainConflictsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
