/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfront.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateVpcOriginRequest extends CloudFrontRequest implements
        ToCopyableBuilder<CreateVpcOriginRequest.Builder, CreateVpcOriginRequest> {
    private static final SdkField<VpcOriginEndpointConfig> VPC_ORIGIN_ENDPOINT_CONFIG_FIELD = SdkField
            .<VpcOriginEndpointConfig> builder(MarshallingType.SDK_POJO)
            .memberName("VpcOriginEndpointConfig")
            .getter(getter(CreateVpcOriginRequest::vpcOriginEndpointConfig))
            .setter(setter(Builder::vpcOriginEndpointConfig))
            .constructor(VpcOriginEndpointConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcOriginEndpointConfig")
                    .unmarshallLocationName("VpcOriginEndpointConfig").build()).build();

    private static final SdkField<Tags> TAGS_FIELD = SdkField
            .<Tags> builder(MarshallingType.SDK_POJO)
            .memberName("Tags")
            .getter(getter(CreateVpcOriginRequest::tags))
            .setter(setter(Builder::tags))
            .constructor(Tags::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags")
                    .unmarshallLocationName("Tags").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            VPC_ORIGIN_ENDPOINT_CONFIG_FIELD, TAGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final VpcOriginEndpointConfig vpcOriginEndpointConfig;

    private final Tags tags;

    private CreateVpcOriginRequest(BuilderImpl builder) {
        super(builder);
        this.vpcOriginEndpointConfig = builder.vpcOriginEndpointConfig;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The VPC origin endpoint configuration.
     * </p>
     * 
     * @return The VPC origin endpoint configuration.
     */
    public final VpcOriginEndpointConfig vpcOriginEndpointConfig() {
        return vpcOriginEndpointConfig;
    }

    /**
     * Returns the value of the Tags property for this object.
     * 
     * @return The value of the Tags property for this object.
     */
    public final Tags tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(vpcOriginEndpointConfig());
        hashCode = 31 * hashCode + Objects.hashCode(tags());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateVpcOriginRequest)) {
            return false;
        }
        CreateVpcOriginRequest other = (CreateVpcOriginRequest) obj;
        return Objects.equals(vpcOriginEndpointConfig(), other.vpcOriginEndpointConfig()) && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateVpcOriginRequest").add("VpcOriginEndpointConfig", vpcOriginEndpointConfig())
                .add("Tags", tags()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "VpcOriginEndpointConfig":
            return Optional.ofNullable(clazz.cast(vpcOriginEndpointConfig()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("VpcOriginEndpointConfig", VPC_ORIGIN_ENDPOINT_CONFIG_FIELD);
        map.put("Tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateVpcOriginRequest, T> g) {
        return obj -> g.apply((CreateVpcOriginRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends CloudFrontRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateVpcOriginRequest> {
        /**
         * <p>
         * The VPC origin endpoint configuration.
         * </p>
         * 
         * @param vpcOriginEndpointConfig
         *        The VPC origin endpoint configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcOriginEndpointConfig(VpcOriginEndpointConfig vpcOriginEndpointConfig);

        /**
         * <p>
         * The VPC origin endpoint configuration.
         * </p>
         * This is a convenience method that creates an instance of the {@link VpcOriginEndpointConfig.Builder} avoiding
         * the need to create one manually via {@link VpcOriginEndpointConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link VpcOriginEndpointConfig.Builder#build()} is called immediately
         * and its result is passed to {@link #vpcOriginEndpointConfig(VpcOriginEndpointConfig)}.
         * 
         * @param vpcOriginEndpointConfig
         *        a consumer that will call methods on {@link VpcOriginEndpointConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #vpcOriginEndpointConfig(VpcOriginEndpointConfig)
         */
        default Builder vpcOriginEndpointConfig(Consumer<VpcOriginEndpointConfig.Builder> vpcOriginEndpointConfig) {
            return vpcOriginEndpointConfig(VpcOriginEndpointConfig.builder().applyMutation(vpcOriginEndpointConfig).build());
        }

        /**
         * Sets the value of the Tags property for this object.
         *
         * @param tags
         *        The new value for the Tags property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tags tags);

        /**
         * Sets the value of the Tags property for this object.
         *
         * This is a convenience method that creates an instance of the {@link Tags.Builder} avoiding the need to create
         * one manually via {@link Tags#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Tags.Builder#build()} is called immediately and its result is
         * passed to {@link #tags(Tags)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link Tags.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(Tags)
         */
        default Builder tags(Consumer<Tags.Builder> tags) {
            return tags(Tags.builder().applyMutation(tags).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CloudFrontRequest.BuilderImpl implements Builder {
        private VpcOriginEndpointConfig vpcOriginEndpointConfig;

        private Tags tags;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateVpcOriginRequest model) {
            super(model);
            vpcOriginEndpointConfig(model.vpcOriginEndpointConfig);
            tags(model.tags);
        }

        public final VpcOriginEndpointConfig.Builder getVpcOriginEndpointConfig() {
            return vpcOriginEndpointConfig != null ? vpcOriginEndpointConfig.toBuilder() : null;
        }

        public final void setVpcOriginEndpointConfig(VpcOriginEndpointConfig.BuilderImpl vpcOriginEndpointConfig) {
            this.vpcOriginEndpointConfig = vpcOriginEndpointConfig != null ? vpcOriginEndpointConfig.build() : null;
        }

        @Override
        public final Builder vpcOriginEndpointConfig(VpcOriginEndpointConfig vpcOriginEndpointConfig) {
            this.vpcOriginEndpointConfig = vpcOriginEndpointConfig;
            return this;
        }

        public final Tags.Builder getTags() {
            return tags != null ? tags.toBuilder() : null;
        }

        public final void setTags(Tags.BuilderImpl tags) {
            this.tags = tags != null ? tags.build() : null;
        }

        @Override
        public final Builder tags(Tags tags) {
            this.tags = tags;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateVpcOriginRequest build() {
            return new CreateVpcOriginRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
