/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cloudfront.model.CloudFrontResponse;
import software.amazon.awssdk.services.cloudfront.model.DistributionTenant;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetDistributionTenantByDomainResponse
extends CloudFrontResponse
implements ToCopyableBuilder<Builder, GetDistributionTenantByDomainResponse> {
    private static final SdkField<DistributionTenant> DISTRIBUTION_TENANT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DistributionTenant").getter(GetDistributionTenantByDomainResponse.getter(GetDistributionTenantByDomainResponse::distributionTenant)).setter(GetDistributionTenantByDomainResponse.setter(Builder::distributionTenant)).constructor(DistributionTenant::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DistributionTenant").unmarshallLocationName("DistributionTenant").build(), PayloadTrait.create()}).build();
    private static final SdkField<String> E_TAG_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ETag").getter(GetDistributionTenantByDomainResponse.getter(GetDistributionTenantByDomainResponse::eTag)).setter(GetDistributionTenantByDomainResponse.setter(Builder::eTag)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("ETag").unmarshallLocationName("ETag").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DISTRIBUTION_TENANT_FIELD, E_TAG_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetDistributionTenantByDomainResponse.memberNameToFieldInitializer();
    private final DistributionTenant distributionTenant;
    private final String eTag;

    private GetDistributionTenantByDomainResponse(BuilderImpl builder) {
        super(builder);
        this.distributionTenant = builder.distributionTenant;
        this.eTag = builder.eTag;
    }

    public final DistributionTenant distributionTenant() {
        return this.distributionTenant;
    }

    public final String eTag() {
        return this.eTag;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.distributionTenant());
        hashCode = 31 * hashCode + Objects.hashCode(this.eTag());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDistributionTenantByDomainResponse)) {
            return false;
        }
        GetDistributionTenantByDomainResponse other = (GetDistributionTenantByDomainResponse)((Object)obj);
        return Objects.equals(this.distributionTenant(), other.distributionTenant()) && Objects.equals(this.eTag(), other.eTag());
    }

    public final String toString() {
        return ToString.builder((String)"GetDistributionTenantByDomainResponse").add("DistributionTenant", (Object)this.distributionTenant()).add("ETag", (Object)this.eTag()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DistributionTenant": {
                return Optional.ofNullable(clazz.cast(this.distributionTenant()));
            }
            case "ETag": {
                return Optional.ofNullable(clazz.cast(this.eTag()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("DistributionTenant", DISTRIBUTION_TENANT_FIELD);
        map.put("ETag", E_TAG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetDistributionTenantByDomainResponse, T> g) {
        return obj -> g.apply((GetDistributionTenantByDomainResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudFrontResponse.BuilderImpl
    implements Builder {
        private DistributionTenant distributionTenant;
        private String eTag;

        private BuilderImpl() {
        }

        private BuilderImpl(GetDistributionTenantByDomainResponse model) {
            super(model);
            this.distributionTenant(model.distributionTenant);
            this.eTag(model.eTag);
        }

        public final DistributionTenant.Builder getDistributionTenant() {
            return this.distributionTenant != null ? this.distributionTenant.toBuilder() : null;
        }

        public final void setDistributionTenant(DistributionTenant.BuilderImpl distributionTenant) {
            this.distributionTenant = distributionTenant != null ? distributionTenant.build() : null;
        }

        @Override
        public final Builder distributionTenant(DistributionTenant distributionTenant) {
            this.distributionTenant = distributionTenant;
            return this;
        }

        public final String getETag() {
            return this.eTag;
        }

        public final void setETag(String eTag) {
            this.eTag = eTag;
        }

        @Override
        public final Builder eTag(String eTag) {
            this.eTag = eTag;
            return this;
        }

        @Override
        public GetDistributionTenantByDomainResponse build() {
            return new GetDistributionTenantByDomainResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends CloudFrontResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetDistributionTenantByDomainResponse> {
        public Builder distributionTenant(DistributionTenant var1);

        default public Builder distributionTenant(Consumer<DistributionTenant.Builder> distributionTenant) {
            return this.distributionTenant((DistributionTenant)((DistributionTenant.Builder)DistributionTenant.builder().applyMutation(distributionTenant)).build());
        }

        public Builder eTag(String var1);
    }
}

