/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cloudfront.model.CloudFrontRequest;
import software.amazon.awssdk.services.cloudfront.model.Customizations;
import software.amazon.awssdk.services.cloudfront.model.DomainItem;
import software.amazon.awssdk.services.cloudfront.model.DomainListCopier;
import software.amazon.awssdk.services.cloudfront.model.ManagedCertificateRequest;
import software.amazon.awssdk.services.cloudfront.model.Parameter;
import software.amazon.awssdk.services.cloudfront.model.ParametersCopier;
import software.amazon.awssdk.services.cloudfront.model.Tags;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateDistributionTenantRequest
extends CloudFrontRequest
implements ToCopyableBuilder<Builder, CreateDistributionTenantRequest> {
    private static final SdkField<String> DISTRIBUTION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DistributionId").getter(CreateDistributionTenantRequest.getter(CreateDistributionTenantRequest::distributionId)).setter(CreateDistributionTenantRequest.setter(Builder::distributionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DistributionId").unmarshallLocationName("DistributionId").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(CreateDistributionTenantRequest.getter(CreateDistributionTenantRequest::name)).setter(CreateDistributionTenantRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").unmarshallLocationName("Name").build()}).build();
    private static final SdkField<List<DomainItem>> DOMAINS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Domains").getter(CreateDistributionTenantRequest.getter(CreateDistributionTenantRequest::domains)).setter(CreateDistributionTenantRequest.setter(Builder::domains)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Domains").unmarshallLocationName("Domains").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DomainItem::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").unmarshallLocationName("member").build()}).build()).build()}).build();
    private static final SdkField<Tags> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Tags").getter(CreateDistributionTenantRequest.getter(CreateDistributionTenantRequest::tags)).setter(CreateDistributionTenantRequest.setter(Builder::tags)).constructor(Tags::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").unmarshallLocationName("Tags").build()}).build();
    private static final SdkField<Customizations> CUSTOMIZATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Customizations").getter(CreateDistributionTenantRequest.getter(CreateDistributionTenantRequest::customizations)).setter(CreateDistributionTenantRequest.setter(Builder::customizations)).constructor(Customizations::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Customizations").unmarshallLocationName("Customizations").build()}).build();
    private static final SdkField<List<Parameter>> PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Parameters").getter(CreateDistributionTenantRequest.getter(CreateDistributionTenantRequest::parameters)).setter(CreateDistributionTenantRequest.setter(Builder::parameters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Parameters").unmarshallLocationName("Parameters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Parameter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").unmarshallLocationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> CONNECTION_GROUP_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ConnectionGroupId").getter(CreateDistributionTenantRequest.getter(CreateDistributionTenantRequest::connectionGroupId)).setter(CreateDistributionTenantRequest.setter(Builder::connectionGroupId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectionGroupId").unmarshallLocationName("ConnectionGroupId").build()}).build();
    private static final SdkField<ManagedCertificateRequest> MANAGED_CERTIFICATE_REQUEST_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ManagedCertificateRequest").getter(CreateDistributionTenantRequest.getter(CreateDistributionTenantRequest::managedCertificateRequest)).setter(CreateDistributionTenantRequest.setter(Builder::managedCertificateRequest)).constructor(ManagedCertificateRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ManagedCertificateRequest").unmarshallLocationName("ManagedCertificateRequest").build()}).build();
    private static final SdkField<Boolean> ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("Enabled").getter(CreateDistributionTenantRequest.getter(CreateDistributionTenantRequest::enabled)).setter(CreateDistributionTenantRequest.setter(Builder::enabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Enabled").unmarshallLocationName("Enabled").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DISTRIBUTION_ID_FIELD, NAME_FIELD, DOMAINS_FIELD, TAGS_FIELD, CUSTOMIZATIONS_FIELD, PARAMETERS_FIELD, CONNECTION_GROUP_ID_FIELD, MANAGED_CERTIFICATE_REQUEST_FIELD, ENABLED_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateDistributionTenantRequest.memberNameToFieldInitializer();
    private final String distributionId;
    private final String name;
    private final List<DomainItem> domains;
    private final Tags tags;
    private final Customizations customizations;
    private final List<Parameter> parameters;
    private final String connectionGroupId;
    private final ManagedCertificateRequest managedCertificateRequest;
    private final Boolean enabled;

    private CreateDistributionTenantRequest(BuilderImpl builder) {
        super(builder);
        this.distributionId = builder.distributionId;
        this.name = builder.name;
        this.domains = builder.domains;
        this.tags = builder.tags;
        this.customizations = builder.customizations;
        this.parameters = builder.parameters;
        this.connectionGroupId = builder.connectionGroupId;
        this.managedCertificateRequest = builder.managedCertificateRequest;
        this.enabled = builder.enabled;
    }

    public final String distributionId() {
        return this.distributionId;
    }

    public final String name() {
        return this.name;
    }

    public final boolean hasDomains() {
        return this.domains != null && !(this.domains instanceof SdkAutoConstructList);
    }

    public final List<DomainItem> domains() {
        return this.domains;
    }

    public final Tags tags() {
        return this.tags;
    }

    public final Customizations customizations() {
        return this.customizations;
    }

    public final boolean hasParameters() {
        return this.parameters != null && !(this.parameters instanceof SdkAutoConstructList);
    }

    public final List<Parameter> parameters() {
        return this.parameters;
    }

    public final String connectionGroupId() {
        return this.connectionGroupId;
    }

    public final ManagedCertificateRequest managedCertificateRequest() {
        return this.managedCertificateRequest;
    }

    public final Boolean enabled() {
        return this.enabled;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.distributionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDomains() ? this.domains() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.tags());
        hashCode = 31 * hashCode + Objects.hashCode(this.customizations());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasParameters() ? this.parameters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.connectionGroupId());
        hashCode = 31 * hashCode + Objects.hashCode(this.managedCertificateRequest());
        hashCode = 31 * hashCode + Objects.hashCode(this.enabled());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDistributionTenantRequest)) {
            return false;
        }
        CreateDistributionTenantRequest other = (CreateDistributionTenantRequest)((Object)obj);
        return Objects.equals(this.distributionId(), other.distributionId()) && Objects.equals(this.name(), other.name()) && this.hasDomains() == other.hasDomains() && Objects.equals(this.domains(), other.domains()) && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.customizations(), other.customizations()) && this.hasParameters() == other.hasParameters() && Objects.equals(this.parameters(), other.parameters()) && Objects.equals(this.connectionGroupId(), other.connectionGroupId()) && Objects.equals(this.managedCertificateRequest(), other.managedCertificateRequest()) && Objects.equals(this.enabled(), other.enabled());
    }

    public final String toString() {
        return ToString.builder((String)"CreateDistributionTenantRequest").add("DistributionId", (Object)this.distributionId()).add("Name", (Object)this.name()).add("Domains", this.hasDomains() ? this.domains() : null).add("Tags", (Object)this.tags()).add("Customizations", (Object)this.customizations()).add("Parameters", this.hasParameters() ? this.parameters() : null).add("ConnectionGroupId", (Object)this.connectionGroupId()).add("ManagedCertificateRequest", (Object)this.managedCertificateRequest()).add("Enabled", (Object)this.enabled()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DistributionId": {
                return Optional.ofNullable(clazz.cast(this.distributionId()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Domains": {
                return Optional.ofNullable(clazz.cast(this.domains()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "Customizations": {
                return Optional.ofNullable(clazz.cast(this.customizations()));
            }
            case "Parameters": {
                return Optional.ofNullable(clazz.cast(this.parameters()));
            }
            case "ConnectionGroupId": {
                return Optional.ofNullable(clazz.cast(this.connectionGroupId()));
            }
            case "ManagedCertificateRequest": {
                return Optional.ofNullable(clazz.cast(this.managedCertificateRequest()));
            }
            case "Enabled": {
                return Optional.ofNullable(clazz.cast(this.enabled()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("DistributionId", DISTRIBUTION_ID_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("Domains", DOMAINS_FIELD);
        map.put("Tags", TAGS_FIELD);
        map.put("Customizations", CUSTOMIZATIONS_FIELD);
        map.put("Parameters", PARAMETERS_FIELD);
        map.put("ConnectionGroupId", CONNECTION_GROUP_ID_FIELD);
        map.put("ManagedCertificateRequest", MANAGED_CERTIFICATE_REQUEST_FIELD);
        map.put("Enabled", ENABLED_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateDistributionTenantRequest, T> g) {
        return obj -> g.apply((CreateDistributionTenantRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudFrontRequest.BuilderImpl
    implements Builder {
        private String distributionId;
        private String name;
        private List<DomainItem> domains = DefaultSdkAutoConstructList.getInstance();
        private Tags tags;
        private Customizations customizations;
        private List<Parameter> parameters = DefaultSdkAutoConstructList.getInstance();
        private String connectionGroupId;
        private ManagedCertificateRequest managedCertificateRequest;
        private Boolean enabled;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDistributionTenantRequest model) {
            super(model);
            this.distributionId(model.distributionId);
            this.name(model.name);
            this.domains(model.domains);
            this.tags(model.tags);
            this.customizations(model.customizations);
            this.parameters(model.parameters);
            this.connectionGroupId(model.connectionGroupId);
            this.managedCertificateRequest(model.managedCertificateRequest);
            this.enabled(model.enabled);
        }

        public final String getDistributionId() {
            return this.distributionId;
        }

        public final void setDistributionId(String distributionId) {
            this.distributionId = distributionId;
        }

        @Override
        public final Builder distributionId(String distributionId) {
            this.distributionId = distributionId;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final List<DomainItem.Builder> getDomains() {
            List<DomainItem.Builder> result = DomainListCopier.copyToBuilder(this.domains);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDomains(Collection<DomainItem.BuilderImpl> domains) {
            this.domains = DomainListCopier.copyFromBuilder(domains);
        }

        @Override
        public final Builder domains(Collection<DomainItem> domains) {
            this.domains = DomainListCopier.copy(domains);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder domains(DomainItem ... domains) {
            this.domains(Arrays.asList(domains));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder domains(Consumer<DomainItem.Builder> ... domains) {
            this.domains(Stream.of(domains).map(c -> (DomainItem)((DomainItem.Builder)DomainItem.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Tags.Builder getTags() {
            return this.tags != null ? this.tags.toBuilder() : null;
        }

        public final void setTags(Tags.BuilderImpl tags) {
            this.tags = tags != null ? tags.build() : null;
        }

        @Override
        public final Builder tags(Tags tags) {
            this.tags = tags;
            return this;
        }

        public final Customizations.Builder getCustomizations() {
            return this.customizations != null ? this.customizations.toBuilder() : null;
        }

        public final void setCustomizations(Customizations.BuilderImpl customizations) {
            this.customizations = customizations != null ? customizations.build() : null;
        }

        @Override
        public final Builder customizations(Customizations customizations) {
            this.customizations = customizations;
            return this;
        }

        public final List<Parameter.Builder> getParameters() {
            List<Parameter.Builder> result = ParametersCopier.copyToBuilder(this.parameters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setParameters(Collection<Parameter.BuilderImpl> parameters) {
            this.parameters = ParametersCopier.copyFromBuilder(parameters);
        }

        @Override
        public final Builder parameters(Collection<Parameter> parameters) {
            this.parameters = ParametersCopier.copy(parameters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameters(Parameter ... parameters) {
            this.parameters(Arrays.asList(parameters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameters(Consumer<Parameter.Builder> ... parameters) {
            this.parameters(Stream.of(parameters).map(c -> (Parameter)((Parameter.Builder)Parameter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getConnectionGroupId() {
            return this.connectionGroupId;
        }

        public final void setConnectionGroupId(String connectionGroupId) {
            this.connectionGroupId = connectionGroupId;
        }

        @Override
        public final Builder connectionGroupId(String connectionGroupId) {
            this.connectionGroupId = connectionGroupId;
            return this;
        }

        public final ManagedCertificateRequest.Builder getManagedCertificateRequest() {
            return this.managedCertificateRequest != null ? this.managedCertificateRequest.toBuilder() : null;
        }

        public final void setManagedCertificateRequest(ManagedCertificateRequest.BuilderImpl managedCertificateRequest) {
            this.managedCertificateRequest = managedCertificateRequest != null ? managedCertificateRequest.build() : null;
        }

        @Override
        public final Builder managedCertificateRequest(ManagedCertificateRequest managedCertificateRequest) {
            this.managedCertificateRequest = managedCertificateRequest;
            return this;
        }

        public final Boolean getEnabled() {
            return this.enabled;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateDistributionTenantRequest build() {
            return new CreateDistributionTenantRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends CloudFrontRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateDistributionTenantRequest> {
        public Builder distributionId(String var1);

        public Builder name(String var1);

        public Builder domains(Collection<DomainItem> var1);

        public Builder domains(DomainItem ... var1);

        public Builder domains(Consumer<DomainItem.Builder> ... var1);

        public Builder tags(Tags var1);

        default public Builder tags(Consumer<Tags.Builder> tags) {
            return this.tags((Tags)((Tags.Builder)Tags.builder().applyMutation(tags)).build());
        }

        public Builder customizations(Customizations var1);

        default public Builder customizations(Consumer<Customizations.Builder> customizations) {
            return this.customizations((Customizations)((Customizations.Builder)Customizations.builder().applyMutation(customizations)).build());
        }

        public Builder parameters(Collection<Parameter> var1);

        public Builder parameters(Parameter ... var1);

        public Builder parameters(Consumer<Parameter.Builder> ... var1);

        public Builder connectionGroupId(String var1);

        public Builder managedCertificateRequest(ManagedCertificateRequest var1);

        default public Builder managedCertificateRequest(Consumer<ManagedCertificateRequest.Builder> managedCertificateRequest) {
            return this.managedCertificateRequest((ManagedCertificateRequest)((ManagedCertificateRequest.Builder)ManagedCertificateRequest.builder().applyMutation(managedCertificateRequest)).build());
        }

        public Builder enabled(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

