/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfront.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An Amazon CloudFront VPC origin configuration.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class VpcOriginConfig implements SdkPojo, Serializable, ToCopyableBuilder<VpcOriginConfig.Builder, VpcOriginConfig> {
    private static final SdkField<String> VPC_ORIGIN_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("VpcOriginId")
            .getter(getter(VpcOriginConfig::vpcOriginId))
            .setter(setter(Builder::vpcOriginId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcOriginId")
                    .unmarshallLocationName("VpcOriginId").build()).build();

    private static final SdkField<Integer> ORIGIN_READ_TIMEOUT_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("OriginReadTimeout")
            .getter(getter(VpcOriginConfig::originReadTimeout))
            .setter(setter(Builder::originReadTimeout))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OriginReadTimeout")
                    .unmarshallLocationName("OriginReadTimeout").build()).build();

    private static final SdkField<Integer> ORIGIN_KEEPALIVE_TIMEOUT_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("OriginKeepaliveTimeout")
            .getter(getter(VpcOriginConfig::originKeepaliveTimeout))
            .setter(setter(Builder::originKeepaliveTimeout))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OriginKeepaliveTimeout")
                    .unmarshallLocationName("OriginKeepaliveTimeout").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VPC_ORIGIN_ID_FIELD,
            ORIGIN_READ_TIMEOUT_FIELD, ORIGIN_KEEPALIVE_TIMEOUT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String vpcOriginId;

    private final Integer originReadTimeout;

    private final Integer originKeepaliveTimeout;

    private VpcOriginConfig(BuilderImpl builder) {
        this.vpcOriginId = builder.vpcOriginId;
        this.originReadTimeout = builder.originReadTimeout;
        this.originKeepaliveTimeout = builder.originKeepaliveTimeout;
    }

    /**
     * <p>
     * The VPC origin ID.
     * </p>
     * 
     * @return The VPC origin ID.
     */
    public final String vpcOriginId() {
        return vpcOriginId;
    }

    /**
     * <p>
     * Specifies how long, in seconds, CloudFront waits for a response from the origin. This is also known as the
     * <i>origin response timeout</i>. The minimum timeout is 1 second, the maximum is 60 seconds, and the default (if
     * you don't specify otherwise) is 30 seconds.
     * </p>
     * <p>
     * For more information, see <a href=
     * "https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-web-values-specify.html#DownloadDistValuesOriginResponseTimeout"
     * >Response timeout (custom origins only)</a> in the <i>Amazon CloudFront Developer Guide</i>.
     * </p>
     * 
     * @return Specifies how long, in seconds, CloudFront waits for a response from the origin. This is also known as
     *         the <i>origin response timeout</i>. The minimum timeout is 1 second, the maximum is 60 seconds, and the
     *         default (if you don't specify otherwise) is 30 seconds.</p>
     *         <p>
     *         For more information, see <a href=
     *         "https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-web-values-specify.html#DownloadDistValuesOriginResponseTimeout"
     *         >Response timeout (custom origins only)</a> in the <i>Amazon CloudFront Developer Guide</i>.
     */
    public final Integer originReadTimeout() {
        return originReadTimeout;
    }

    /**
     * <p>
     * Specifies how long, in seconds, CloudFront persists its connection to the origin. The minimum timeout is 1
     * second, the maximum is 60 seconds, and the default (if you don't specify otherwise) is 5 seconds.
     * </p>
     * <p>
     * For more information, see <a href=
     * "https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-web-values-specify.html#DownloadDistValuesOriginKeepaliveTimeout"
     * >Keep-alive timeout (custom origins only)</a> in the <i>Amazon CloudFront Developer Guide</i>.
     * </p>
     * 
     * @return Specifies how long, in seconds, CloudFront persists its connection to the origin. The minimum timeout is
     *         1 second, the maximum is 60 seconds, and the default (if you don't specify otherwise) is 5 seconds.</p>
     *         <p>
     *         For more information, see <a href=
     *         "https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-web-values-specify.html#DownloadDistValuesOriginKeepaliveTimeout"
     *         >Keep-alive timeout (custom origins only)</a> in the <i>Amazon CloudFront Developer Guide</i>.
     */
    public final Integer originKeepaliveTimeout() {
        return originKeepaliveTimeout;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(vpcOriginId());
        hashCode = 31 * hashCode + Objects.hashCode(originReadTimeout());
        hashCode = 31 * hashCode + Objects.hashCode(originKeepaliveTimeout());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VpcOriginConfig)) {
            return false;
        }
        VpcOriginConfig other = (VpcOriginConfig) obj;
        return Objects.equals(vpcOriginId(), other.vpcOriginId())
                && Objects.equals(originReadTimeout(), other.originReadTimeout())
                && Objects.equals(originKeepaliveTimeout(), other.originKeepaliveTimeout());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("VpcOriginConfig").add("VpcOriginId", vpcOriginId())
                .add("OriginReadTimeout", originReadTimeout()).add("OriginKeepaliveTimeout", originKeepaliveTimeout()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "VpcOriginId":
            return Optional.ofNullable(clazz.cast(vpcOriginId()));
        case "OriginReadTimeout":
            return Optional.ofNullable(clazz.cast(originReadTimeout()));
        case "OriginKeepaliveTimeout":
            return Optional.ofNullable(clazz.cast(originKeepaliveTimeout()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("VpcOriginId", VPC_ORIGIN_ID_FIELD);
        map.put("OriginReadTimeout", ORIGIN_READ_TIMEOUT_FIELD);
        map.put("OriginKeepaliveTimeout", ORIGIN_KEEPALIVE_TIMEOUT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<VpcOriginConfig, T> g) {
        return obj -> g.apply((VpcOriginConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, VpcOriginConfig> {
        /**
         * <p>
         * The VPC origin ID.
         * </p>
         * 
         * @param vpcOriginId
         *        The VPC origin ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcOriginId(String vpcOriginId);

        /**
         * <p>
         * Specifies how long, in seconds, CloudFront waits for a response from the origin. This is also known as the
         * <i>origin response timeout</i>. The minimum timeout is 1 second, the maximum is 60 seconds, and the default
         * (if you don't specify otherwise) is 30 seconds.
         * </p>
         * <p>
         * For more information, see <a href=
         * "https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-web-values-specify.html#DownloadDistValuesOriginResponseTimeout"
         * >Response timeout (custom origins only)</a> in the <i>Amazon CloudFront Developer Guide</i>.
         * </p>
         * 
         * @param originReadTimeout
         *        Specifies how long, in seconds, CloudFront waits for a response from the origin. This is also known as
         *        the <i>origin response timeout</i>. The minimum timeout is 1 second, the maximum is 60 seconds, and
         *        the default (if you don't specify otherwise) is 30 seconds.</p>
         *        <p>
         *        For more information, see <a href=
         *        "https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-web-values-specify.html#DownloadDistValuesOriginResponseTimeout"
         *        >Response timeout (custom origins only)</a> in the <i>Amazon CloudFront Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder originReadTimeout(Integer originReadTimeout);

        /**
         * <p>
         * Specifies how long, in seconds, CloudFront persists its connection to the origin. The minimum timeout is 1
         * second, the maximum is 60 seconds, and the default (if you don't specify otherwise) is 5 seconds.
         * </p>
         * <p>
         * For more information, see <a href=
         * "https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-web-values-specify.html#DownloadDistValuesOriginKeepaliveTimeout"
         * >Keep-alive timeout (custom origins only)</a> in the <i>Amazon CloudFront Developer Guide</i>.
         * </p>
         * 
         * @param originKeepaliveTimeout
         *        Specifies how long, in seconds, CloudFront persists its connection to the origin. The minimum timeout
         *        is 1 second, the maximum is 60 seconds, and the default (if you don't specify otherwise) is 5
         *        seconds.</p>
         *        <p>
         *        For more information, see <a href=
         *        "https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-web-values-specify.html#DownloadDistValuesOriginKeepaliveTimeout"
         *        >Keep-alive timeout (custom origins only)</a> in the <i>Amazon CloudFront Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder originKeepaliveTimeout(Integer originKeepaliveTimeout);
    }

    static final class BuilderImpl implements Builder {
        private String vpcOriginId;

        private Integer originReadTimeout;

        private Integer originKeepaliveTimeout;

        private BuilderImpl() {
        }

        private BuilderImpl(VpcOriginConfig model) {
            vpcOriginId(model.vpcOriginId);
            originReadTimeout(model.originReadTimeout);
            originKeepaliveTimeout(model.originKeepaliveTimeout);
        }

        public final String getVpcOriginId() {
            return vpcOriginId;
        }

        public final void setVpcOriginId(String vpcOriginId) {
            this.vpcOriginId = vpcOriginId;
        }

        @Override
        public final Builder vpcOriginId(String vpcOriginId) {
            this.vpcOriginId = vpcOriginId;
            return this;
        }

        public final Integer getOriginReadTimeout() {
            return originReadTimeout;
        }

        public final void setOriginReadTimeout(Integer originReadTimeout) {
            this.originReadTimeout = originReadTimeout;
        }

        @Override
        public final Builder originReadTimeout(Integer originReadTimeout) {
            this.originReadTimeout = originReadTimeout;
            return this;
        }

        public final Integer getOriginKeepaliveTimeout() {
            return originKeepaliveTimeout;
        }

        public final void setOriginKeepaliveTimeout(Integer originKeepaliveTimeout) {
            this.originKeepaliveTimeout = originKeepaliveTimeout;
        }

        @Override
        public final Builder originKeepaliveTimeout(Integer originKeepaliveTimeout) {
            this.originKeepaliveTimeout = originKeepaliveTimeout;
            return this;
        }

        @Override
        public VpcOriginConfig build() {
            return new VpcOriginConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
