/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfront.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetOriginRequestPolicyConfigResponse extends CloudFrontResponse implements
        ToCopyableBuilder<GetOriginRequestPolicyConfigResponse.Builder, GetOriginRequestPolicyConfigResponse> {
    private static final SdkField<OriginRequestPolicyConfig> ORIGIN_REQUEST_POLICY_CONFIG_FIELD = SdkField
            .<OriginRequestPolicyConfig> builder(MarshallingType.SDK_POJO)
            .memberName("OriginRequestPolicyConfig")
            .getter(getter(GetOriginRequestPolicyConfigResponse::originRequestPolicyConfig))
            .setter(setter(Builder::originRequestPolicyConfig))
            .constructor(OriginRequestPolicyConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OriginRequestPolicyConfig")
                    .unmarshallLocationName("OriginRequestPolicyConfig").build(), PayloadTrait.create()).build();

    private static final SdkField<String> E_TAG_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ETag")
            .getter(getter(GetOriginRequestPolicyConfigResponse::eTag))
            .setter(setter(Builder::eTag))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("ETag").unmarshallLocationName("ETag")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            ORIGIN_REQUEST_POLICY_CONFIG_FIELD, E_TAG_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final OriginRequestPolicyConfig originRequestPolicyConfig;

    private final String eTag;

    private GetOriginRequestPolicyConfigResponse(BuilderImpl builder) {
        super(builder);
        this.originRequestPolicyConfig = builder.originRequestPolicyConfig;
        this.eTag = builder.eTag;
    }

    /**
     * <p>
     * The origin request policy configuration.
     * </p>
     * 
     * @return The origin request policy configuration.
     */
    public final OriginRequestPolicyConfig originRequestPolicyConfig() {
        return originRequestPolicyConfig;
    }

    /**
     * <p>
     * The current version of the origin request policy.
     * </p>
     * 
     * @return The current version of the origin request policy.
     */
    public final String eTag() {
        return eTag;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(originRequestPolicyConfig());
        hashCode = 31 * hashCode + Objects.hashCode(eTag());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetOriginRequestPolicyConfigResponse)) {
            return false;
        }
        GetOriginRequestPolicyConfigResponse other = (GetOriginRequestPolicyConfigResponse) obj;
        return Objects.equals(originRequestPolicyConfig(), other.originRequestPolicyConfig())
                && Objects.equals(eTag(), other.eTag());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetOriginRequestPolicyConfigResponse")
                .add("OriginRequestPolicyConfig", originRequestPolicyConfig()).add("ETag", eTag()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "OriginRequestPolicyConfig":
            return Optional.ofNullable(clazz.cast(originRequestPolicyConfig()));
        case "ETag":
            return Optional.ofNullable(clazz.cast(eTag()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("OriginRequestPolicyConfig", ORIGIN_REQUEST_POLICY_CONFIG_FIELD);
        map.put("ETag", E_TAG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetOriginRequestPolicyConfigResponse, T> g) {
        return obj -> g.apply((GetOriginRequestPolicyConfigResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudFrontResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetOriginRequestPolicyConfigResponse> {
        /**
         * <p>
         * The origin request policy configuration.
         * </p>
         * 
         * @param originRequestPolicyConfig
         *        The origin request policy configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder originRequestPolicyConfig(OriginRequestPolicyConfig originRequestPolicyConfig);

        /**
         * <p>
         * The origin request policy configuration.
         * </p>
         * This is a convenience method that creates an instance of the {@link OriginRequestPolicyConfig.Builder}
         * avoiding the need to create one manually via {@link OriginRequestPolicyConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link OriginRequestPolicyConfig.Builder#build()} is called immediately
         * and its result is passed to {@link #originRequestPolicyConfig(OriginRequestPolicyConfig)}.
         * 
         * @param originRequestPolicyConfig
         *        a consumer that will call methods on {@link OriginRequestPolicyConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #originRequestPolicyConfig(OriginRequestPolicyConfig)
         */
        default Builder originRequestPolicyConfig(Consumer<OriginRequestPolicyConfig.Builder> originRequestPolicyConfig) {
            return originRequestPolicyConfig(OriginRequestPolicyConfig.builder().applyMutation(originRequestPolicyConfig).build());
        }

        /**
         * <p>
         * The current version of the origin request policy.
         * </p>
         * 
         * @param eTag
         *        The current version of the origin request policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eTag(String eTag);
    }

    static final class BuilderImpl extends CloudFrontResponse.BuilderImpl implements Builder {
        private OriginRequestPolicyConfig originRequestPolicyConfig;

        private String eTag;

        private BuilderImpl() {
        }

        private BuilderImpl(GetOriginRequestPolicyConfigResponse model) {
            super(model);
            originRequestPolicyConfig(model.originRequestPolicyConfig);
            eTag(model.eTag);
        }

        public final OriginRequestPolicyConfig.Builder getOriginRequestPolicyConfig() {
            return originRequestPolicyConfig != null ? originRequestPolicyConfig.toBuilder() : null;
        }

        public final void setOriginRequestPolicyConfig(OriginRequestPolicyConfig.BuilderImpl originRequestPolicyConfig) {
            this.originRequestPolicyConfig = originRequestPolicyConfig != null ? originRequestPolicyConfig.build() : null;
        }

        @Override
        public final Builder originRequestPolicyConfig(OriginRequestPolicyConfig originRequestPolicyConfig) {
            this.originRequestPolicyConfig = originRequestPolicyConfig;
            return this;
        }

        public final String getETag() {
            return eTag;
        }

        public final void setETag(String eTag) {
            this.eTag = eTag;
        }

        @Override
        public final Builder eTag(String eTag) {
            this.eTag = eTag;
            return this;
        }

        @Override
        public GetOriginRequestPolicyConfigResponse build() {
            return new GetOriginRequestPolicyConfigResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
