/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfront.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateResponseHeadersPolicyResponse extends CloudFrontResponse implements
        ToCopyableBuilder<CreateResponseHeadersPolicyResponse.Builder, CreateResponseHeadersPolicyResponse> {
    private static final SdkField<ResponseHeadersPolicy> RESPONSE_HEADERS_POLICY_FIELD = SdkField
            .<ResponseHeadersPolicy> builder(MarshallingType.SDK_POJO)
            .memberName("ResponseHeadersPolicy")
            .getter(getter(CreateResponseHeadersPolicyResponse::responseHeadersPolicy))
            .setter(setter(Builder::responseHeadersPolicy))
            .constructor(ResponseHeadersPolicy::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResponseHeadersPolicy")
                    .unmarshallLocationName("ResponseHeadersPolicy").build(), PayloadTrait.create()).build();

    private static final SdkField<String> LOCATION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Location")
            .getter(getter(CreateResponseHeadersPolicyResponse::location))
            .setter(setter(Builder::location))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("Location")
                    .unmarshallLocationName("Location").build()).build();

    private static final SdkField<String> E_TAG_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ETag")
            .getter(getter(CreateResponseHeadersPolicyResponse::eTag))
            .setter(setter(Builder::eTag))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("ETag").unmarshallLocationName("ETag")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESPONSE_HEADERS_POLICY_FIELD,
            LOCATION_FIELD, E_TAG_FIELD));

    private final ResponseHeadersPolicy responseHeadersPolicy;

    private final String location;

    private final String eTag;

    private CreateResponseHeadersPolicyResponse(BuilderImpl builder) {
        super(builder);
        this.responseHeadersPolicy = builder.responseHeadersPolicy;
        this.location = builder.location;
        this.eTag = builder.eTag;
    }

    /**
     * <p>
     * Contains a response headers policy.
     * </p>
     * 
     * @return Contains a response headers policy.
     */
    public final ResponseHeadersPolicy responseHeadersPolicy() {
        return responseHeadersPolicy;
    }

    /**
     * <p>
     * The URL of the response headers policy.
     * </p>
     * 
     * @return The URL of the response headers policy.
     */
    public final String location() {
        return location;
    }

    /**
     * <p>
     * The version identifier for the current version of the response headers policy.
     * </p>
     * 
     * @return The version identifier for the current version of the response headers policy.
     */
    public final String eTag() {
        return eTag;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(responseHeadersPolicy());
        hashCode = 31 * hashCode + Objects.hashCode(location());
        hashCode = 31 * hashCode + Objects.hashCode(eTag());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateResponseHeadersPolicyResponse)) {
            return false;
        }
        CreateResponseHeadersPolicyResponse other = (CreateResponseHeadersPolicyResponse) obj;
        return Objects.equals(responseHeadersPolicy(), other.responseHeadersPolicy())
                && Objects.equals(location(), other.location()) && Objects.equals(eTag(), other.eTag());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateResponseHeadersPolicyResponse").add("ResponseHeadersPolicy", responseHeadersPolicy())
                .add("Location", location()).add("ETag", eTag()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ResponseHeadersPolicy":
            return Optional.ofNullable(clazz.cast(responseHeadersPolicy()));
        case "Location":
            return Optional.ofNullable(clazz.cast(location()));
        case "ETag":
            return Optional.ofNullable(clazz.cast(eTag()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateResponseHeadersPolicyResponse, T> g) {
        return obj -> g.apply((CreateResponseHeadersPolicyResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudFrontResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateResponseHeadersPolicyResponse> {
        /**
         * <p>
         * Contains a response headers policy.
         * </p>
         * 
         * @param responseHeadersPolicy
         *        Contains a response headers policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder responseHeadersPolicy(ResponseHeadersPolicy responseHeadersPolicy);

        /**
         * <p>
         * Contains a response headers policy.
         * </p>
         * This is a convenience method that creates an instance of the {@link ResponseHeadersPolicy.Builder} avoiding
         * the need to create one manually via {@link ResponseHeadersPolicy#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ResponseHeadersPolicy.Builder#build()} is called immediately and
         * its result is passed to {@link #responseHeadersPolicy(ResponseHeadersPolicy)}.
         * 
         * @param responseHeadersPolicy
         *        a consumer that will call methods on {@link ResponseHeadersPolicy.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #responseHeadersPolicy(ResponseHeadersPolicy)
         */
        default Builder responseHeadersPolicy(Consumer<ResponseHeadersPolicy.Builder> responseHeadersPolicy) {
            return responseHeadersPolicy(ResponseHeadersPolicy.builder().applyMutation(responseHeadersPolicy).build());
        }

        /**
         * <p>
         * The URL of the response headers policy.
         * </p>
         * 
         * @param location
         *        The URL of the response headers policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder location(String location);

        /**
         * <p>
         * The version identifier for the current version of the response headers policy.
         * </p>
         * 
         * @param eTag
         *        The version identifier for the current version of the response headers policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eTag(String eTag);
    }

    static final class BuilderImpl extends CloudFrontResponse.BuilderImpl implements Builder {
        private ResponseHeadersPolicy responseHeadersPolicy;

        private String location;

        private String eTag;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateResponseHeadersPolicyResponse model) {
            super(model);
            responseHeadersPolicy(model.responseHeadersPolicy);
            location(model.location);
            eTag(model.eTag);
        }

        public final ResponseHeadersPolicy.Builder getResponseHeadersPolicy() {
            return responseHeadersPolicy != null ? responseHeadersPolicy.toBuilder() : null;
        }

        public final void setResponseHeadersPolicy(ResponseHeadersPolicy.BuilderImpl responseHeadersPolicy) {
            this.responseHeadersPolicy = responseHeadersPolicy != null ? responseHeadersPolicy.build() : null;
        }

        @Override
        public final Builder responseHeadersPolicy(ResponseHeadersPolicy responseHeadersPolicy) {
            this.responseHeadersPolicy = responseHeadersPolicy;
            return this;
        }

        public final String getLocation() {
            return location;
        }

        public final void setLocation(String location) {
            this.location = location;
        }

        @Override
        public final Builder location(String location) {
            this.location = location;
            return this;
        }

        public final String getETag() {
            return eTag;
        }

        public final void setETag(String eTag) {
            this.eTag = eTag;
        }

        @Override
        public final Builder eTag(String eTag) {
            this.eTag = eTag;
            return this;
        }

        @Override
        public CreateResponseHeadersPolicyResponse build() {
            return new CreateResponseHeadersPolicyResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
