/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.cloudfront.CloudFrontAsyncClient;
import software.amazon.awssdk.services.cloudfront.internal.UserAgentUtils;
import software.amazon.awssdk.services.cloudfront.model.KeyValueStore;
import software.amazon.awssdk.services.cloudfront.model.ListKeyValueStoresRequest;
import software.amazon.awssdk.services.cloudfront.model.ListKeyValueStoresResponse;

public class ListKeyValueStoresPublisher
implements SdkPublisher<ListKeyValueStoresResponse> {
    private final CloudFrontAsyncClient client;
    private final ListKeyValueStoresRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListKeyValueStoresPublisher(CloudFrontAsyncClient client, ListKeyValueStoresRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListKeyValueStoresPublisher(CloudFrontAsyncClient client, ListKeyValueStoresRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListKeyValueStoresResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListKeyValueStoresResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<KeyValueStore> items() {
        Function<ListKeyValueStoresResponse, Iterator> getIterator = response -> {
            if (response != null && response.keyValueStoreList() != null && response.keyValueStoreList().items() != null) {
                return response.keyValueStoreList().items().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListKeyValueStoresResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListKeyValueStoresResponseFetcher
    implements AsyncPageFetcher<ListKeyValueStoresResponse> {
        private ListKeyValueStoresResponseFetcher() {
        }

        public boolean hasNextPage(ListKeyValueStoresResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.keyValueStoreList().nextMarker());
        }

        public CompletableFuture<ListKeyValueStoresResponse> nextPage(ListKeyValueStoresResponse previousPage) {
            if (previousPage == null) {
                return ListKeyValueStoresPublisher.this.client.listKeyValueStores(ListKeyValueStoresPublisher.this.firstRequest);
            }
            return ListKeyValueStoresPublisher.this.client.listKeyValueStores((ListKeyValueStoresRequest)((Object)ListKeyValueStoresPublisher.this.firstRequest.toBuilder().marker(previousPage.keyValueStoreList().nextMarker()).build()));
        }
    }
}

