/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cloudfront.model.OriginAccessControlOriginTypes;
import software.amazon.awssdk.services.cloudfront.model.OriginAccessControlSigningBehaviors;
import software.amazon.awssdk.services.cloudfront.model.OriginAccessControlSigningProtocols;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class OriginAccessControlConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, OriginAccessControlConfig> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(OriginAccessControlConfig.getter(OriginAccessControlConfig::name)).setter(OriginAccessControlConfig.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").unmarshallLocationName("Name").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(OriginAccessControlConfig.getter(OriginAccessControlConfig::description)).setter(OriginAccessControlConfig.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").unmarshallLocationName("Description").build()}).build();
    private static final SdkField<String> SIGNING_PROTOCOL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SigningProtocol").getter(OriginAccessControlConfig.getter(OriginAccessControlConfig::signingProtocolAsString)).setter(OriginAccessControlConfig.setter(Builder::signingProtocol)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SigningProtocol").unmarshallLocationName("SigningProtocol").build()}).build();
    private static final SdkField<String> SIGNING_BEHAVIOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SigningBehavior").getter(OriginAccessControlConfig.getter(OriginAccessControlConfig::signingBehaviorAsString)).setter(OriginAccessControlConfig.setter(Builder::signingBehavior)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SigningBehavior").unmarshallLocationName("SigningBehavior").build()}).build();
    private static final SdkField<String> ORIGIN_ACCESS_CONTROL_ORIGIN_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OriginAccessControlOriginType").getter(OriginAccessControlConfig.getter(OriginAccessControlConfig::originAccessControlOriginTypeAsString)).setter(OriginAccessControlConfig.setter(Builder::originAccessControlOriginType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OriginAccessControlOriginType").unmarshallLocationName("OriginAccessControlOriginType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, DESCRIPTION_FIELD, SIGNING_PROTOCOL_FIELD, SIGNING_BEHAVIOR_FIELD, ORIGIN_ACCESS_CONTROL_ORIGIN_TYPE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String description;
    private final String signingProtocol;
    private final String signingBehavior;
    private final String originAccessControlOriginType;

    private OriginAccessControlConfig(BuilderImpl builder) {
        this.name = builder.name;
        this.description = builder.description;
        this.signingProtocol = builder.signingProtocol;
        this.signingBehavior = builder.signingBehavior;
        this.originAccessControlOriginType = builder.originAccessControlOriginType;
    }

    public final String name() {
        return this.name;
    }

    public final String description() {
        return this.description;
    }

    public final OriginAccessControlSigningProtocols signingProtocol() {
        return OriginAccessControlSigningProtocols.fromValue(this.signingProtocol);
    }

    public final String signingProtocolAsString() {
        return this.signingProtocol;
    }

    public final OriginAccessControlSigningBehaviors signingBehavior() {
        return OriginAccessControlSigningBehaviors.fromValue(this.signingBehavior);
    }

    public final String signingBehaviorAsString() {
        return this.signingBehavior;
    }

    public final OriginAccessControlOriginTypes originAccessControlOriginType() {
        return OriginAccessControlOriginTypes.fromValue(this.originAccessControlOriginType);
    }

    public final String originAccessControlOriginTypeAsString() {
        return this.originAccessControlOriginType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.signingProtocolAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.signingBehaviorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.originAccessControlOriginTypeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OriginAccessControlConfig)) {
            return false;
        }
        OriginAccessControlConfig other = (OriginAccessControlConfig)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.signingProtocolAsString(), other.signingProtocolAsString()) && Objects.equals(this.signingBehaviorAsString(), other.signingBehaviorAsString()) && Objects.equals(this.originAccessControlOriginTypeAsString(), other.originAccessControlOriginTypeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"OriginAccessControlConfig").add("Name", (Object)this.name()).add("Description", (Object)this.description()).add("SigningProtocol", (Object)this.signingProtocolAsString()).add("SigningBehavior", (Object)this.signingBehaviorAsString()).add("OriginAccessControlOriginType", (Object)this.originAccessControlOriginTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "SigningProtocol": {
                return Optional.ofNullable(clazz.cast(this.signingProtocolAsString()));
            }
            case "SigningBehavior": {
                return Optional.ofNullable(clazz.cast(this.signingBehaviorAsString()));
            }
            case "OriginAccessControlOriginType": {
                return Optional.ofNullable(clazz.cast(this.originAccessControlOriginTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<OriginAccessControlConfig, T> g) {
        return obj -> g.apply((OriginAccessControlConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String description;
        private String signingProtocol;
        private String signingBehavior;
        private String originAccessControlOriginType;

        private BuilderImpl() {
        }

        private BuilderImpl(OriginAccessControlConfig model) {
            this.name(model.name);
            this.description(model.description);
            this.signingProtocol(model.signingProtocol);
            this.signingBehavior(model.signingBehavior);
            this.originAccessControlOriginType(model.originAccessControlOriginType);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getSigningProtocol() {
            return this.signingProtocol;
        }

        public final void setSigningProtocol(String signingProtocol) {
            this.signingProtocol = signingProtocol;
        }

        @Override
        public final Builder signingProtocol(String signingProtocol) {
            this.signingProtocol = signingProtocol;
            return this;
        }

        @Override
        public final Builder signingProtocol(OriginAccessControlSigningProtocols signingProtocol) {
            this.signingProtocol(signingProtocol == null ? null : signingProtocol.toString());
            return this;
        }

        public final String getSigningBehavior() {
            return this.signingBehavior;
        }

        public final void setSigningBehavior(String signingBehavior) {
            this.signingBehavior = signingBehavior;
        }

        @Override
        public final Builder signingBehavior(String signingBehavior) {
            this.signingBehavior = signingBehavior;
            return this;
        }

        @Override
        public final Builder signingBehavior(OriginAccessControlSigningBehaviors signingBehavior) {
            this.signingBehavior(signingBehavior == null ? null : signingBehavior.toString());
            return this;
        }

        public final String getOriginAccessControlOriginType() {
            return this.originAccessControlOriginType;
        }

        public final void setOriginAccessControlOriginType(String originAccessControlOriginType) {
            this.originAccessControlOriginType = originAccessControlOriginType;
        }

        @Override
        public final Builder originAccessControlOriginType(String originAccessControlOriginType) {
            this.originAccessControlOriginType = originAccessControlOriginType;
            return this;
        }

        @Override
        public final Builder originAccessControlOriginType(OriginAccessControlOriginTypes originAccessControlOriginType) {
            this.originAccessControlOriginType(originAccessControlOriginType == null ? null : originAccessControlOriginType.toString());
            return this;
        }

        public OriginAccessControlConfig build() {
            return new OriginAccessControlConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, OriginAccessControlConfig> {
        public Builder name(String var1);

        public Builder description(String var1);

        public Builder signingProtocol(String var1);

        public Builder signingProtocol(OriginAccessControlSigningProtocols var1);

        public Builder signingBehavior(String var1);

        public Builder signingBehavior(OriginAccessControlSigningBehaviors var1);

        public Builder originAccessControlOriginType(String var1);

        public Builder originAccessControlOriginType(OriginAccessControlOriginTypes var1);
    }
}

