/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.cloudfront.CloudFrontAsyncClient;
import software.amazon.awssdk.services.cloudfront.CloudFrontAsyncClientBuilder;
import software.amazon.awssdk.services.cloudfront.CloudFrontServiceClientConfiguration;
import software.amazon.awssdk.services.cloudfront.DefaultCloudFrontAsyncClient;
import software.amazon.awssdk.services.cloudfront.DefaultCloudFrontBaseClientBuilder;
import software.amazon.awssdk.services.cloudfront.endpoints.CloudFrontEndpointProvider;

@SdkInternalApi
final class DefaultCloudFrontAsyncClientBuilder
extends DefaultCloudFrontBaseClientBuilder<CloudFrontAsyncClientBuilder, CloudFrontAsyncClient>
implements CloudFrontAsyncClientBuilder {
    DefaultCloudFrontAsyncClientBuilder() {
    }

    @Override
    public DefaultCloudFrontAsyncClientBuilder endpointProvider(CloudFrontEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final CloudFrontAsyncClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.asyncClientConfiguration();
        DefaultCloudFrontAsyncClientBuilder.validateClientOptions(clientConfiguration);
        CloudFrontServiceClientConfiguration serviceClientConfiguration = CloudFrontServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfiguration.option((ClientOption)AwsClientOption.AWS_REGION)).build();
        return new DefaultCloudFrontAsyncClient(serviceClientConfiguration, clientConfiguration);
    }
}

