/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cloudfront.model.OriginRequestPolicyCookiesConfig;
import software.amazon.awssdk.services.cloudfront.model.OriginRequestPolicyHeadersConfig;
import software.amazon.awssdk.services.cloudfront.model.OriginRequestPolicyQueryStringsConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class OriginRequestPolicyConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, OriginRequestPolicyConfig> {
    private static final SdkField<String> COMMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Comment").getter(OriginRequestPolicyConfig.getter(OriginRequestPolicyConfig::comment)).setter(OriginRequestPolicyConfig.setter(Builder::comment)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Comment").unmarshallLocationName("Comment").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(OriginRequestPolicyConfig.getter(OriginRequestPolicyConfig::name)).setter(OriginRequestPolicyConfig.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").unmarshallLocationName("Name").build()}).build();
    private static final SdkField<OriginRequestPolicyHeadersConfig> HEADERS_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("HeadersConfig").getter(OriginRequestPolicyConfig.getter(OriginRequestPolicyConfig::headersConfig)).setter(OriginRequestPolicyConfig.setter(Builder::headersConfig)).constructor(OriginRequestPolicyHeadersConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HeadersConfig").unmarshallLocationName("HeadersConfig").build()}).build();
    private static final SdkField<OriginRequestPolicyCookiesConfig> COOKIES_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CookiesConfig").getter(OriginRequestPolicyConfig.getter(OriginRequestPolicyConfig::cookiesConfig)).setter(OriginRequestPolicyConfig.setter(Builder::cookiesConfig)).constructor(OriginRequestPolicyCookiesConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CookiesConfig").unmarshallLocationName("CookiesConfig").build()}).build();
    private static final SdkField<OriginRequestPolicyQueryStringsConfig> QUERY_STRINGS_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("QueryStringsConfig").getter(OriginRequestPolicyConfig.getter(OriginRequestPolicyConfig::queryStringsConfig)).setter(OriginRequestPolicyConfig.setter(Builder::queryStringsConfig)).constructor(OriginRequestPolicyQueryStringsConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueryStringsConfig").unmarshallLocationName("QueryStringsConfig").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMMENT_FIELD, NAME_FIELD, HEADERS_CONFIG_FIELD, COOKIES_CONFIG_FIELD, QUERY_STRINGS_CONFIG_FIELD));
    private static final long serialVersionUID = 1L;
    private final String comment;
    private final String name;
    private final OriginRequestPolicyHeadersConfig headersConfig;
    private final OriginRequestPolicyCookiesConfig cookiesConfig;
    private final OriginRequestPolicyQueryStringsConfig queryStringsConfig;

    private OriginRequestPolicyConfig(BuilderImpl builder) {
        this.comment = builder.comment;
        this.name = builder.name;
        this.headersConfig = builder.headersConfig;
        this.cookiesConfig = builder.cookiesConfig;
        this.queryStringsConfig = builder.queryStringsConfig;
    }

    public final String comment() {
        return this.comment;
    }

    public final String name() {
        return this.name;
    }

    public final OriginRequestPolicyHeadersConfig headersConfig() {
        return this.headersConfig;
    }

    public final OriginRequestPolicyCookiesConfig cookiesConfig() {
        return this.cookiesConfig;
    }

    public final OriginRequestPolicyQueryStringsConfig queryStringsConfig() {
        return this.queryStringsConfig;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.comment());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.headersConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.cookiesConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.queryStringsConfig());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OriginRequestPolicyConfig)) {
            return false;
        }
        OriginRequestPolicyConfig other = (OriginRequestPolicyConfig)obj;
        return Objects.equals(this.comment(), other.comment()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.headersConfig(), other.headersConfig()) && Objects.equals(this.cookiesConfig(), other.cookiesConfig()) && Objects.equals(this.queryStringsConfig(), other.queryStringsConfig());
    }

    public final String toString() {
        return ToString.builder((String)"OriginRequestPolicyConfig").add("Comment", (Object)this.comment()).add("Name", (Object)this.name()).add("HeadersConfig", (Object)this.headersConfig()).add("CookiesConfig", (Object)this.cookiesConfig()).add("QueryStringsConfig", (Object)this.queryStringsConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Comment": {
                return Optional.ofNullable(clazz.cast(this.comment()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "HeadersConfig": {
                return Optional.ofNullable(clazz.cast(this.headersConfig()));
            }
            case "CookiesConfig": {
                return Optional.ofNullable(clazz.cast(this.cookiesConfig()));
            }
            case "QueryStringsConfig": {
                return Optional.ofNullable(clazz.cast(this.queryStringsConfig()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<OriginRequestPolicyConfig, T> g) {
        return obj -> g.apply((OriginRequestPolicyConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String comment;
        private String name;
        private OriginRequestPolicyHeadersConfig headersConfig;
        private OriginRequestPolicyCookiesConfig cookiesConfig;
        private OriginRequestPolicyQueryStringsConfig queryStringsConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(OriginRequestPolicyConfig model) {
            this.comment(model.comment);
            this.name(model.name);
            this.headersConfig(model.headersConfig);
            this.cookiesConfig(model.cookiesConfig);
            this.queryStringsConfig(model.queryStringsConfig);
        }

        public final String getComment() {
            return this.comment;
        }

        public final void setComment(String comment) {
            this.comment = comment;
        }

        @Override
        @Transient
        public final Builder comment(String comment) {
            this.comment = comment;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        @Transient
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final OriginRequestPolicyHeadersConfig.Builder getHeadersConfig() {
            return this.headersConfig != null ? this.headersConfig.toBuilder() : null;
        }

        public final void setHeadersConfig(OriginRequestPolicyHeadersConfig.BuilderImpl headersConfig) {
            this.headersConfig = headersConfig != null ? headersConfig.build() : null;
        }

        @Override
        @Transient
        public final Builder headersConfig(OriginRequestPolicyHeadersConfig headersConfig) {
            this.headersConfig = headersConfig;
            return this;
        }

        public final OriginRequestPolicyCookiesConfig.Builder getCookiesConfig() {
            return this.cookiesConfig != null ? this.cookiesConfig.toBuilder() : null;
        }

        public final void setCookiesConfig(OriginRequestPolicyCookiesConfig.BuilderImpl cookiesConfig) {
            this.cookiesConfig = cookiesConfig != null ? cookiesConfig.build() : null;
        }

        @Override
        @Transient
        public final Builder cookiesConfig(OriginRequestPolicyCookiesConfig cookiesConfig) {
            this.cookiesConfig = cookiesConfig;
            return this;
        }

        public final OriginRequestPolicyQueryStringsConfig.Builder getQueryStringsConfig() {
            return this.queryStringsConfig != null ? this.queryStringsConfig.toBuilder() : null;
        }

        public final void setQueryStringsConfig(OriginRequestPolicyQueryStringsConfig.BuilderImpl queryStringsConfig) {
            this.queryStringsConfig = queryStringsConfig != null ? queryStringsConfig.build() : null;
        }

        @Override
        @Transient
        public final Builder queryStringsConfig(OriginRequestPolicyQueryStringsConfig queryStringsConfig) {
            this.queryStringsConfig = queryStringsConfig;
            return this;
        }

        public OriginRequestPolicyConfig build() {
            return new OriginRequestPolicyConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, OriginRequestPolicyConfig> {
        public Builder comment(String var1);

        public Builder name(String var1);

        public Builder headersConfig(OriginRequestPolicyHeadersConfig var1);

        default public Builder headersConfig(Consumer<OriginRequestPolicyHeadersConfig.Builder> headersConfig) {
            return this.headersConfig((OriginRequestPolicyHeadersConfig)((OriginRequestPolicyHeadersConfig.Builder)OriginRequestPolicyHeadersConfig.builder().applyMutation(headersConfig)).build());
        }

        public Builder cookiesConfig(OriginRequestPolicyCookiesConfig var1);

        default public Builder cookiesConfig(Consumer<OriginRequestPolicyCookiesConfig.Builder> cookiesConfig) {
            return this.cookiesConfig((OriginRequestPolicyCookiesConfig)((OriginRequestPolicyCookiesConfig.Builder)OriginRequestPolicyCookiesConfig.builder().applyMutation(cookiesConfig)).build());
        }

        public Builder queryStringsConfig(OriginRequestPolicyQueryStringsConfig var1);

        default public Builder queryStringsConfig(Consumer<OriginRequestPolicyQueryStringsConfig.Builder> queryStringsConfig) {
            return this.queryStringsConfig((OriginRequestPolicyQueryStringsConfig)((OriginRequestPolicyQueryStringsConfig.Builder)OriginRequestPolicyQueryStringsConfig.builder().applyMutation(queryStringsConfig)).build());
        }
    }
}

