/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfront.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A complex data type for the origin groups specified for a distribution.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class OriginGroups implements SdkPojo, Serializable, ToCopyableBuilder<OriginGroups.Builder, OriginGroups> {
    private static final SdkField<Integer> QUANTITY_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("Quantity")
            .getter(getter(OriginGroups::quantity))
            .setter(setter(Builder::quantity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Quantity")
                    .unmarshallLocationName("Quantity").build()).build();

    private static final SdkField<List<OriginGroup>> ITEMS_FIELD = SdkField
            .<List<OriginGroup>> builder(MarshallingType.LIST)
            .memberName("Items")
            .getter(getter(OriginGroups::items))
            .setter(setter(Builder::items))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Items")
                    .unmarshallLocationName("Items").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("OriginGroup")
                            .memberFieldInfo(
                                    SdkField.<OriginGroup> builder(MarshallingType.SDK_POJO)
                                            .constructor(OriginGroup::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("OriginGroup").unmarshallLocationName("OriginGroup").build())
                                            .build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(QUANTITY_FIELD, ITEMS_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer quantity;

    private final List<OriginGroup> items;

    private OriginGroups(BuilderImpl builder) {
        this.quantity = builder.quantity;
        this.items = builder.items;
    }

    /**
     * <p>
     * The number of origin groups.
     * </p>
     * 
     * @return The number of origin groups.
     */
    public final Integer quantity() {
        return quantity;
    }

    /**
     * For responses, this returns true if the service returned a value for the Items property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasItems() {
        return items != null && !(items instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The items (origin groups) in a distribution.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasItems} method.
     * </p>
     * 
     * @return The items (origin groups) in a distribution.
     */
    public final List<OriginGroup> items() {
        return items;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(quantity());
        hashCode = 31 * hashCode + Objects.hashCode(hasItems() ? items() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OriginGroups)) {
            return false;
        }
        OriginGroups other = (OriginGroups) obj;
        return Objects.equals(quantity(), other.quantity()) && hasItems() == other.hasItems()
                && Objects.equals(items(), other.items());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("OriginGroups").add("Quantity", quantity()).add("Items", hasItems() ? items() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Quantity":
            return Optional.ofNullable(clazz.cast(quantity()));
        case "Items":
            return Optional.ofNullable(clazz.cast(items()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<OriginGroups, T> g) {
        return obj -> g.apply((OriginGroups) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, OriginGroups> {
        /**
         * <p>
         * The number of origin groups.
         * </p>
         * 
         * @param quantity
         *        The number of origin groups.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder quantity(Integer quantity);

        /**
         * <p>
         * The items (origin groups) in a distribution.
         * </p>
         * 
         * @param items
         *        The items (origin groups) in a distribution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder items(Collection<OriginGroup> items);

        /**
         * <p>
         * The items (origin groups) in a distribution.
         * </p>
         * 
         * @param items
         *        The items (origin groups) in a distribution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder items(OriginGroup... items);

        /**
         * <p>
         * The items (origin groups) in a distribution.
         * </p>
         * This is a convenience that creates an instance of the {@link List<OriginGroup>.Builder} avoiding the need to
         * create one manually via {@link List<OriginGroup>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<OriginGroup>.Builder#build()} is called immediately and its
         * result is passed to {@link #items(List<OriginGroup>)}.
         * 
         * @param items
         *        a consumer that will call methods on {@link List<OriginGroup>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #items(List<OriginGroup>)
         */
        Builder items(Consumer<OriginGroup.Builder>... items);
    }

    static final class BuilderImpl implements Builder {
        private Integer quantity;

        private List<OriginGroup> items = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(OriginGroups model) {
            quantity(model.quantity);
            items(model.items);
        }

        public final Integer getQuantity() {
            return quantity;
        }

        public final void setQuantity(Integer quantity) {
            this.quantity = quantity;
        }

        @Override
        @Transient
        public final Builder quantity(Integer quantity) {
            this.quantity = quantity;
            return this;
        }

        public final List<OriginGroup.Builder> getItems() {
            List<OriginGroup.Builder> result = OriginGroupListCopier.copyToBuilder(this.items);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setItems(Collection<OriginGroup.BuilderImpl> items) {
            this.items = OriginGroupListCopier.copyFromBuilder(items);
        }

        @Override
        @Transient
        public final Builder items(Collection<OriginGroup> items) {
            this.items = OriginGroupListCopier.copy(items);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder items(OriginGroup... items) {
            items(Arrays.asList(items));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder items(Consumer<OriginGroup.Builder>... items) {
            items(Stream.of(items).map(c -> OriginGroup.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public OriginGroups build() {
            return new OriginGroups(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
