/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfront.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListResponseHeadersPoliciesResponse extends CloudFrontResponse implements
        ToCopyableBuilder<ListResponseHeadersPoliciesResponse.Builder, ListResponseHeadersPoliciesResponse> {
    private static final SdkField<ResponseHeadersPolicyList> RESPONSE_HEADERS_POLICY_LIST_FIELD = SdkField
            .<ResponseHeadersPolicyList> builder(MarshallingType.SDK_POJO)
            .memberName("ResponseHeadersPolicyList")
            .getter(getter(ListResponseHeadersPoliciesResponse::responseHeadersPolicyList))
            .setter(setter(Builder::responseHeadersPolicyList))
            .constructor(ResponseHeadersPolicyList::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResponseHeadersPolicyList")
                    .unmarshallLocationName("ResponseHeadersPolicyList").build(), PayloadTrait.create()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(RESPONSE_HEADERS_POLICY_LIST_FIELD));

    private final ResponseHeadersPolicyList responseHeadersPolicyList;

    private ListResponseHeadersPoliciesResponse(BuilderImpl builder) {
        super(builder);
        this.responseHeadersPolicyList = builder.responseHeadersPolicyList;
    }

    /**
     * <p>
     * A list of response headers policies.
     * </p>
     * 
     * @return A list of response headers policies.
     */
    public final ResponseHeadersPolicyList responseHeadersPolicyList() {
        return responseHeadersPolicyList;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(responseHeadersPolicyList());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListResponseHeadersPoliciesResponse)) {
            return false;
        }
        ListResponseHeadersPoliciesResponse other = (ListResponseHeadersPoliciesResponse) obj;
        return Objects.equals(responseHeadersPolicyList(), other.responseHeadersPolicyList());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListResponseHeadersPoliciesResponse")
                .add("ResponseHeadersPolicyList", responseHeadersPolicyList()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ResponseHeadersPolicyList":
            return Optional.ofNullable(clazz.cast(responseHeadersPolicyList()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListResponseHeadersPoliciesResponse, T> g) {
        return obj -> g.apply((ListResponseHeadersPoliciesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudFrontResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListResponseHeadersPoliciesResponse> {
        /**
         * <p>
         * A list of response headers policies.
         * </p>
         * 
         * @param responseHeadersPolicyList
         *        A list of response headers policies.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder responseHeadersPolicyList(ResponseHeadersPolicyList responseHeadersPolicyList);

        /**
         * <p>
         * A list of response headers policies.
         * </p>
         * This is a convenience that creates an instance of the {@link ResponseHeadersPolicyList.Builder} avoiding the
         * need to create one manually via {@link ResponseHeadersPolicyList#builder()}.
         *
         * When the {@link Consumer} completes, {@link ResponseHeadersPolicyList.Builder#build()} is called immediately
         * and its result is passed to {@link #responseHeadersPolicyList(ResponseHeadersPolicyList)}.
         * 
         * @param responseHeadersPolicyList
         *        a consumer that will call methods on {@link ResponseHeadersPolicyList.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #responseHeadersPolicyList(ResponseHeadersPolicyList)
         */
        default Builder responseHeadersPolicyList(Consumer<ResponseHeadersPolicyList.Builder> responseHeadersPolicyList) {
            return responseHeadersPolicyList(ResponseHeadersPolicyList.builder().applyMutation(responseHeadersPolicyList).build());
        }
    }

    static final class BuilderImpl extends CloudFrontResponse.BuilderImpl implements Builder {
        private ResponseHeadersPolicyList responseHeadersPolicyList;

        private BuilderImpl() {
        }

        private BuilderImpl(ListResponseHeadersPoliciesResponse model) {
            super(model);
            responseHeadersPolicyList(model.responseHeadersPolicyList);
        }

        public final ResponseHeadersPolicyList.Builder getResponseHeadersPolicyList() {
            return responseHeadersPolicyList != null ? responseHeadersPolicyList.toBuilder() : null;
        }

        public final void setResponseHeadersPolicyList(ResponseHeadersPolicyList.BuilderImpl responseHeadersPolicyList) {
            this.responseHeadersPolicyList = responseHeadersPolicyList != null ? responseHeadersPolicyList.build() : null;
        }

        @Override
        @Transient
        public final Builder responseHeadersPolicyList(ResponseHeadersPolicyList responseHeadersPolicyList) {
            this.responseHeadersPolicyList = responseHeadersPolicyList;
            return this;
        }

        @Override
        public ListResponseHeadersPoliciesResponse build() {
            return new ListResponseHeadersPoliciesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
