/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfront.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListDistributionsByKeyGroupRequest extends CloudFrontRequest implements
        ToCopyableBuilder<ListDistributionsByKeyGroupRequest.Builder, ListDistributionsByKeyGroupRequest> {
    private static final SdkField<String> MARKER_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Marker")
            .getter(getter(ListDistributionsByKeyGroupRequest::marker))
            .setter(setter(Builder::marker))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("Marker")
                    .unmarshallLocationName("Marker").build()).build();

    private static final SdkField<String> MAX_ITEMS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("MaxItems")
            .getter(getter(ListDistributionsByKeyGroupRequest::maxItems))
            .setter(setter(Builder::maxItems))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("MaxItems")
                    .unmarshallLocationName("MaxItems").build()).build();

    private static final SdkField<String> KEY_GROUP_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("KeyGroupId")
            .getter(getter(ListDistributionsByKeyGroupRequest::keyGroupId))
            .setter(setter(Builder::keyGroupId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("KeyGroupId")
                    .unmarshallLocationName("KeyGroupId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MARKER_FIELD, MAX_ITEMS_FIELD,
            KEY_GROUP_ID_FIELD));

    private final String marker;

    private final String maxItems;

    private final String keyGroupId;

    private ListDistributionsByKeyGroupRequest(BuilderImpl builder) {
        super(builder);
        this.marker = builder.marker;
        this.maxItems = builder.maxItems;
        this.keyGroupId = builder.keyGroupId;
    }

    /**
     * <p>
     * Use this field when paginating results to indicate where to begin in your list of distribution IDs. The response
     * includes distribution IDs in the list that occur after the marker. To get the next page of the list, set this
     * field’s value to the value of <code>NextMarker</code> from the current page’s response.
     * </p>
     * 
     * @return Use this field when paginating results to indicate where to begin in your list of distribution IDs. The
     *         response includes distribution IDs in the list that occur after the marker. To get the next page of the
     *         list, set this field’s value to the value of <code>NextMarker</code> from the current page’s response.
     */
    public final String marker() {
        return marker;
    }

    /**
     * <p>
     * The maximum number of distribution IDs that you want in the response.
     * </p>
     * 
     * @return The maximum number of distribution IDs that you want in the response.
     */
    public final String maxItems() {
        return maxItems;
    }

    /**
     * <p>
     * The ID of the key group whose associated distribution IDs you are listing.
     * </p>
     * 
     * @return The ID of the key group whose associated distribution IDs you are listing.
     */
    public final String keyGroupId() {
        return keyGroupId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(marker());
        hashCode = 31 * hashCode + Objects.hashCode(maxItems());
        hashCode = 31 * hashCode + Objects.hashCode(keyGroupId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDistributionsByKeyGroupRequest)) {
            return false;
        }
        ListDistributionsByKeyGroupRequest other = (ListDistributionsByKeyGroupRequest) obj;
        return Objects.equals(marker(), other.marker()) && Objects.equals(maxItems(), other.maxItems())
                && Objects.equals(keyGroupId(), other.keyGroupId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListDistributionsByKeyGroupRequest").add("Marker", marker()).add("MaxItems", maxItems())
                .add("KeyGroupId", keyGroupId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Marker":
            return Optional.ofNullable(clazz.cast(marker()));
        case "MaxItems":
            return Optional.ofNullable(clazz.cast(maxItems()));
        case "KeyGroupId":
            return Optional.ofNullable(clazz.cast(keyGroupId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListDistributionsByKeyGroupRequest, T> g) {
        return obj -> g.apply((ListDistributionsByKeyGroupRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudFrontRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, ListDistributionsByKeyGroupRequest> {
        /**
         * <p>
         * Use this field when paginating results to indicate where to begin in your list of distribution IDs. The
         * response includes distribution IDs in the list that occur after the marker. To get the next page of the list,
         * set this field’s value to the value of <code>NextMarker</code> from the current page’s response.
         * </p>
         * 
         * @param marker
         *        Use this field when paginating results to indicate where to begin in your list of distribution IDs.
         *        The response includes distribution IDs in the list that occur after the marker. To get the next page
         *        of the list, set this field’s value to the value of <code>NextMarker</code> from the current page’s
         *        response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder marker(String marker);

        /**
         * <p>
         * The maximum number of distribution IDs that you want in the response.
         * </p>
         * 
         * @param maxItems
         *        The maximum number of distribution IDs that you want in the response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxItems(String maxItems);

        /**
         * <p>
         * The ID of the key group whose associated distribution IDs you are listing.
         * </p>
         * 
         * @param keyGroupId
         *        The ID of the key group whose associated distribution IDs you are listing.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keyGroupId(String keyGroupId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CloudFrontRequest.BuilderImpl implements Builder {
        private String marker;

        private String maxItems;

        private String keyGroupId;

        private BuilderImpl() {
        }

        private BuilderImpl(ListDistributionsByKeyGroupRequest model) {
            super(model);
            marker(model.marker);
            maxItems(model.maxItems);
            keyGroupId(model.keyGroupId);
        }

        public final String getMarker() {
            return marker;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        @Transient
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final String getMaxItems() {
            return maxItems;
        }

        public final void setMaxItems(String maxItems) {
            this.maxItems = maxItems;
        }

        @Override
        @Transient
        public final Builder maxItems(String maxItems) {
            this.maxItems = maxItems;
            return this;
        }

        public final String getKeyGroupId() {
            return keyGroupId;
        }

        public final void setKeyGroupId(String keyGroupId) {
            this.keyGroupId = keyGroupId;
        }

        @Override
        @Transient
        public final Builder keyGroupId(String keyGroupId) {
            this.keyGroupId = keyGroupId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListDistributionsByKeyGroupRequest build() {
            return new ListDistributionsByKeyGroupRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
