/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfront.model;

import java.beans.Transient;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetFunctionResponse extends CloudFrontResponse implements
        ToCopyableBuilder<GetFunctionResponse.Builder, GetFunctionResponse> {
    private static final SdkField<SdkBytes> FUNCTION_CODE_FIELD = SdkField
            .<SdkBytes> builder(MarshallingType.SDK_BYTES)
            .memberName("FunctionCode")
            .getter(getter(GetFunctionResponse::functionCode))
            .setter(setter(Builder::functionCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FunctionCode")
                    .unmarshallLocationName("FunctionCode").build(), PayloadTrait.create()).build();

    private static final SdkField<String> E_TAG_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ETag")
            .getter(getter(GetFunctionResponse::eTag))
            .setter(setter(Builder::eTag))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("ETag").unmarshallLocationName("ETag")
                    .build()).build();

    private static final SdkField<String> CONTENT_TYPE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ContentType")
            .getter(getter(GetFunctionResponse::contentType))
            .setter(setter(Builder::contentType))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("Content-Type")
                    .unmarshallLocationName("Content-Type").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FUNCTION_CODE_FIELD,
            E_TAG_FIELD, CONTENT_TYPE_FIELD));

    private final SdkBytes functionCode;

    private final String eTag;

    private final String contentType;

    private GetFunctionResponse(BuilderImpl builder) {
        super(builder);
        this.functionCode = builder.functionCode;
        this.eTag = builder.eTag;
        this.contentType = builder.contentType;
    }

    /**
     * <p>
     * The function code of a CloudFront function.
     * </p>
     * 
     * @return The function code of a CloudFront function.
     */
    public final SdkBytes functionCode() {
        return functionCode;
    }

    /**
     * <p>
     * The version identifier for the current version of the CloudFront function.
     * </p>
     * 
     * @return The version identifier for the current version of the CloudFront function.
     */
    public final String eTag() {
        return eTag;
    }

    /**
     * <p>
     * The content type (media type) of the response.
     * </p>
     * 
     * @return The content type (media type) of the response.
     */
    public final String contentType() {
        return contentType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(functionCode());
        hashCode = 31 * hashCode + Objects.hashCode(eTag());
        hashCode = 31 * hashCode + Objects.hashCode(contentType());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetFunctionResponse)) {
            return false;
        }
        GetFunctionResponse other = (GetFunctionResponse) obj;
        return Objects.equals(functionCode(), other.functionCode()) && Objects.equals(eTag(), other.eTag())
                && Objects.equals(contentType(), other.contentType());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetFunctionResponse")
                .add("FunctionCode", functionCode() == null ? null : "*** Sensitive Data Redacted ***").add("ETag", eTag())
                .add("ContentType", contentType()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FunctionCode":
            return Optional.ofNullable(clazz.cast(functionCode()));
        case "ETag":
            return Optional.ofNullable(clazz.cast(eTag()));
        case "ContentType":
            return Optional.ofNullable(clazz.cast(contentType()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetFunctionResponse, T> g) {
        return obj -> g.apply((GetFunctionResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudFrontResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetFunctionResponse> {
        /**
         * <p>
         * The function code of a CloudFront function.
         * </p>
         * 
         * @param functionCode
         *        The function code of a CloudFront function.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder functionCode(SdkBytes functionCode);

        /**
         * <p>
         * The version identifier for the current version of the CloudFront function.
         * </p>
         * 
         * @param eTag
         *        The version identifier for the current version of the CloudFront function.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eTag(String eTag);

        /**
         * <p>
         * The content type (media type) of the response.
         * </p>
         * 
         * @param contentType
         *        The content type (media type) of the response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contentType(String contentType);
    }

    static final class BuilderImpl extends CloudFrontResponse.BuilderImpl implements Builder {
        private SdkBytes functionCode;

        private String eTag;

        private String contentType;

        private BuilderImpl() {
        }

        private BuilderImpl(GetFunctionResponse model) {
            super(model);
            functionCode(model.functionCode);
            eTag(model.eTag);
            contentType(model.contentType);
        }

        public final ByteBuffer getFunctionCode() {
            return functionCode == null ? null : functionCode.asByteBuffer();
        }

        public final void setFunctionCode(ByteBuffer functionCode) {
            functionCode(functionCode == null ? null : SdkBytes.fromByteBuffer(functionCode));
        }

        @Override
        @Transient
        public final Builder functionCode(SdkBytes functionCode) {
            this.functionCode = functionCode;
            return this;
        }

        public final String getETag() {
            return eTag;
        }

        public final void setETag(String eTag) {
            this.eTag = eTag;
        }

        @Override
        @Transient
        public final Builder eTag(String eTag) {
            this.eTag = eTag;
            return this;
        }

        public final String getContentType() {
            return contentType;
        }

        public final void setContentType(String contentType) {
            this.contentType = contentType;
        }

        @Override
        @Transient
        public final Builder contentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        @Override
        public GetFunctionResponse build() {
            return new GetFunctionResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
