/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfront.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetFieldLevelEncryptionResponse extends CloudFrontResponse implements
        ToCopyableBuilder<GetFieldLevelEncryptionResponse.Builder, GetFieldLevelEncryptionResponse> {
    private static final SdkField<FieldLevelEncryption> FIELD_LEVEL_ENCRYPTION_FIELD = SdkField
            .<FieldLevelEncryption> builder(MarshallingType.SDK_POJO)
            .memberName("FieldLevelEncryption")
            .getter(getter(GetFieldLevelEncryptionResponse::fieldLevelEncryption))
            .setter(setter(Builder::fieldLevelEncryption))
            .constructor(FieldLevelEncryption::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FieldLevelEncryption")
                    .unmarshallLocationName("FieldLevelEncryption").build(), PayloadTrait.create()).build();

    private static final SdkField<String> E_TAG_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ETag")
            .getter(getter(GetFieldLevelEncryptionResponse::eTag))
            .setter(setter(Builder::eTag))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("ETag").unmarshallLocationName("ETag")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FIELD_LEVEL_ENCRYPTION_FIELD,
            E_TAG_FIELD));

    private final FieldLevelEncryption fieldLevelEncryption;

    private final String eTag;

    private GetFieldLevelEncryptionResponse(BuilderImpl builder) {
        super(builder);
        this.fieldLevelEncryption = builder.fieldLevelEncryption;
        this.eTag = builder.eTag;
    }

    /**
     * <p>
     * Return the field-level encryption configuration information.
     * </p>
     * 
     * @return Return the field-level encryption configuration information.
     */
    public final FieldLevelEncryption fieldLevelEncryption() {
        return fieldLevelEncryption;
    }

    /**
     * <p>
     * The current version of the field level encryption configuration. For example: <code>E2QWRUHAPOMQZL</code>.
     * </p>
     * 
     * @return The current version of the field level encryption configuration. For example: <code>E2QWRUHAPOMQZL</code>
     *         .
     */
    public final String eTag() {
        return eTag;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(fieldLevelEncryption());
        hashCode = 31 * hashCode + Objects.hashCode(eTag());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetFieldLevelEncryptionResponse)) {
            return false;
        }
        GetFieldLevelEncryptionResponse other = (GetFieldLevelEncryptionResponse) obj;
        return Objects.equals(fieldLevelEncryption(), other.fieldLevelEncryption()) && Objects.equals(eTag(), other.eTag());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetFieldLevelEncryptionResponse").add("FieldLevelEncryption", fieldLevelEncryption())
                .add("ETag", eTag()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FieldLevelEncryption":
            return Optional.ofNullable(clazz.cast(fieldLevelEncryption()));
        case "ETag":
            return Optional.ofNullable(clazz.cast(eTag()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetFieldLevelEncryptionResponse, T> g) {
        return obj -> g.apply((GetFieldLevelEncryptionResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudFrontResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetFieldLevelEncryptionResponse> {
        /**
         * <p>
         * Return the field-level encryption configuration information.
         * </p>
         * 
         * @param fieldLevelEncryption
         *        Return the field-level encryption configuration information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fieldLevelEncryption(FieldLevelEncryption fieldLevelEncryption);

        /**
         * <p>
         * Return the field-level encryption configuration information.
         * </p>
         * This is a convenience that creates an instance of the {@link FieldLevelEncryption.Builder} avoiding the need
         * to create one manually via {@link FieldLevelEncryption#builder()}.
         *
         * When the {@link Consumer} completes, {@link FieldLevelEncryption.Builder#build()} is called immediately and
         * its result is passed to {@link #fieldLevelEncryption(FieldLevelEncryption)}.
         * 
         * @param fieldLevelEncryption
         *        a consumer that will call methods on {@link FieldLevelEncryption.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #fieldLevelEncryption(FieldLevelEncryption)
         */
        default Builder fieldLevelEncryption(Consumer<FieldLevelEncryption.Builder> fieldLevelEncryption) {
            return fieldLevelEncryption(FieldLevelEncryption.builder().applyMutation(fieldLevelEncryption).build());
        }

        /**
         * <p>
         * The current version of the field level encryption configuration. For example: <code>E2QWRUHAPOMQZL</code>.
         * </p>
         * 
         * @param eTag
         *        The current version of the field level encryption configuration. For example:
         *        <code>E2QWRUHAPOMQZL</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eTag(String eTag);
    }

    static final class BuilderImpl extends CloudFrontResponse.BuilderImpl implements Builder {
        private FieldLevelEncryption fieldLevelEncryption;

        private String eTag;

        private BuilderImpl() {
        }

        private BuilderImpl(GetFieldLevelEncryptionResponse model) {
            super(model);
            fieldLevelEncryption(model.fieldLevelEncryption);
            eTag(model.eTag);
        }

        public final FieldLevelEncryption.Builder getFieldLevelEncryption() {
            return fieldLevelEncryption != null ? fieldLevelEncryption.toBuilder() : null;
        }

        public final void setFieldLevelEncryption(FieldLevelEncryption.BuilderImpl fieldLevelEncryption) {
            this.fieldLevelEncryption = fieldLevelEncryption != null ? fieldLevelEncryption.build() : null;
        }

        @Override
        @Transient
        public final Builder fieldLevelEncryption(FieldLevelEncryption fieldLevelEncryption) {
            this.fieldLevelEncryption = fieldLevelEncryption;
            return this;
        }

        public final String getETag() {
            return eTag;
        }

        public final void setETag(String eTag) {
            this.eTag = eTag;
        }

        @Override
        @Transient
        public final Builder eTag(String eTag) {
            this.eTag = eTag;
            return this;
        }

        @Override
        public GetFieldLevelEncryptionResponse build() {
            return new GetFieldLevelEncryptionResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
