/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfront.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateCachePolicyRequest extends CloudFrontRequest implements
        ToCopyableBuilder<UpdateCachePolicyRequest.Builder, UpdateCachePolicyRequest> {
    private static final SdkField<CachePolicyConfig> CACHE_POLICY_CONFIG_FIELD = SdkField
            .<CachePolicyConfig> builder(MarshallingType.SDK_POJO)
            .memberName("CachePolicyConfig")
            .getter(getter(UpdateCachePolicyRequest::cachePolicyConfig))
            .setter(setter(Builder::cachePolicyConfig))
            .constructor(CachePolicyConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CachePolicyConfig")
                    .unmarshallLocationName("CachePolicyConfig").build(), PayloadTrait.create()).build();

    private static final SdkField<String> ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Id")
            .getter(getter(UpdateCachePolicyRequest::id))
            .setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("Id").unmarshallLocationName("Id")
                    .build()).build();

    private static final SdkField<String> IF_MATCH_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("IfMatch")
            .getter(getter(UpdateCachePolicyRequest::ifMatch))
            .setter(setter(Builder::ifMatch))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("If-Match")
                    .unmarshallLocationName("If-Match").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CACHE_POLICY_CONFIG_FIELD,
            ID_FIELD, IF_MATCH_FIELD));

    private final CachePolicyConfig cachePolicyConfig;

    private final String id;

    private final String ifMatch;

    private UpdateCachePolicyRequest(BuilderImpl builder) {
        super(builder);
        this.cachePolicyConfig = builder.cachePolicyConfig;
        this.id = builder.id;
        this.ifMatch = builder.ifMatch;
    }

    /**
     * <p>
     * A cache policy configuration.
     * </p>
     * 
     * @return A cache policy configuration.
     */
    public final CachePolicyConfig cachePolicyConfig() {
        return cachePolicyConfig;
    }

    /**
     * <p>
     * The unique identifier for the cache policy that you are updating. The identifier is returned in a cache
     * behavior’s <code>CachePolicyId</code> field in the response to <code>GetDistributionConfig</code>.
     * </p>
     * 
     * @return The unique identifier for the cache policy that you are updating. The identifier is returned in a cache
     *         behavior’s <code>CachePolicyId</code> field in the response to <code>GetDistributionConfig</code>.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The version of the cache policy that you are updating. The version is returned in the cache policy’s
     * <code>ETag</code> field in the response to <code>GetCachePolicyConfig</code>.
     * </p>
     * 
     * @return The version of the cache policy that you are updating. The version is returned in the cache policy’s
     *         <code>ETag</code> field in the response to <code>GetCachePolicyConfig</code>.
     */
    public final String ifMatch() {
        return ifMatch;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(cachePolicyConfig());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(ifMatch());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateCachePolicyRequest)) {
            return false;
        }
        UpdateCachePolicyRequest other = (UpdateCachePolicyRequest) obj;
        return Objects.equals(cachePolicyConfig(), other.cachePolicyConfig()) && Objects.equals(id(), other.id())
                && Objects.equals(ifMatch(), other.ifMatch());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateCachePolicyRequest").add("CachePolicyConfig", cachePolicyConfig()).add("Id", id())
                .add("IfMatch", ifMatch()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CachePolicyConfig":
            return Optional.ofNullable(clazz.cast(cachePolicyConfig()));
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "IfMatch":
            return Optional.ofNullable(clazz.cast(ifMatch()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateCachePolicyRequest, T> g) {
        return obj -> g.apply((UpdateCachePolicyRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudFrontRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateCachePolicyRequest> {
        /**
         * <p>
         * A cache policy configuration.
         * </p>
         * 
         * @param cachePolicyConfig
         *        A cache policy configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cachePolicyConfig(CachePolicyConfig cachePolicyConfig);

        /**
         * <p>
         * A cache policy configuration.
         * </p>
         * This is a convenience that creates an instance of the {@link CachePolicyConfig.Builder} avoiding the need to
         * create one manually via {@link CachePolicyConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link CachePolicyConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #cachePolicyConfig(CachePolicyConfig)}.
         * 
         * @param cachePolicyConfig
         *        a consumer that will call methods on {@link CachePolicyConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #cachePolicyConfig(CachePolicyConfig)
         */
        default Builder cachePolicyConfig(Consumer<CachePolicyConfig.Builder> cachePolicyConfig) {
            return cachePolicyConfig(CachePolicyConfig.builder().applyMutation(cachePolicyConfig).build());
        }

        /**
         * <p>
         * The unique identifier for the cache policy that you are updating. The identifier is returned in a cache
         * behavior’s <code>CachePolicyId</code> field in the response to <code>GetDistributionConfig</code>.
         * </p>
         * 
         * @param id
         *        The unique identifier for the cache policy that you are updating. The identifier is returned in a
         *        cache behavior’s <code>CachePolicyId</code> field in the response to
         *        <code>GetDistributionConfig</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The version of the cache policy that you are updating. The version is returned in the cache policy’s
         * <code>ETag</code> field in the response to <code>GetCachePolicyConfig</code>.
         * </p>
         * 
         * @param ifMatch
         *        The version of the cache policy that you are updating. The version is returned in the cache policy’s
         *        <code>ETag</code> field in the response to <code>GetCachePolicyConfig</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ifMatch(String ifMatch);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CloudFrontRequest.BuilderImpl implements Builder {
        private CachePolicyConfig cachePolicyConfig;

        private String id;

        private String ifMatch;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateCachePolicyRequest model) {
            super(model);
            cachePolicyConfig(model.cachePolicyConfig);
            id(model.id);
            ifMatch(model.ifMatch);
        }

        public final CachePolicyConfig.Builder getCachePolicyConfig() {
            return cachePolicyConfig != null ? cachePolicyConfig.toBuilder() : null;
        }

        @Override
        public final Builder cachePolicyConfig(CachePolicyConfig cachePolicyConfig) {
            this.cachePolicyConfig = cachePolicyConfig;
            return this;
        }

        public final void setCachePolicyConfig(CachePolicyConfig.BuilderImpl cachePolicyConfig) {
            this.cachePolicyConfig = cachePolicyConfig != null ? cachePolicyConfig.build() : null;
        }

        public final String getId() {
            return id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getIfMatch() {
            return ifMatch;
        }

        @Override
        public final Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public final void setIfMatch(String ifMatch) {
            this.ifMatch = ifMatch;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateCachePolicyRequest build() {
            return new UpdateCachePolicyRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
