/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfront.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The RTMP distribution's configuration information.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class StreamingDistributionConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<StreamingDistributionConfig.Builder, StreamingDistributionConfig> {
    private static final SdkField<String> CALLER_REFERENCE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("CallerReference")
            .getter(getter(StreamingDistributionConfig::callerReference))
            .setter(setter(Builder::callerReference))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CallerReference")
                    .unmarshallLocationName("CallerReference").build()).build();

    private static final SdkField<S3Origin> S3_ORIGIN_FIELD = SdkField
            .<S3Origin> builder(MarshallingType.SDK_POJO)
            .memberName("S3Origin")
            .getter(getter(StreamingDistributionConfig::s3Origin))
            .setter(setter(Builder::s3Origin))
            .constructor(S3Origin::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3Origin")
                    .unmarshallLocationName("S3Origin").build()).build();

    private static final SdkField<Aliases> ALIASES_FIELD = SdkField
            .<Aliases> builder(MarshallingType.SDK_POJO)
            .memberName("Aliases")
            .getter(getter(StreamingDistributionConfig::aliases))
            .setter(setter(Builder::aliases))
            .constructor(Aliases::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Aliases")
                    .unmarshallLocationName("Aliases").build()).build();

    private static final SdkField<String> COMMENT_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Comment")
            .getter(getter(StreamingDistributionConfig::comment))
            .setter(setter(Builder::comment))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Comment")
                    .unmarshallLocationName("Comment").build()).build();

    private static final SdkField<StreamingLoggingConfig> LOGGING_FIELD = SdkField
            .<StreamingLoggingConfig> builder(MarshallingType.SDK_POJO)
            .memberName("Logging")
            .getter(getter(StreamingDistributionConfig::logging))
            .setter(setter(Builder::logging))
            .constructor(StreamingLoggingConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Logging")
                    .unmarshallLocationName("Logging").build()).build();

    private static final SdkField<TrustedSigners> TRUSTED_SIGNERS_FIELD = SdkField
            .<TrustedSigners> builder(MarshallingType.SDK_POJO)
            .memberName("TrustedSigners")
            .getter(getter(StreamingDistributionConfig::trustedSigners))
            .setter(setter(Builder::trustedSigners))
            .constructor(TrustedSigners::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrustedSigners")
                    .unmarshallLocationName("TrustedSigners").build()).build();

    private static final SdkField<String> PRICE_CLASS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("PriceClass")
            .getter(getter(StreamingDistributionConfig::priceClassAsString))
            .setter(setter(Builder::priceClass))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PriceClass")
                    .unmarshallLocationName("PriceClass").build()).build();

    private static final SdkField<Boolean> ENABLED_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("Enabled")
            .getter(getter(StreamingDistributionConfig::enabled))
            .setter(setter(Builder::enabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Enabled")
                    .unmarshallLocationName("Enabled").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(CALLER_REFERENCE_FIELD, S3_ORIGIN_FIELD, ALIASES_FIELD, COMMENT_FIELD, LOGGING_FIELD, TRUSTED_SIGNERS_FIELD,
                    PRICE_CLASS_FIELD, ENABLED_FIELD));

    private static final long serialVersionUID = 1L;

    private final String callerReference;

    private final S3Origin s3Origin;

    private final Aliases aliases;

    private final String comment;

    private final StreamingLoggingConfig logging;

    private final TrustedSigners trustedSigners;

    private final String priceClass;

    private final Boolean enabled;

    private StreamingDistributionConfig(BuilderImpl builder) {
        this.callerReference = builder.callerReference;
        this.s3Origin = builder.s3Origin;
        this.aliases = builder.aliases;
        this.comment = builder.comment;
        this.logging = builder.logging;
        this.trustedSigners = builder.trustedSigners;
        this.priceClass = builder.priceClass;
        this.enabled = builder.enabled;
    }

    /**
     * <p>
     * A unique value (for example, a date-time stamp) that ensures that the request can't be replayed.
     * </p>
     * <p>
     * If the value of <code>CallerReference</code> is new (regardless of the content of the
     * <code>StreamingDistributionConfig</code> object), CloudFront creates a new distribution.
     * </p>
     * <p>
     * If <code>CallerReference</code> is a value that you already sent in a previous request to create a distribution,
     * CloudFront returns a <code>DistributionAlreadyExists</code> error.
     * </p>
     * 
     * @return A unique value (for example, a date-time stamp) that ensures that the request can't be replayed.</p>
     *         <p>
     *         If the value of <code>CallerReference</code> is new (regardless of the content of the
     *         <code>StreamingDistributionConfig</code> object), CloudFront creates a new distribution.
     *         </p>
     *         <p>
     *         If <code>CallerReference</code> is a value that you already sent in a previous request to create a
     *         distribution, CloudFront returns a <code>DistributionAlreadyExists</code> error.
     */
    public final String callerReference() {
        return callerReference;
    }

    /**
     * <p>
     * A complex type that contains information about the Amazon S3 bucket from which you want CloudFront to get your
     * media files for distribution.
     * </p>
     * 
     * @return A complex type that contains information about the Amazon S3 bucket from which you want CloudFront to get
     *         your media files for distribution.
     */
    public final S3Origin s3Origin() {
        return s3Origin;
    }

    /**
     * <p>
     * A complex type that contains information about CNAMEs (alternate domain names), if any, for this streaming
     * distribution.
     * </p>
     * 
     * @return A complex type that contains information about CNAMEs (alternate domain names), if any, for this
     *         streaming distribution.
     */
    public final Aliases aliases() {
        return aliases;
    }

    /**
     * <p>
     * Any comments you want to include about the streaming distribution.
     * </p>
     * 
     * @return Any comments you want to include about the streaming distribution.
     */
    public final String comment() {
        return comment;
    }

    /**
     * <p>
     * A complex type that controls whether access logs are written for the streaming distribution.
     * </p>
     * 
     * @return A complex type that controls whether access logs are written for the streaming distribution.
     */
    public final StreamingLoggingConfig logging() {
        return logging;
    }

    /**
     * <p>
     * A complex type that specifies any AWS accounts that you want to permit to create signed URLs for private content.
     * If you want the distribution to use signed URLs, include this element; if you want the distribution to use public
     * URLs, remove this element. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html">Serving Private
     * Content through CloudFront</a> in the <i>Amazon CloudFront Developer Guide</i>.
     * </p>
     * 
     * @return A complex type that specifies any AWS accounts that you want to permit to create signed URLs for private
     *         content. If you want the distribution to use signed URLs, include this element; if you want the
     *         distribution to use public URLs, remove this element. For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html">Serving
     *         Private Content through CloudFront</a> in the <i>Amazon CloudFront Developer Guide</i>.
     */
    public final TrustedSigners trustedSigners() {
        return trustedSigners;
    }

    /**
     * <p>
     * A complex type that contains information about price class for this streaming distribution.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #priceClass} will
     * return {@link PriceClass#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #priceClassAsString}.
     * </p>
     * 
     * @return A complex type that contains information about price class for this streaming distribution.
     * @see PriceClass
     */
    public final PriceClass priceClass() {
        return PriceClass.fromValue(priceClass);
    }

    /**
     * <p>
     * A complex type that contains information about price class for this streaming distribution.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #priceClass} will
     * return {@link PriceClass#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #priceClassAsString}.
     * </p>
     * 
     * @return A complex type that contains information about price class for this streaming distribution.
     * @see PriceClass
     */
    public final String priceClassAsString() {
        return priceClass;
    }

    /**
     * <p>
     * Whether the streaming distribution is enabled to accept user requests for content.
     * </p>
     * 
     * @return Whether the streaming distribution is enabled to accept user requests for content.
     */
    public final Boolean enabled() {
        return enabled;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(callerReference());
        hashCode = 31 * hashCode + Objects.hashCode(s3Origin());
        hashCode = 31 * hashCode + Objects.hashCode(aliases());
        hashCode = 31 * hashCode + Objects.hashCode(comment());
        hashCode = 31 * hashCode + Objects.hashCode(logging());
        hashCode = 31 * hashCode + Objects.hashCode(trustedSigners());
        hashCode = 31 * hashCode + Objects.hashCode(priceClassAsString());
        hashCode = 31 * hashCode + Objects.hashCode(enabled());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StreamingDistributionConfig)) {
            return false;
        }
        StreamingDistributionConfig other = (StreamingDistributionConfig) obj;
        return Objects.equals(callerReference(), other.callerReference()) && Objects.equals(s3Origin(), other.s3Origin())
                && Objects.equals(aliases(), other.aliases()) && Objects.equals(comment(), other.comment())
                && Objects.equals(logging(), other.logging()) && Objects.equals(trustedSigners(), other.trustedSigners())
                && Objects.equals(priceClassAsString(), other.priceClassAsString()) && Objects.equals(enabled(), other.enabled());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StreamingDistributionConfig").add("CallerReference", callerReference())
                .add("S3Origin", s3Origin()).add("Aliases", aliases()).add("Comment", comment()).add("Logging", logging())
                .add("TrustedSigners", trustedSigners()).add("PriceClass", priceClassAsString()).add("Enabled", enabled())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CallerReference":
            return Optional.ofNullable(clazz.cast(callerReference()));
        case "S3Origin":
            return Optional.ofNullable(clazz.cast(s3Origin()));
        case "Aliases":
            return Optional.ofNullable(clazz.cast(aliases()));
        case "Comment":
            return Optional.ofNullable(clazz.cast(comment()));
        case "Logging":
            return Optional.ofNullable(clazz.cast(logging()));
        case "TrustedSigners":
            return Optional.ofNullable(clazz.cast(trustedSigners()));
        case "PriceClass":
            return Optional.ofNullable(clazz.cast(priceClassAsString()));
        case "Enabled":
            return Optional.ofNullable(clazz.cast(enabled()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StreamingDistributionConfig, T> g) {
        return obj -> g.apply((StreamingDistributionConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, StreamingDistributionConfig> {
        /**
         * <p>
         * A unique value (for example, a date-time stamp) that ensures that the request can't be replayed.
         * </p>
         * <p>
         * If the value of <code>CallerReference</code> is new (regardless of the content of the
         * <code>StreamingDistributionConfig</code> object), CloudFront creates a new distribution.
         * </p>
         * <p>
         * If <code>CallerReference</code> is a value that you already sent in a previous request to create a
         * distribution, CloudFront returns a <code>DistributionAlreadyExists</code> error.
         * </p>
         * 
         * @param callerReference
         *        A unique value (for example, a date-time stamp) that ensures that the request can't be replayed.</p>
         *        <p>
         *        If the value of <code>CallerReference</code> is new (regardless of the content of the
         *        <code>StreamingDistributionConfig</code> object), CloudFront creates a new distribution.
         *        </p>
         *        <p>
         *        If <code>CallerReference</code> is a value that you already sent in a previous request to create a
         *        distribution, CloudFront returns a <code>DistributionAlreadyExists</code> error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder callerReference(String callerReference);

        /**
         * <p>
         * A complex type that contains information about the Amazon S3 bucket from which you want CloudFront to get
         * your media files for distribution.
         * </p>
         * 
         * @param s3Origin
         *        A complex type that contains information about the Amazon S3 bucket from which you want CloudFront to
         *        get your media files for distribution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3Origin(S3Origin s3Origin);

        /**
         * <p>
         * A complex type that contains information about the Amazon S3 bucket from which you want CloudFront to get
         * your media files for distribution.
         * </p>
         * This is a convenience that creates an instance of the {@link S3Origin.Builder} avoiding the need to create
         * one manually via {@link S3Origin#builder()}.
         *
         * When the {@link Consumer} completes, {@link S3Origin.Builder#build()} is called immediately and its result is
         * passed to {@link #s3Origin(S3Origin)}.
         * 
         * @param s3Origin
         *        a consumer that will call methods on {@link S3Origin.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #s3Origin(S3Origin)
         */
        default Builder s3Origin(Consumer<S3Origin.Builder> s3Origin) {
            return s3Origin(S3Origin.builder().applyMutation(s3Origin).build());
        }

        /**
         * <p>
         * A complex type that contains information about CNAMEs (alternate domain names), if any, for this streaming
         * distribution.
         * </p>
         * 
         * @param aliases
         *        A complex type that contains information about CNAMEs (alternate domain names), if any, for this
         *        streaming distribution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder aliases(Aliases aliases);

        /**
         * <p>
         * A complex type that contains information about CNAMEs (alternate domain names), if any, for this streaming
         * distribution.
         * </p>
         * This is a convenience that creates an instance of the {@link Aliases.Builder} avoiding the need to create one
         * manually via {@link Aliases#builder()}.
         *
         * When the {@link Consumer} completes, {@link Aliases.Builder#build()} is called immediately and its result is
         * passed to {@link #aliases(Aliases)}.
         * 
         * @param aliases
         *        a consumer that will call methods on {@link Aliases.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #aliases(Aliases)
         */
        default Builder aliases(Consumer<Aliases.Builder> aliases) {
            return aliases(Aliases.builder().applyMutation(aliases).build());
        }

        /**
         * <p>
         * Any comments you want to include about the streaming distribution.
         * </p>
         * 
         * @param comment
         *        Any comments you want to include about the streaming distribution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder comment(String comment);

        /**
         * <p>
         * A complex type that controls whether access logs are written for the streaming distribution.
         * </p>
         * 
         * @param logging
         *        A complex type that controls whether access logs are written for the streaming distribution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logging(StreamingLoggingConfig logging);

        /**
         * <p>
         * A complex type that controls whether access logs are written for the streaming distribution.
         * </p>
         * This is a convenience that creates an instance of the {@link StreamingLoggingConfig.Builder} avoiding the
         * need to create one manually via {@link StreamingLoggingConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link StreamingLoggingConfig.Builder#build()} is called immediately and
         * its result is passed to {@link #logging(StreamingLoggingConfig)}.
         * 
         * @param logging
         *        a consumer that will call methods on {@link StreamingLoggingConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #logging(StreamingLoggingConfig)
         */
        default Builder logging(Consumer<StreamingLoggingConfig.Builder> logging) {
            return logging(StreamingLoggingConfig.builder().applyMutation(logging).build());
        }

        /**
         * <p>
         * A complex type that specifies any AWS accounts that you want to permit to create signed URLs for private
         * content. If you want the distribution to use signed URLs, include this element; if you want the distribution
         * to use public URLs, remove this element. For more information, see <a
         * href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html">Serving Private
         * Content through CloudFront</a> in the <i>Amazon CloudFront Developer Guide</i>.
         * </p>
         * 
         * @param trustedSigners
         *        A complex type that specifies any AWS accounts that you want to permit to create signed URLs for
         *        private content. If you want the distribution to use signed URLs, include this element; if you want
         *        the distribution to use public URLs, remove this element. For more information, see <a
         *        href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html">Serving
         *        Private Content through CloudFront</a> in the <i>Amazon CloudFront Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trustedSigners(TrustedSigners trustedSigners);

        /**
         * <p>
         * A complex type that specifies any AWS accounts that you want to permit to create signed URLs for private
         * content. If you want the distribution to use signed URLs, include this element; if you want the distribution
         * to use public URLs, remove this element. For more information, see <a
         * href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html">Serving Private
         * Content through CloudFront</a> in the <i>Amazon CloudFront Developer Guide</i>.
         * </p>
         * This is a convenience that creates an instance of the {@link TrustedSigners.Builder} avoiding the need to
         * create one manually via {@link TrustedSigners#builder()}.
         *
         * When the {@link Consumer} completes, {@link TrustedSigners.Builder#build()} is called immediately and its
         * result is passed to {@link #trustedSigners(TrustedSigners)}.
         * 
         * @param trustedSigners
         *        a consumer that will call methods on {@link TrustedSigners.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #trustedSigners(TrustedSigners)
         */
        default Builder trustedSigners(Consumer<TrustedSigners.Builder> trustedSigners) {
            return trustedSigners(TrustedSigners.builder().applyMutation(trustedSigners).build());
        }

        /**
         * <p>
         * A complex type that contains information about price class for this streaming distribution.
         * </p>
         * 
         * @param priceClass
         *        A complex type that contains information about price class for this streaming distribution.
         * @see PriceClass
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PriceClass
         */
        Builder priceClass(String priceClass);

        /**
         * <p>
         * A complex type that contains information about price class for this streaming distribution.
         * </p>
         * 
         * @param priceClass
         *        A complex type that contains information about price class for this streaming distribution.
         * @see PriceClass
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PriceClass
         */
        Builder priceClass(PriceClass priceClass);

        /**
         * <p>
         * Whether the streaming distribution is enabled to accept user requests for content.
         * </p>
         * 
         * @param enabled
         *        Whether the streaming distribution is enabled to accept user requests for content.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enabled(Boolean enabled);
    }

    static final class BuilderImpl implements Builder {
        private String callerReference;

        private S3Origin s3Origin;

        private Aliases aliases;

        private String comment;

        private StreamingLoggingConfig logging;

        private TrustedSigners trustedSigners;

        private String priceClass;

        private Boolean enabled;

        private BuilderImpl() {
        }

        private BuilderImpl(StreamingDistributionConfig model) {
            callerReference(model.callerReference);
            s3Origin(model.s3Origin);
            aliases(model.aliases);
            comment(model.comment);
            logging(model.logging);
            trustedSigners(model.trustedSigners);
            priceClass(model.priceClass);
            enabled(model.enabled);
        }

        public final String getCallerReference() {
            return callerReference;
        }

        @Override
        public final Builder callerReference(String callerReference) {
            this.callerReference = callerReference;
            return this;
        }

        public final void setCallerReference(String callerReference) {
            this.callerReference = callerReference;
        }

        public final S3Origin.Builder getS3Origin() {
            return s3Origin != null ? s3Origin.toBuilder() : null;
        }

        @Override
        public final Builder s3Origin(S3Origin s3Origin) {
            this.s3Origin = s3Origin;
            return this;
        }

        public final void setS3Origin(S3Origin.BuilderImpl s3Origin) {
            this.s3Origin = s3Origin != null ? s3Origin.build() : null;
        }

        public final Aliases.Builder getAliases() {
            return aliases != null ? aliases.toBuilder() : null;
        }

        @Override
        public final Builder aliases(Aliases aliases) {
            this.aliases = aliases;
            return this;
        }

        public final void setAliases(Aliases.BuilderImpl aliases) {
            this.aliases = aliases != null ? aliases.build() : null;
        }

        public final String getComment() {
            return comment;
        }

        @Override
        public final Builder comment(String comment) {
            this.comment = comment;
            return this;
        }

        public final void setComment(String comment) {
            this.comment = comment;
        }

        public final StreamingLoggingConfig.Builder getLogging() {
            return logging != null ? logging.toBuilder() : null;
        }

        @Override
        public final Builder logging(StreamingLoggingConfig logging) {
            this.logging = logging;
            return this;
        }

        public final void setLogging(StreamingLoggingConfig.BuilderImpl logging) {
            this.logging = logging != null ? logging.build() : null;
        }

        public final TrustedSigners.Builder getTrustedSigners() {
            return trustedSigners != null ? trustedSigners.toBuilder() : null;
        }

        @Override
        public final Builder trustedSigners(TrustedSigners trustedSigners) {
            this.trustedSigners = trustedSigners;
            return this;
        }

        public final void setTrustedSigners(TrustedSigners.BuilderImpl trustedSigners) {
            this.trustedSigners = trustedSigners != null ? trustedSigners.build() : null;
        }

        public final String getPriceClass() {
            return priceClass;
        }

        @Override
        public final Builder priceClass(String priceClass) {
            this.priceClass = priceClass;
            return this;
        }

        @Override
        public final Builder priceClass(PriceClass priceClass) {
            this.priceClass(priceClass == null ? null : priceClass.toString());
            return this;
        }

        public final void setPriceClass(String priceClass) {
            this.priceClass = priceClass;
        }

        public final Boolean getEnabled() {
            return enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        @Override
        public StreamingDistributionConfig build() {
            return new StreamingDistributionConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
