/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfront.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Query argument-profile mapping for field-level encryption.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class QueryArgProfile implements SdkPojo, Serializable, ToCopyableBuilder<QueryArgProfile.Builder, QueryArgProfile> {
    private static final SdkField<String> QUERY_ARG_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("QueryArg")
            .getter(getter(QueryArgProfile::queryArg))
            .setter(setter(Builder::queryArg))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueryArg")
                    .unmarshallLocationName("QueryArg").build()).build();

    private static final SdkField<String> PROFILE_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ProfileId")
            .getter(getter(QueryArgProfile::profileId))
            .setter(setter(Builder::profileId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProfileId")
                    .unmarshallLocationName("ProfileId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(QUERY_ARG_FIELD,
            PROFILE_ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final String queryArg;

    private final String profileId;

    private QueryArgProfile(BuilderImpl builder) {
        this.queryArg = builder.queryArg;
        this.profileId = builder.profileId;
    }

    /**
     * <p>
     * Query argument for field-level encryption query argument-profile mapping.
     * </p>
     * 
     * @return Query argument for field-level encryption query argument-profile mapping.
     */
    public final String queryArg() {
        return queryArg;
    }

    /**
     * <p>
     * ID of profile to use for field-level encryption query argument-profile mapping
     * </p>
     * 
     * @return ID of profile to use for field-level encryption query argument-profile mapping
     */
    public final String profileId() {
        return profileId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(queryArg());
        hashCode = 31 * hashCode + Objects.hashCode(profileId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof QueryArgProfile)) {
            return false;
        }
        QueryArgProfile other = (QueryArgProfile) obj;
        return Objects.equals(queryArg(), other.queryArg()) && Objects.equals(profileId(), other.profileId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("QueryArgProfile").add("QueryArg", queryArg()).add("ProfileId", profileId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "QueryArg":
            return Optional.ofNullable(clazz.cast(queryArg()));
        case "ProfileId":
            return Optional.ofNullable(clazz.cast(profileId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<QueryArgProfile, T> g) {
        return obj -> g.apply((QueryArgProfile) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, QueryArgProfile> {
        /**
         * <p>
         * Query argument for field-level encryption query argument-profile mapping.
         * </p>
         * 
         * @param queryArg
         *        Query argument for field-level encryption query argument-profile mapping.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queryArg(String queryArg);

        /**
         * <p>
         * ID of profile to use for field-level encryption query argument-profile mapping
         * </p>
         * 
         * @param profileId
         *        ID of profile to use for field-level encryption query argument-profile mapping
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder profileId(String profileId);
    }

    static final class BuilderImpl implements Builder {
        private String queryArg;

        private String profileId;

        private BuilderImpl() {
        }

        private BuilderImpl(QueryArgProfile model) {
            queryArg(model.queryArg);
            profileId(model.profileId);
        }

        public final String getQueryArg() {
            return queryArg;
        }

        @Override
        public final Builder queryArg(String queryArg) {
            this.queryArg = queryArg;
            return this;
        }

        public final void setQueryArg(String queryArg) {
            this.queryArg = queryArg;
        }

        public final String getProfileId() {
            return profileId;
        }

        @Override
        public final Builder profileId(String profileId) {
            this.profileId = profileId;
            return this;
        }

        public final void setProfileId(String profileId) {
            this.profileId = profileId;
        }

        @Override
        public QueryArgProfile build() {
            return new QueryArgProfile(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
