/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfront.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The <code>InvalidationList</code> complex type describes the list of invalidation objects. For more information about
 * invalidation, see <a
 * href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Invalidation.html">Invalidating Objects (Web
 * Distributions Only)</a> in the <i>Amazon CloudFront Developer Guide</i>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class InvalidationList implements SdkPojo, Serializable,
        ToCopyableBuilder<InvalidationList.Builder, InvalidationList> {
    private static final SdkField<String> MARKER_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Marker")
            .getter(getter(InvalidationList::marker))
            .setter(setter(Builder::marker))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker")
                    .unmarshallLocationName("Marker").build()).build();

    private static final SdkField<String> NEXT_MARKER_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("NextMarker")
            .getter(getter(InvalidationList::nextMarker))
            .setter(setter(Builder::nextMarker))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextMarker")
                    .unmarshallLocationName("NextMarker").build()).build();

    private static final SdkField<Integer> MAX_ITEMS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxItems")
            .getter(getter(InvalidationList::maxItems))
            .setter(setter(Builder::maxItems))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxItems")
                    .unmarshallLocationName("MaxItems").build()).build();

    private static final SdkField<Boolean> IS_TRUNCATED_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("IsTruncated")
            .getter(getter(InvalidationList::isTruncated))
            .setter(setter(Builder::isTruncated))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsTruncated")
                    .unmarshallLocationName("IsTruncated").build()).build();

    private static final SdkField<Integer> QUANTITY_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("Quantity")
            .getter(getter(InvalidationList::quantity))
            .setter(setter(Builder::quantity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Quantity")
                    .unmarshallLocationName("Quantity").build()).build();

    private static final SdkField<List<InvalidationSummary>> ITEMS_FIELD = SdkField
            .<List<InvalidationSummary>> builder(MarshallingType.LIST)
            .memberName("Items")
            .getter(getter(InvalidationList::items))
            .setter(setter(Builder::items))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Items")
                    .unmarshallLocationName("Items").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("InvalidationSummary")
                            .memberFieldInfo(
                                    SdkField.<InvalidationSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(InvalidationSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("InvalidationSummary")
                                                    .unmarshallLocationName("InvalidationSummary").build()).build()).build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MARKER_FIELD,
            NEXT_MARKER_FIELD, MAX_ITEMS_FIELD, IS_TRUNCATED_FIELD, QUANTITY_FIELD, ITEMS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String marker;

    private final String nextMarker;

    private final Integer maxItems;

    private final Boolean isTruncated;

    private final Integer quantity;

    private final List<InvalidationSummary> items;

    private InvalidationList(BuilderImpl builder) {
        this.marker = builder.marker;
        this.nextMarker = builder.nextMarker;
        this.maxItems = builder.maxItems;
        this.isTruncated = builder.isTruncated;
        this.quantity = builder.quantity;
        this.items = builder.items;
    }

    /**
     * <p>
     * The value that you provided for the <code>Marker</code> request parameter.
     * </p>
     * 
     * @return The value that you provided for the <code>Marker</code> request parameter.
     */
    public final String marker() {
        return marker;
    }

    /**
     * <p>
     * If <code>IsTruncated</code> is <code>true</code>, this element is present and contains the value that you can use
     * for the <code>Marker</code> request parameter to continue listing your invalidation batches where they left off.
     * </p>
     * 
     * @return If <code>IsTruncated</code> is <code>true</code>, this element is present and contains the value that you
     *         can use for the <code>Marker</code> request parameter to continue listing your invalidation batches where
     *         they left off.
     */
    public final String nextMarker() {
        return nextMarker;
    }

    /**
     * <p>
     * The value that you provided for the <code>MaxItems</code> request parameter.
     * </p>
     * 
     * @return The value that you provided for the <code>MaxItems</code> request parameter.
     */
    public final Integer maxItems() {
        return maxItems;
    }

    /**
     * <p>
     * A flag that indicates whether more invalidation batch requests remain to be listed. If your results were
     * truncated, you can make a follow-up pagination request using the <code>Marker</code> request parameter to
     * retrieve more invalidation batches in the list.
     * </p>
     * 
     * @return A flag that indicates whether more invalidation batch requests remain to be listed. If your results were
     *         truncated, you can make a follow-up pagination request using the <code>Marker</code> request parameter to
     *         retrieve more invalidation batches in the list.
     */
    public final Boolean isTruncated() {
        return isTruncated;
    }

    /**
     * <p>
     * The number of invalidation batches that were created by the current AWS account.
     * </p>
     * 
     * @return The number of invalidation batches that were created by the current AWS account.
     */
    public final Integer quantity() {
        return quantity;
    }

    /**
     * Returns true if the Items property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasItems() {
        return items != null && !(items instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A complex type that contains one <code>InvalidationSummary</code> element for each invalidation batch created by
     * the current AWS account.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasItems()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A complex type that contains one <code>InvalidationSummary</code> element for each invalidation batch
     *         created by the current AWS account.
     */
    public final List<InvalidationSummary> items() {
        return items;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(marker());
        hashCode = 31 * hashCode + Objects.hashCode(nextMarker());
        hashCode = 31 * hashCode + Objects.hashCode(maxItems());
        hashCode = 31 * hashCode + Objects.hashCode(isTruncated());
        hashCode = 31 * hashCode + Objects.hashCode(quantity());
        hashCode = 31 * hashCode + Objects.hashCode(hasItems() ? items() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InvalidationList)) {
            return false;
        }
        InvalidationList other = (InvalidationList) obj;
        return Objects.equals(marker(), other.marker()) && Objects.equals(nextMarker(), other.nextMarker())
                && Objects.equals(maxItems(), other.maxItems()) && Objects.equals(isTruncated(), other.isTruncated())
                && Objects.equals(quantity(), other.quantity()) && hasItems() == other.hasItems()
                && Objects.equals(items(), other.items());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("InvalidationList").add("Marker", marker()).add("NextMarker", nextMarker())
                .add("MaxItems", maxItems()).add("IsTruncated", isTruncated()).add("Quantity", quantity())
                .add("Items", hasItems() ? items() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Marker":
            return Optional.ofNullable(clazz.cast(marker()));
        case "NextMarker":
            return Optional.ofNullable(clazz.cast(nextMarker()));
        case "MaxItems":
            return Optional.ofNullable(clazz.cast(maxItems()));
        case "IsTruncated":
            return Optional.ofNullable(clazz.cast(isTruncated()));
        case "Quantity":
            return Optional.ofNullable(clazz.cast(quantity()));
        case "Items":
            return Optional.ofNullable(clazz.cast(items()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<InvalidationList, T> g) {
        return obj -> g.apply((InvalidationList) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InvalidationList> {
        /**
         * <p>
         * The value that you provided for the <code>Marker</code> request parameter.
         * </p>
         * 
         * @param marker
         *        The value that you provided for the <code>Marker</code> request parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder marker(String marker);

        /**
         * <p>
         * If <code>IsTruncated</code> is <code>true</code>, this element is present and contains the value that you can
         * use for the <code>Marker</code> request parameter to continue listing your invalidation batches where they
         * left off.
         * </p>
         * 
         * @param nextMarker
         *        If <code>IsTruncated</code> is <code>true</code>, this element is present and contains the value that
         *        you can use for the <code>Marker</code> request parameter to continue listing your invalidation
         *        batches where they left off.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextMarker(String nextMarker);

        /**
         * <p>
         * The value that you provided for the <code>MaxItems</code> request parameter.
         * </p>
         * 
         * @param maxItems
         *        The value that you provided for the <code>MaxItems</code> request parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxItems(Integer maxItems);

        /**
         * <p>
         * A flag that indicates whether more invalidation batch requests remain to be listed. If your results were
         * truncated, you can make a follow-up pagination request using the <code>Marker</code> request parameter to
         * retrieve more invalidation batches in the list.
         * </p>
         * 
         * @param isTruncated
         *        A flag that indicates whether more invalidation batch requests remain to be listed. If your results
         *        were truncated, you can make a follow-up pagination request using the <code>Marker</code> request
         *        parameter to retrieve more invalidation batches in the list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isTruncated(Boolean isTruncated);

        /**
         * <p>
         * The number of invalidation batches that were created by the current AWS account.
         * </p>
         * 
         * @param quantity
         *        The number of invalidation batches that were created by the current AWS account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder quantity(Integer quantity);

        /**
         * <p>
         * A complex type that contains one <code>InvalidationSummary</code> element for each invalidation batch created
         * by the current AWS account.
         * </p>
         * 
         * @param items
         *        A complex type that contains one <code>InvalidationSummary</code> element for each invalidation batch
         *        created by the current AWS account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder items(Collection<InvalidationSummary> items);

        /**
         * <p>
         * A complex type that contains one <code>InvalidationSummary</code> element for each invalidation batch created
         * by the current AWS account.
         * </p>
         * 
         * @param items
         *        A complex type that contains one <code>InvalidationSummary</code> element for each invalidation batch
         *        created by the current AWS account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder items(InvalidationSummary... items);

        /**
         * <p>
         * A complex type that contains one <code>InvalidationSummary</code> element for each invalidation batch created
         * by the current AWS account.
         * </p>
         * This is a convenience that creates an instance of the {@link List<InvalidationSummary>.Builder} avoiding the
         * need to create one manually via {@link List<InvalidationSummary>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<InvalidationSummary>.Builder#build()} is called immediately
         * and its result is passed to {@link #items(List<InvalidationSummary>)}.
         * 
         * @param items
         *        a consumer that will call methods on {@link List<InvalidationSummary>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #items(List<InvalidationSummary>)
         */
        Builder items(Consumer<InvalidationSummary.Builder>... items);
    }

    static final class BuilderImpl implements Builder {
        private String marker;

        private String nextMarker;

        private Integer maxItems;

        private Boolean isTruncated;

        private Integer quantity;

        private List<InvalidationSummary> items = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(InvalidationList model) {
            marker(model.marker);
            nextMarker(model.nextMarker);
            maxItems(model.maxItems);
            isTruncated(model.isTruncated);
            quantity(model.quantity);
            items(model.items);
        }

        public final String getMarker() {
            return marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public final String getNextMarker() {
            return nextMarker;
        }

        @Override
        public final Builder nextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
            return this;
        }

        public final void setNextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
        }

        public final Integer getMaxItems() {
            return maxItems;
        }

        @Override
        public final Builder maxItems(Integer maxItems) {
            this.maxItems = maxItems;
            return this;
        }

        public final void setMaxItems(Integer maxItems) {
            this.maxItems = maxItems;
        }

        public final Boolean getIsTruncated() {
            return isTruncated;
        }

        @Override
        public final Builder isTruncated(Boolean isTruncated) {
            this.isTruncated = isTruncated;
            return this;
        }

        public final void setIsTruncated(Boolean isTruncated) {
            this.isTruncated = isTruncated;
        }

        public final Integer getQuantity() {
            return quantity;
        }

        @Override
        public final Builder quantity(Integer quantity) {
            this.quantity = quantity;
            return this;
        }

        public final void setQuantity(Integer quantity) {
            this.quantity = quantity;
        }

        public final Collection<InvalidationSummary.Builder> getItems() {
            if (items instanceof SdkAutoConstructList) {
                return null;
            }
            return items != null ? items.stream().map(InvalidationSummary::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder items(Collection<InvalidationSummary> items) {
            this.items = InvalidationSummaryListCopier.copy(items);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder items(InvalidationSummary... items) {
            items(Arrays.asList(items));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder items(Consumer<InvalidationSummary.Builder>... items) {
            items(Stream.of(items).map(c -> InvalidationSummary.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setItems(Collection<InvalidationSummary.BuilderImpl> items) {
            this.items = InvalidationSummaryListCopier.copyFromBuilder(items);
        }

        @Override
        public InvalidationList build() {
            return new InvalidationList(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
