/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfront.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * This field is deprecated. We recommend that you use a cache policy or an origin request policy instead of this field.
 * </p>
 * <p>
 * If you want to include values in the cache key, use a cache policy. For more information, see <a href=
 * "https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy"
 * >Creating cache policies</a> in the <i>Amazon CloudFront Developer Guide</i>.
 * </p>
 * <p>
 * If you want to send values to the origin but not include them in the cache key, use an origin request policy. For
 * more information, see <a href=
 * "https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-origin-requests.html#origin-request-create-origin-request-policy"
 * >Creating origin request policies</a> in the <i>Amazon CloudFront Developer Guide</i>.
 * </p>
 * <p>
 * A complex type that specifies how CloudFront handles query strings, cookies, and HTTP headers.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ForwardedValues implements SdkPojo, Serializable, ToCopyableBuilder<ForwardedValues.Builder, ForwardedValues> {
    private static final SdkField<Boolean> QUERY_STRING_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("QueryString")
            .getter(getter(ForwardedValues::queryString))
            .setter(setter(Builder::queryString))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueryString")
                    .unmarshallLocationName("QueryString").build()).build();

    private static final SdkField<CookiePreference> COOKIES_FIELD = SdkField
            .<CookiePreference> builder(MarshallingType.SDK_POJO)
            .memberName("Cookies")
            .getter(getter(ForwardedValues::cookies))
            .setter(setter(Builder::cookies))
            .constructor(CookiePreference::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Cookies")
                    .unmarshallLocationName("Cookies").build()).build();

    private static final SdkField<Headers> HEADERS_FIELD = SdkField
            .<Headers> builder(MarshallingType.SDK_POJO)
            .memberName("Headers")
            .getter(getter(ForwardedValues::headers))
            .setter(setter(Builder::headers))
            .constructor(Headers::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Headers")
                    .unmarshallLocationName("Headers").build()).build();

    private static final SdkField<QueryStringCacheKeys> QUERY_STRING_CACHE_KEYS_FIELD = SdkField
            .<QueryStringCacheKeys> builder(MarshallingType.SDK_POJO)
            .memberName("QueryStringCacheKeys")
            .getter(getter(ForwardedValues::queryStringCacheKeys))
            .setter(setter(Builder::queryStringCacheKeys))
            .constructor(QueryStringCacheKeys::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueryStringCacheKeys")
                    .unmarshallLocationName("QueryStringCacheKeys").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(QUERY_STRING_FIELD,
            COOKIES_FIELD, HEADERS_FIELD, QUERY_STRING_CACHE_KEYS_FIELD));

    private static final long serialVersionUID = 1L;

    private final Boolean queryString;

    private final CookiePreference cookies;

    private final Headers headers;

    private final QueryStringCacheKeys queryStringCacheKeys;

    private ForwardedValues(BuilderImpl builder) {
        this.queryString = builder.queryString;
        this.cookies = builder.cookies;
        this.headers = builder.headers;
        this.queryStringCacheKeys = builder.queryStringCacheKeys;
    }

    /**
     * <p>
     * This field is deprecated. We recommend that you use a cache policy or an origin request policy instead of this
     * field.
     * </p>
     * <p>
     * If you want to include query strings in the cache key, use a cache policy. For more information, see <a href=
     * "https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy"
     * >Creating cache policies</a> in the <i>Amazon CloudFront Developer Guide</i>.
     * </p>
     * <p>
     * If you want to send query strings to the origin but not include them in the cache key, use an origin request
     * policy. For more information, see <a href=
     * "https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-origin-requests.html#origin-request-create-origin-request-policy"
     * >Creating origin request policies</a> in the <i>Amazon CloudFront Developer Guide</i>.
     * </p>
     * <p>
     * Indicates whether you want CloudFront to forward query strings to the origin that is associated with this cache
     * behavior and cache based on the query string parameters. CloudFront behavior depends on the value of
     * <code>QueryString</code> and on the values that you specify for <code>QueryStringCacheKeys</code>, if any:
     * </p>
     * <p>
     * If you specify true for <code>QueryString</code> and you don't specify any values for
     * <code>QueryStringCacheKeys</code>, CloudFront forwards all query string parameters to the origin and caches based
     * on all query string parameters. Depending on how many query string parameters and values you have, this can
     * adversely affect performance because CloudFront must forward more requests to the origin.
     * </p>
     * <p>
     * If you specify true for <code>QueryString</code> and you specify one or more values for
     * <code>QueryStringCacheKeys</code>, CloudFront forwards all query string parameters to the origin, but it only
     * caches based on the query string parameters that you specify.
     * </p>
     * <p>
     * If you specify false for <code>QueryString</code>, CloudFront doesn't forward any query string parameters to the
     * origin, and doesn't cache based on query string parameters.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/QueryStringParameters.html">Configuring
     * CloudFront to Cache Based on Query String Parameters</a> in the <i>Amazon CloudFront Developer Guide</i>.
     * </p>
     * 
     * @return This field is deprecated. We recommend that you use a cache policy or an origin request policy instead of
     *         this field.</p>
     *         <p>
     *         If you want to include query strings in the cache key, use a cache policy. For more information, see <a
     *         href=
     *         "https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy"
     *         >Creating cache policies</a> in the <i>Amazon CloudFront Developer Guide</i>.
     *         </p>
     *         <p>
     *         If you want to send query strings to the origin but not include them in the cache key, use an origin
     *         request policy. For more information, see <a href=
     *         "https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-origin-requests.html#origin-request-create-origin-request-policy"
     *         >Creating origin request policies</a> in the <i>Amazon CloudFront Developer Guide</i>.
     *         </p>
     *         <p>
     *         Indicates whether you want CloudFront to forward query strings to the origin that is associated with this
     *         cache behavior and cache based on the query string parameters. CloudFront behavior depends on the value
     *         of <code>QueryString</code> and on the values that you specify for <code>QueryStringCacheKeys</code>, if
     *         any:
     *         </p>
     *         <p>
     *         If you specify true for <code>QueryString</code> and you don't specify any values for
     *         <code>QueryStringCacheKeys</code>, CloudFront forwards all query string parameters to the origin and
     *         caches based on all query string parameters. Depending on how many query string parameters and values you
     *         have, this can adversely affect performance because CloudFront must forward more requests to the origin.
     *         </p>
     *         <p>
     *         If you specify true for <code>QueryString</code> and you specify one or more values for
     *         <code>QueryStringCacheKeys</code>, CloudFront forwards all query string parameters to the origin, but it
     *         only caches based on the query string parameters that you specify.
     *         </p>
     *         <p>
     *         If you specify false for <code>QueryString</code>, CloudFront doesn't forward any query string parameters
     *         to the origin, and doesn't cache based on query string parameters.
     *         </p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/QueryStringParameters.html"
     *         >Configuring CloudFront to Cache Based on Query String Parameters</a> in the <i>Amazon CloudFront
     *         Developer Guide</i>.
     */
    public final Boolean queryString() {
        return queryString;
    }

    /**
     * <p>
     * This field is deprecated. We recommend that you use a cache policy or an origin request policy instead of this
     * field.
     * </p>
     * <p>
     * If you want to include cookies in the cache key, use a cache policy. For more information, see <a href=
     * "https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy"
     * >Creating cache policies</a> in the <i>Amazon CloudFront Developer Guide</i>.
     * </p>
     * <p>
     * If you want to send cookies to the origin but not include them in the cache key, use an origin request policy.
     * For more information, see <a href=
     * "https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-origin-requests.html#origin-request-create-origin-request-policy"
     * >Creating origin request policies</a> in the <i>Amazon CloudFront Developer Guide</i>.
     * </p>
     * <p>
     * A complex type that specifies whether you want CloudFront to forward cookies to the origin and, if so, which
     * ones. For more information about forwarding cookies to the origin, see <a
     * href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Cookies.html">How CloudFront Forwards,
     * Caches, and Logs Cookies</a> in the <i>Amazon CloudFront Developer Guide</i>.
     * </p>
     * 
     * @return This field is deprecated. We recommend that you use a cache policy or an origin request policy instead of
     *         this field.</p>
     *         <p>
     *         If you want to include cookies in the cache key, use a cache policy. For more information, see <a href=
     *         "https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy"
     *         >Creating cache policies</a> in the <i>Amazon CloudFront Developer Guide</i>.
     *         </p>
     *         <p>
     *         If you want to send cookies to the origin but not include them in the cache key, use an origin request
     *         policy. For more information, see <a href=
     *         "https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-origin-requests.html#origin-request-create-origin-request-policy"
     *         >Creating origin request policies</a> in the <i>Amazon CloudFront Developer Guide</i>.
     *         </p>
     *         <p>
     *         A complex type that specifies whether you want CloudFront to forward cookies to the origin and, if so,
     *         which ones. For more information about forwarding cookies to the origin, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Cookies.html">How CloudFront
     *         Forwards, Caches, and Logs Cookies</a> in the <i>Amazon CloudFront Developer Guide</i>.
     */
    public final CookiePreference cookies() {
        return cookies;
    }

    /**
     * <p>
     * This field is deprecated. We recommend that you use a cache policy or an origin request policy instead of this
     * field.
     * </p>
     * <p>
     * If you want to include headers in the cache key, use a cache policy. For more information, see <a href=
     * "https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy"
     * >Creating cache policies</a> in the <i>Amazon CloudFront Developer Guide</i>.
     * </p>
     * <p>
     * If you want to send headers to the origin but not include them in the cache key, use an origin request policy.
     * For more information, see <a href=
     * "https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-origin-requests.html#origin-request-create-origin-request-policy"
     * >Creating origin request policies</a> in the <i>Amazon CloudFront Developer Guide</i>.
     * </p>
     * <p>
     * A complex type that specifies the <code>Headers</code>, if any, that you want CloudFront to forward to the origin
     * for this cache behavior (whitelisted headers). For the headers that you specify, CloudFront also caches separate
     * versions of a specified object that is based on the header values in viewer requests.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/header-caching.html"> Caching Content
     * Based on Request Headers</a> in the <i>Amazon CloudFront Developer Guide</i>.
     * </p>
     * 
     * @return This field is deprecated. We recommend that you use a cache policy or an origin request policy instead of
     *         this field.</p>
     *         <p>
     *         If you want to include headers in the cache key, use a cache policy. For more information, see <a href=
     *         "https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy"
     *         >Creating cache policies</a> in the <i>Amazon CloudFront Developer Guide</i>.
     *         </p>
     *         <p>
     *         If you want to send headers to the origin but not include them in the cache key, use an origin request
     *         policy. For more information, see <a href=
     *         "https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-origin-requests.html#origin-request-create-origin-request-policy"
     *         >Creating origin request policies</a> in the <i>Amazon CloudFront Developer Guide</i>.
     *         </p>
     *         <p>
     *         A complex type that specifies the <code>Headers</code>, if any, that you want CloudFront to forward to
     *         the origin for this cache behavior (whitelisted headers). For the headers that you specify, CloudFront
     *         also caches separate versions of a specified object that is based on the header values in viewer
     *         requests.
     *         </p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/header-caching.html"> Caching
     *         Content Based on Request Headers</a> in the <i>Amazon CloudFront Developer Guide</i>.
     */
    public final Headers headers() {
        return headers;
    }

    /**
     * <p>
     * This field is deprecated. We recommend that you use a cache policy or an origin request policy instead of this
     * field.
     * </p>
     * <p>
     * If you want to include query strings in the cache key, use a cache policy. For more information, see <a href=
     * "https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy"
     * >Creating cache policies</a> in the <i>Amazon CloudFront Developer Guide</i>.
     * </p>
     * <p>
     * If you want to send query strings to the origin but not include them in the cache key, use an origin request
     * policy. For more information, see <a href=
     * "https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-origin-requests.html#origin-request-create-origin-request-policy"
     * >Creating origin request policies</a> in the <i>Amazon CloudFront Developer Guide</i>.
     * </p>
     * <p>
     * A complex type that contains information about the query string parameters that you want CloudFront to use for
     * caching for this cache behavior.
     * </p>
     * 
     * @return This field is deprecated. We recommend that you use a cache policy or an origin request policy instead of
     *         this field.</p>
     *         <p>
     *         If you want to include query strings in the cache key, use a cache policy. For more information, see <a
     *         href=
     *         "https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy"
     *         >Creating cache policies</a> in the <i>Amazon CloudFront Developer Guide</i>.
     *         </p>
     *         <p>
     *         If you want to send query strings to the origin but not include them in the cache key, use an origin
     *         request policy. For more information, see <a href=
     *         "https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-origin-requests.html#origin-request-create-origin-request-policy"
     *         >Creating origin request policies</a> in the <i>Amazon CloudFront Developer Guide</i>.
     *         </p>
     *         <p>
     *         A complex type that contains information about the query string parameters that you want CloudFront to
     *         use for caching for this cache behavior.
     */
    public final QueryStringCacheKeys queryStringCacheKeys() {
        return queryStringCacheKeys;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(queryString());
        hashCode = 31 * hashCode + Objects.hashCode(cookies());
        hashCode = 31 * hashCode + Objects.hashCode(headers());
        hashCode = 31 * hashCode + Objects.hashCode(queryStringCacheKeys());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ForwardedValues)) {
            return false;
        }
        ForwardedValues other = (ForwardedValues) obj;
        return Objects.equals(queryString(), other.queryString()) && Objects.equals(cookies(), other.cookies())
                && Objects.equals(headers(), other.headers())
                && Objects.equals(queryStringCacheKeys(), other.queryStringCacheKeys());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ForwardedValues").add("QueryString", queryString()).add("Cookies", cookies())
                .add("Headers", headers()).add("QueryStringCacheKeys", queryStringCacheKeys()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "QueryString":
            return Optional.ofNullable(clazz.cast(queryString()));
        case "Cookies":
            return Optional.ofNullable(clazz.cast(cookies()));
        case "Headers":
            return Optional.ofNullable(clazz.cast(headers()));
        case "QueryStringCacheKeys":
            return Optional.ofNullable(clazz.cast(queryStringCacheKeys()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ForwardedValues, T> g) {
        return obj -> g.apply((ForwardedValues) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ForwardedValues> {
        /**
         * <p>
         * This field is deprecated. We recommend that you use a cache policy or an origin request policy instead of
         * this field.
         * </p>
         * <p>
         * If you want to include query strings in the cache key, use a cache policy. For more information, see <a href=
         * "https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy"
         * >Creating cache policies</a> in the <i>Amazon CloudFront Developer Guide</i>.
         * </p>
         * <p>
         * If you want to send query strings to the origin but not include them in the cache key, use an origin request
         * policy. For more information, see <a href=
         * "https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-origin-requests.html#origin-request-create-origin-request-policy"
         * >Creating origin request policies</a> in the <i>Amazon CloudFront Developer Guide</i>.
         * </p>
         * <p>
         * Indicates whether you want CloudFront to forward query strings to the origin that is associated with this
         * cache behavior and cache based on the query string parameters. CloudFront behavior depends on the value of
         * <code>QueryString</code> and on the values that you specify for <code>QueryStringCacheKeys</code>, if any:
         * </p>
         * <p>
         * If you specify true for <code>QueryString</code> and you don't specify any values for
         * <code>QueryStringCacheKeys</code>, CloudFront forwards all query string parameters to the origin and caches
         * based on all query string parameters. Depending on how many query string parameters and values you have, this
         * can adversely affect performance because CloudFront must forward more requests to the origin.
         * </p>
         * <p>
         * If you specify true for <code>QueryString</code> and you specify one or more values for
         * <code>QueryStringCacheKeys</code>, CloudFront forwards all query string parameters to the origin, but it only
         * caches based on the query string parameters that you specify.
         * </p>
         * <p>
         * If you specify false for <code>QueryString</code>, CloudFront doesn't forward any query string parameters to
         * the origin, and doesn't cache based on query string parameters.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/QueryStringParameters.html"
         * >Configuring CloudFront to Cache Based on Query String Parameters</a> in the <i>Amazon CloudFront Developer
         * Guide</i>.
         * </p>
         * 
         * @param queryString
         *        This field is deprecated. We recommend that you use a cache policy or an origin request policy instead
         *        of this field.</p>
         *        <p>
         *        If you want to include query strings in the cache key, use a cache policy. For more information, see
         *        <a href=
         *        "https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy"
         *        >Creating cache policies</a> in the <i>Amazon CloudFront Developer Guide</i>.
         *        </p>
         *        <p>
         *        If you want to send query strings to the origin but not include them in the cache key, use an origin
         *        request policy. For more information, see <a href=
         *        "https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-origin-requests.html#origin-request-create-origin-request-policy"
         *        >Creating origin request policies</a> in the <i>Amazon CloudFront Developer Guide</i>.
         *        </p>
         *        <p>
         *        Indicates whether you want CloudFront to forward query strings to the origin that is associated with
         *        this cache behavior and cache based on the query string parameters. CloudFront behavior depends on the
         *        value of <code>QueryString</code> and on the values that you specify for
         *        <code>QueryStringCacheKeys</code>, if any:
         *        </p>
         *        <p>
         *        If you specify true for <code>QueryString</code> and you don't specify any values for
         *        <code>QueryStringCacheKeys</code>, CloudFront forwards all query string parameters to the origin and
         *        caches based on all query string parameters. Depending on how many query string parameters and values
         *        you have, this can adversely affect performance because CloudFront must forward more requests to the
         *        origin.
         *        </p>
         *        <p>
         *        If you specify true for <code>QueryString</code> and you specify one or more values for
         *        <code>QueryStringCacheKeys</code>, CloudFront forwards all query string parameters to the origin, but
         *        it only caches based on the query string parameters that you specify.
         *        </p>
         *        <p>
         *        If you specify false for <code>QueryString</code>, CloudFront doesn't forward any query string
         *        parameters to the origin, and doesn't cache based on query string parameters.
         *        </p>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/QueryStringParameters.html"
         *        >Configuring CloudFront to Cache Based on Query String Parameters</a> in the <i>Amazon CloudFront
         *        Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queryString(Boolean queryString);

        /**
         * <p>
         * This field is deprecated. We recommend that you use a cache policy or an origin request policy instead of
         * this field.
         * </p>
         * <p>
         * If you want to include cookies in the cache key, use a cache policy. For more information, see <a href=
         * "https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy"
         * >Creating cache policies</a> in the <i>Amazon CloudFront Developer Guide</i>.
         * </p>
         * <p>
         * If you want to send cookies to the origin but not include them in the cache key, use an origin request
         * policy. For more information, see <a href=
         * "https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-origin-requests.html#origin-request-create-origin-request-policy"
         * >Creating origin request policies</a> in the <i>Amazon CloudFront Developer Guide</i>.
         * </p>
         * <p>
         * A complex type that specifies whether you want CloudFront to forward cookies to the origin and, if so, which
         * ones. For more information about forwarding cookies to the origin, see <a
         * href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Cookies.html">How CloudFront
         * Forwards, Caches, and Logs Cookies</a> in the <i>Amazon CloudFront Developer Guide</i>.
         * </p>
         * 
         * @param cookies
         *        This field is deprecated. We recommend that you use a cache policy or an origin request policy instead
         *        of this field.</p>
         *        <p>
         *        If you want to include cookies in the cache key, use a cache policy. For more information, see <a
         *        href=
         *        "https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy"
         *        >Creating cache policies</a> in the <i>Amazon CloudFront Developer Guide</i>.
         *        </p>
         *        <p>
         *        If you want to send cookies to the origin but not include them in the cache key, use an origin request
         *        policy. For more information, see <a href=
         *        "https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-origin-requests.html#origin-request-create-origin-request-policy"
         *        >Creating origin request policies</a> in the <i>Amazon CloudFront Developer Guide</i>.
         *        </p>
         *        <p>
         *        A complex type that specifies whether you want CloudFront to forward cookies to the origin and, if so,
         *        which ones. For more information about forwarding cookies to the origin, see <a
         *        href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Cookies.html">How CloudFront
         *        Forwards, Caches, and Logs Cookies</a> in the <i>Amazon CloudFront Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cookies(CookiePreference cookies);

        /**
         * <p>
         * This field is deprecated. We recommend that you use a cache policy or an origin request policy instead of
         * this field.
         * </p>
         * <p>
         * If you want to include cookies in the cache key, use a cache policy. For more information, see <a href=
         * "https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy"
         * >Creating cache policies</a> in the <i>Amazon CloudFront Developer Guide</i>.
         * </p>
         * <p>
         * If you want to send cookies to the origin but not include them in the cache key, use an origin request
         * policy. For more information, see <a href=
         * "https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-origin-requests.html#origin-request-create-origin-request-policy"
         * >Creating origin request policies</a> in the <i>Amazon CloudFront Developer Guide</i>.
         * </p>
         * <p>
         * A complex type that specifies whether you want CloudFront to forward cookies to the origin and, if so, which
         * ones. For more information about forwarding cookies to the origin, see <a
         * href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Cookies.html">How CloudFront
         * Forwards, Caches, and Logs Cookies</a> in the <i>Amazon CloudFront Developer Guide</i>.
         * </p>
         * This is a convenience that creates an instance of the {@link CookiePreference.Builder} avoiding the need to
         * create one manually via {@link CookiePreference#builder()}.
         *
         * When the {@link Consumer} completes, {@link CookiePreference.Builder#build()} is called immediately and its
         * result is passed to {@link #cookies(CookiePreference)}.
         * 
         * @param cookies
         *        a consumer that will call methods on {@link CookiePreference.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #cookies(CookiePreference)
         */
        default Builder cookies(Consumer<CookiePreference.Builder> cookies) {
            return cookies(CookiePreference.builder().applyMutation(cookies).build());
        }

        /**
         * <p>
         * This field is deprecated. We recommend that you use a cache policy or an origin request policy instead of
         * this field.
         * </p>
         * <p>
         * If you want to include headers in the cache key, use a cache policy. For more information, see <a href=
         * "https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy"
         * >Creating cache policies</a> in the <i>Amazon CloudFront Developer Guide</i>.
         * </p>
         * <p>
         * If you want to send headers to the origin but not include them in the cache key, use an origin request
         * policy. For more information, see <a href=
         * "https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-origin-requests.html#origin-request-create-origin-request-policy"
         * >Creating origin request policies</a> in the <i>Amazon CloudFront Developer Guide</i>.
         * </p>
         * <p>
         * A complex type that specifies the <code>Headers</code>, if any, that you want CloudFront to forward to the
         * origin for this cache behavior (whitelisted headers). For the headers that you specify, CloudFront also
         * caches separate versions of a specified object that is based on the header values in viewer requests.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/header-caching.html"> Caching
         * Content Based on Request Headers</a> in the <i>Amazon CloudFront Developer Guide</i>.
         * </p>
         * 
         * @param headers
         *        This field is deprecated. We recommend that you use a cache policy or an origin request policy instead
         *        of this field.</p>
         *        <p>
         *        If you want to include headers in the cache key, use a cache policy. For more information, see <a
         *        href=
         *        "https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy"
         *        >Creating cache policies</a> in the <i>Amazon CloudFront Developer Guide</i>.
         *        </p>
         *        <p>
         *        If you want to send headers to the origin but not include them in the cache key, use an origin request
         *        policy. For more information, see <a href=
         *        "https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-origin-requests.html#origin-request-create-origin-request-policy"
         *        >Creating origin request policies</a> in the <i>Amazon CloudFront Developer Guide</i>.
         *        </p>
         *        <p>
         *        A complex type that specifies the <code>Headers</code>, if any, that you want CloudFront to forward to
         *        the origin for this cache behavior (whitelisted headers). For the headers that you specify, CloudFront
         *        also caches separate versions of a specified object that is based on the header values in viewer
         *        requests.
         *        </p>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/header-caching.html"> Caching
         *        Content Based on Request Headers</a> in the <i>Amazon CloudFront Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder headers(Headers headers);

        /**
         * <p>
         * This field is deprecated. We recommend that you use a cache policy or an origin request policy instead of
         * this field.
         * </p>
         * <p>
         * If you want to include headers in the cache key, use a cache policy. For more information, see <a href=
         * "https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy"
         * >Creating cache policies</a> in the <i>Amazon CloudFront Developer Guide</i>.
         * </p>
         * <p>
         * If you want to send headers to the origin but not include them in the cache key, use an origin request
         * policy. For more information, see <a href=
         * "https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-origin-requests.html#origin-request-create-origin-request-policy"
         * >Creating origin request policies</a> in the <i>Amazon CloudFront Developer Guide</i>.
         * </p>
         * <p>
         * A complex type that specifies the <code>Headers</code>, if any, that you want CloudFront to forward to the
         * origin for this cache behavior (whitelisted headers). For the headers that you specify, CloudFront also
         * caches separate versions of a specified object that is based on the header values in viewer requests.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/header-caching.html"> Caching
         * Content Based on Request Headers</a> in the <i>Amazon CloudFront Developer Guide</i>.
         * </p>
         * This is a convenience that creates an instance of the {@link Headers.Builder} avoiding the need to create one
         * manually via {@link Headers#builder()}.
         *
         * When the {@link Consumer} completes, {@link Headers.Builder#build()} is called immediately and its result is
         * passed to {@link #headers(Headers)}.
         * 
         * @param headers
         *        a consumer that will call methods on {@link Headers.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #headers(Headers)
         */
        default Builder headers(Consumer<Headers.Builder> headers) {
            return headers(Headers.builder().applyMutation(headers).build());
        }

        /**
         * <p>
         * This field is deprecated. We recommend that you use a cache policy or an origin request policy instead of
         * this field.
         * </p>
         * <p>
         * If you want to include query strings in the cache key, use a cache policy. For more information, see <a href=
         * "https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy"
         * >Creating cache policies</a> in the <i>Amazon CloudFront Developer Guide</i>.
         * </p>
         * <p>
         * If you want to send query strings to the origin but not include them in the cache key, use an origin request
         * policy. For more information, see <a href=
         * "https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-origin-requests.html#origin-request-create-origin-request-policy"
         * >Creating origin request policies</a> in the <i>Amazon CloudFront Developer Guide</i>.
         * </p>
         * <p>
         * A complex type that contains information about the query string parameters that you want CloudFront to use
         * for caching for this cache behavior.
         * </p>
         * 
         * @param queryStringCacheKeys
         *        This field is deprecated. We recommend that you use a cache policy or an origin request policy instead
         *        of this field.</p>
         *        <p>
         *        If you want to include query strings in the cache key, use a cache policy. For more information, see
         *        <a href=
         *        "https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy"
         *        >Creating cache policies</a> in the <i>Amazon CloudFront Developer Guide</i>.
         *        </p>
         *        <p>
         *        If you want to send query strings to the origin but not include them in the cache key, use an origin
         *        request policy. For more information, see <a href=
         *        "https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-origin-requests.html#origin-request-create-origin-request-policy"
         *        >Creating origin request policies</a> in the <i>Amazon CloudFront Developer Guide</i>.
         *        </p>
         *        <p>
         *        A complex type that contains information about the query string parameters that you want CloudFront to
         *        use for caching for this cache behavior.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queryStringCacheKeys(QueryStringCacheKeys queryStringCacheKeys);

        /**
         * <p>
         * This field is deprecated. We recommend that you use a cache policy or an origin request policy instead of
         * this field.
         * </p>
         * <p>
         * If you want to include query strings in the cache key, use a cache policy. For more information, see <a href=
         * "https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy"
         * >Creating cache policies</a> in the <i>Amazon CloudFront Developer Guide</i>.
         * </p>
         * <p>
         * If you want to send query strings to the origin but not include them in the cache key, use an origin request
         * policy. For more information, see <a href=
         * "https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-origin-requests.html#origin-request-create-origin-request-policy"
         * >Creating origin request policies</a> in the <i>Amazon CloudFront Developer Guide</i>.
         * </p>
         * <p>
         * A complex type that contains information about the query string parameters that you want CloudFront to use
         * for caching for this cache behavior.
         * </p>
         * This is a convenience that creates an instance of the {@link QueryStringCacheKeys.Builder} avoiding the need
         * to create one manually via {@link QueryStringCacheKeys#builder()}.
         *
         * When the {@link Consumer} completes, {@link QueryStringCacheKeys.Builder#build()} is called immediately and
         * its result is passed to {@link #queryStringCacheKeys(QueryStringCacheKeys)}.
         * 
         * @param queryStringCacheKeys
         *        a consumer that will call methods on {@link QueryStringCacheKeys.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #queryStringCacheKeys(QueryStringCacheKeys)
         */
        default Builder queryStringCacheKeys(Consumer<QueryStringCacheKeys.Builder> queryStringCacheKeys) {
            return queryStringCacheKeys(QueryStringCacheKeys.builder().applyMutation(queryStringCacheKeys).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private Boolean queryString;

        private CookiePreference cookies;

        private Headers headers;

        private QueryStringCacheKeys queryStringCacheKeys;

        private BuilderImpl() {
        }

        private BuilderImpl(ForwardedValues model) {
            queryString(model.queryString);
            cookies(model.cookies);
            headers(model.headers);
            queryStringCacheKeys(model.queryStringCacheKeys);
        }

        public final Boolean getQueryString() {
            return queryString;
        }

        @Override
        public final Builder queryString(Boolean queryString) {
            this.queryString = queryString;
            return this;
        }

        public final void setQueryString(Boolean queryString) {
            this.queryString = queryString;
        }

        public final CookiePreference.Builder getCookies() {
            return cookies != null ? cookies.toBuilder() : null;
        }

        @Override
        public final Builder cookies(CookiePreference cookies) {
            this.cookies = cookies;
            return this;
        }

        public final void setCookies(CookiePreference.BuilderImpl cookies) {
            this.cookies = cookies != null ? cookies.build() : null;
        }

        public final Headers.Builder getHeaders() {
            return headers != null ? headers.toBuilder() : null;
        }

        @Override
        public final Builder headers(Headers headers) {
            this.headers = headers;
            return this;
        }

        public final void setHeaders(Headers.BuilderImpl headers) {
            this.headers = headers != null ? headers.build() : null;
        }

        public final QueryStringCacheKeys.Builder getQueryStringCacheKeys() {
            return queryStringCacheKeys != null ? queryStringCacheKeys.toBuilder() : null;
        }

        @Override
        public final Builder queryStringCacheKeys(QueryStringCacheKeys queryStringCacheKeys) {
            this.queryStringCacheKeys = queryStringCacheKeys;
            return this;
        }

        public final void setQueryStringCacheKeys(QueryStringCacheKeys.BuilderImpl queryStringCacheKeys) {
            this.queryStringCacheKeys = queryStringCacheKeys != null ? queryStringCacheKeys.build() : null;
        }

        @Override
        public ForwardedValues build() {
            return new ForwardedValues(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
