/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfront.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateRealtimeLogConfigRequest extends CloudFrontRequest implements
        ToCopyableBuilder<CreateRealtimeLogConfigRequest.Builder, CreateRealtimeLogConfigRequest> {
    private static final SdkField<List<EndPoint>> END_POINTS_FIELD = SdkField
            .<List<EndPoint>> builder(MarshallingType.LIST)
            .memberName("EndPoints")
            .getter(getter(CreateRealtimeLogConfigRequest::endPoints))
            .setter(setter(Builder::endPoints))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndPoints")
                    .unmarshallLocationName("EndPoints").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<EndPoint> builder(MarshallingType.SDK_POJO)
                                            .constructor(EndPoint::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").unmarshallLocationName("member").build()).build())
                            .build()).build();

    private static final SdkField<List<String>> FIELDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Fields")
            .getter(getter(CreateRealtimeLogConfigRequest::fields))
            .setter(setter(Builder::fields))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Fields")
                    .unmarshallLocationName("Fields").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("Field")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Field").unmarshallLocationName("Field").build()).build())
                            .build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Name")
            .getter(getter(CreateRealtimeLogConfigRequest::name))
            .setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name")
                    .unmarshallLocationName("Name").build()).build();

    private static final SdkField<Long> SAMPLING_RATE_FIELD = SdkField
            .<Long> builder(MarshallingType.LONG)
            .memberName("SamplingRate")
            .getter(getter(CreateRealtimeLogConfigRequest::samplingRate))
            .setter(setter(Builder::samplingRate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SamplingRate")
                    .unmarshallLocationName("SamplingRate").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(END_POINTS_FIELD,
            FIELDS_FIELD, NAME_FIELD, SAMPLING_RATE_FIELD));

    private final List<EndPoint> endPoints;

    private final List<String> fields;

    private final String name;

    private final Long samplingRate;

    private CreateRealtimeLogConfigRequest(BuilderImpl builder) {
        super(builder);
        this.endPoints = builder.endPoints;
        this.fields = builder.fields;
        this.name = builder.name;
        this.samplingRate = builder.samplingRate;
    }

    /**
     * Returns true if the EndPoints property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasEndPoints() {
        return endPoints != null && !(endPoints instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Contains information about the Amazon Kinesis data stream where you are sending real-time log data.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasEndPoints()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Contains information about the Amazon Kinesis data stream where you are sending real-time log data.
     */
    public final List<EndPoint> endPoints() {
        return endPoints;
    }

    /**
     * Returns true if the Fields property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasFields() {
        return fields != null && !(fields instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of fields to include in each real-time log record.
     * </p>
     * <p>
     * For more information about fields, see <a href=
     * "https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/real-time-logs.html#understand-real-time-log-config-fields"
     * >Real-time log configuration fields</a> in the <i>Amazon CloudFront Developer Guide</i>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasFields()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of fields to include in each real-time log record.</p>
     *         <p>
     *         For more information about fields, see <a href=
     *         "https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/real-time-logs.html#understand-real-time-log-config-fields"
     *         >Real-time log configuration fields</a> in the <i>Amazon CloudFront Developer Guide</i>.
     */
    public final List<String> fields() {
        return fields;
    }

    /**
     * <p>
     * A unique name to identify this real-time log configuration.
     * </p>
     * 
     * @return A unique name to identify this real-time log configuration.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The sampling rate for this real-time log configuration. The sampling rate determines the percentage of viewer
     * requests that are represented in the real-time log data. You must provide an integer between 1 and 100,
     * inclusive.
     * </p>
     * 
     * @return The sampling rate for this real-time log configuration. The sampling rate determines the percentage of
     *         viewer requests that are represented in the real-time log data. You must provide an integer between 1 and
     *         100, inclusive.
     */
    public final Long samplingRate() {
        return samplingRate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasEndPoints() ? endPoints() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasFields() ? fields() : null);
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(samplingRate());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateRealtimeLogConfigRequest)) {
            return false;
        }
        CreateRealtimeLogConfigRequest other = (CreateRealtimeLogConfigRequest) obj;
        return hasEndPoints() == other.hasEndPoints() && Objects.equals(endPoints(), other.endPoints())
                && hasFields() == other.hasFields() && Objects.equals(fields(), other.fields())
                && Objects.equals(name(), other.name()) && Objects.equals(samplingRate(), other.samplingRate());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateRealtimeLogConfigRequest").add("EndPoints", hasEndPoints() ? endPoints() : null)
                .add("Fields", hasFields() ? fields() : null).add("Name", name()).add("SamplingRate", samplingRate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EndPoints":
            return Optional.ofNullable(clazz.cast(endPoints()));
        case "Fields":
            return Optional.ofNullable(clazz.cast(fields()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "SamplingRate":
            return Optional.ofNullable(clazz.cast(samplingRate()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateRealtimeLogConfigRequest, T> g) {
        return obj -> g.apply((CreateRealtimeLogConfigRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudFrontRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateRealtimeLogConfigRequest> {
        /**
         * <p>
         * Contains information about the Amazon Kinesis data stream where you are sending real-time log data.
         * </p>
         * 
         * @param endPoints
         *        Contains information about the Amazon Kinesis data stream where you are sending real-time log data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endPoints(Collection<EndPoint> endPoints);

        /**
         * <p>
         * Contains information about the Amazon Kinesis data stream where you are sending real-time log data.
         * </p>
         * 
         * @param endPoints
         *        Contains information about the Amazon Kinesis data stream where you are sending real-time log data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endPoints(EndPoint... endPoints);

        /**
         * <p>
         * Contains information about the Amazon Kinesis data stream where you are sending real-time log data.
         * </p>
         * This is a convenience that creates an instance of the {@link List<EndPoint>.Builder} avoiding the need to
         * create one manually via {@link List<EndPoint>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<EndPoint>.Builder#build()} is called immediately and its
         * result is passed to {@link #endPoints(List<EndPoint>)}.
         * 
         * @param endPoints
         *        a consumer that will call methods on {@link List<EndPoint>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #endPoints(List<EndPoint>)
         */
        Builder endPoints(Consumer<EndPoint.Builder>... endPoints);

        /**
         * <p>
         * A list of fields to include in each real-time log record.
         * </p>
         * <p>
         * For more information about fields, see <a href=
         * "https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/real-time-logs.html#understand-real-time-log-config-fields"
         * >Real-time log configuration fields</a> in the <i>Amazon CloudFront Developer Guide</i>.
         * </p>
         * 
         * @param fields
         *        A list of fields to include in each real-time log record.</p>
         *        <p>
         *        For more information about fields, see <a href=
         *        "https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/real-time-logs.html#understand-real-time-log-config-fields"
         *        >Real-time log configuration fields</a> in the <i>Amazon CloudFront Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fields(Collection<String> fields);

        /**
         * <p>
         * A list of fields to include in each real-time log record.
         * </p>
         * <p>
         * For more information about fields, see <a href=
         * "https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/real-time-logs.html#understand-real-time-log-config-fields"
         * >Real-time log configuration fields</a> in the <i>Amazon CloudFront Developer Guide</i>.
         * </p>
         * 
         * @param fields
         *        A list of fields to include in each real-time log record.</p>
         *        <p>
         *        For more information about fields, see <a href=
         *        "https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/real-time-logs.html#understand-real-time-log-config-fields"
         *        >Real-time log configuration fields</a> in the <i>Amazon CloudFront Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fields(String... fields);

        /**
         * <p>
         * A unique name to identify this real-time log configuration.
         * </p>
         * 
         * @param name
         *        A unique name to identify this real-time log configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The sampling rate for this real-time log configuration. The sampling rate determines the percentage of viewer
         * requests that are represented in the real-time log data. You must provide an integer between 1 and 100,
         * inclusive.
         * </p>
         * 
         * @param samplingRate
         *        The sampling rate for this real-time log configuration. The sampling rate determines the percentage of
         *        viewer requests that are represented in the real-time log data. You must provide an integer between 1
         *        and 100, inclusive.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder samplingRate(Long samplingRate);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CloudFrontRequest.BuilderImpl implements Builder {
        private List<EndPoint> endPoints = DefaultSdkAutoConstructList.getInstance();

        private List<String> fields = DefaultSdkAutoConstructList.getInstance();

        private String name;

        private Long samplingRate;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateRealtimeLogConfigRequest model) {
            super(model);
            endPoints(model.endPoints);
            fields(model.fields);
            name(model.name);
            samplingRate(model.samplingRate);
        }

        public final Collection<EndPoint.Builder> getEndPoints() {
            if (endPoints instanceof SdkAutoConstructList) {
                return null;
            }
            return endPoints != null ? endPoints.stream().map(EndPoint::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder endPoints(Collection<EndPoint> endPoints) {
            this.endPoints = EndPointListCopier.copy(endPoints);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder endPoints(EndPoint... endPoints) {
            endPoints(Arrays.asList(endPoints));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder endPoints(Consumer<EndPoint.Builder>... endPoints) {
            endPoints(Stream.of(endPoints).map(c -> EndPoint.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setEndPoints(Collection<EndPoint.BuilderImpl> endPoints) {
            this.endPoints = EndPointListCopier.copyFromBuilder(endPoints);
        }

        public final Collection<String> getFields() {
            if (fields instanceof SdkAutoConstructList) {
                return null;
            }
            return fields;
        }

        @Override
        public final Builder fields(Collection<String> fields) {
            this.fields = FieldListCopier.copy(fields);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fields(String... fields) {
            fields(Arrays.asList(fields));
            return this;
        }

        public final void setFields(Collection<String> fields) {
            this.fields = FieldListCopier.copy(fields);
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final Long getSamplingRate() {
            return samplingRate;
        }

        @Override
        public final Builder samplingRate(Long samplingRate) {
            this.samplingRate = samplingRate;
            return this;
        }

        public final void setSamplingRate(Long samplingRate) {
            this.samplingRate = samplingRate;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateRealtimeLogConfigRequest build() {
            return new CreateRealtimeLogConfigRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
