/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfront.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The request to create an invalidation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateInvalidationRequest extends CloudFrontRequest implements
        ToCopyableBuilder<CreateInvalidationRequest.Builder, CreateInvalidationRequest> {
    private static final SdkField<String> DISTRIBUTION_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("DistributionId")
            .getter(getter(CreateInvalidationRequest::distributionId))
            .setter(setter(Builder::distributionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("DistributionId")
                    .unmarshallLocationName("DistributionId").build()).build();

    private static final SdkField<InvalidationBatch> INVALIDATION_BATCH_FIELD = SdkField
            .<InvalidationBatch> builder(MarshallingType.SDK_POJO)
            .memberName("InvalidationBatch")
            .getter(getter(CreateInvalidationRequest::invalidationBatch))
            .setter(setter(Builder::invalidationBatch))
            .constructor(InvalidationBatch::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InvalidationBatch")
                    .unmarshallLocationName("InvalidationBatch").build(), PayloadTrait.create()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DISTRIBUTION_ID_FIELD,
            INVALIDATION_BATCH_FIELD));

    private final String distributionId;

    private final InvalidationBatch invalidationBatch;

    private CreateInvalidationRequest(BuilderImpl builder) {
        super(builder);
        this.distributionId = builder.distributionId;
        this.invalidationBatch = builder.invalidationBatch;
    }

    /**
     * <p>
     * The distribution's id.
     * </p>
     * 
     * @return The distribution's id.
     */
    public final String distributionId() {
        return distributionId;
    }

    /**
     * <p>
     * The batch information for the invalidation.
     * </p>
     * 
     * @return The batch information for the invalidation.
     */
    public final InvalidationBatch invalidationBatch() {
        return invalidationBatch;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(distributionId());
        hashCode = 31 * hashCode + Objects.hashCode(invalidationBatch());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateInvalidationRequest)) {
            return false;
        }
        CreateInvalidationRequest other = (CreateInvalidationRequest) obj;
        return Objects.equals(distributionId(), other.distributionId())
                && Objects.equals(invalidationBatch(), other.invalidationBatch());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateInvalidationRequest").add("DistributionId", distributionId())
                .add("InvalidationBatch", invalidationBatch()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DistributionId":
            return Optional.ofNullable(clazz.cast(distributionId()));
        case "InvalidationBatch":
            return Optional.ofNullable(clazz.cast(invalidationBatch()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateInvalidationRequest, T> g) {
        return obj -> g.apply((CreateInvalidationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudFrontRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateInvalidationRequest> {
        /**
         * <p>
         * The distribution's id.
         * </p>
         * 
         * @param distributionId
         *        The distribution's id.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder distributionId(String distributionId);

        /**
         * <p>
         * The batch information for the invalidation.
         * </p>
         * 
         * @param invalidationBatch
         *        The batch information for the invalidation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder invalidationBatch(InvalidationBatch invalidationBatch);

        /**
         * <p>
         * The batch information for the invalidation.
         * </p>
         * This is a convenience that creates an instance of the {@link InvalidationBatch.Builder} avoiding the need to
         * create one manually via {@link InvalidationBatch#builder()}.
         *
         * When the {@link Consumer} completes, {@link InvalidationBatch.Builder#build()} is called immediately and its
         * result is passed to {@link #invalidationBatch(InvalidationBatch)}.
         * 
         * @param invalidationBatch
         *        a consumer that will call methods on {@link InvalidationBatch.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #invalidationBatch(InvalidationBatch)
         */
        default Builder invalidationBatch(Consumer<InvalidationBatch.Builder> invalidationBatch) {
            return invalidationBatch(InvalidationBatch.builder().applyMutation(invalidationBatch).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CloudFrontRequest.BuilderImpl implements Builder {
        private String distributionId;

        private InvalidationBatch invalidationBatch;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateInvalidationRequest model) {
            super(model);
            distributionId(model.distributionId);
            invalidationBatch(model.invalidationBatch);
        }

        public final String getDistributionId() {
            return distributionId;
        }

        @Override
        public final Builder distributionId(String distributionId) {
            this.distributionId = distributionId;
            return this;
        }

        public final void setDistributionId(String distributionId) {
            this.distributionId = distributionId;
        }

        public final InvalidationBatch.Builder getInvalidationBatch() {
            return invalidationBatch != null ? invalidationBatch.toBuilder() : null;
        }

        @Override
        public final Builder invalidationBatch(InvalidationBatch invalidationBatch) {
            this.invalidationBatch = invalidationBatch;
            return this;
        }

        public final void setInvalidationBatch(InvalidationBatch.BuilderImpl invalidationBatch) {
            this.invalidationBatch = invalidationBatch != null ? invalidationBatch.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateInvalidationRequest build() {
            return new CreateInvalidationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
