/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cloudfront.model.CloudFrontRequest;
import software.amazon.awssdk.services.cloudfront.model.MonitoringSubscription;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateMonitoringSubscriptionRequest
extends CloudFrontRequest
implements ToCopyableBuilder<Builder, CreateMonitoringSubscriptionRequest> {
    private static final SdkField<String> DISTRIBUTION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DistributionId").getter(CreateMonitoringSubscriptionRequest.getter(CreateMonitoringSubscriptionRequest::distributionId)).setter(CreateMonitoringSubscriptionRequest.setter(Builder::distributionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("DistributionId").unmarshallLocationName("DistributionId").build()}).build();
    private static final SdkField<MonitoringSubscription> MONITORING_SUBSCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("MonitoringSubscription").getter(CreateMonitoringSubscriptionRequest.getter(CreateMonitoringSubscriptionRequest::monitoringSubscription)).setter(CreateMonitoringSubscriptionRequest.setter(Builder::monitoringSubscription)).constructor(MonitoringSubscription::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MonitoringSubscription").unmarshallLocationName("MonitoringSubscription").build(), PayloadTrait.create()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DISTRIBUTION_ID_FIELD, MONITORING_SUBSCRIPTION_FIELD));
    private final String distributionId;
    private final MonitoringSubscription monitoringSubscription;

    private CreateMonitoringSubscriptionRequest(BuilderImpl builder) {
        super(builder);
        this.distributionId = builder.distributionId;
        this.monitoringSubscription = builder.monitoringSubscription;
    }

    public String distributionId() {
        return this.distributionId;
    }

    public MonitoringSubscription monitoringSubscription() {
        return this.monitoringSubscription;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.distributionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.monitoringSubscription());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateMonitoringSubscriptionRequest)) {
            return false;
        }
        CreateMonitoringSubscriptionRequest other = (CreateMonitoringSubscriptionRequest)((Object)obj);
        return Objects.equals(this.distributionId(), other.distributionId()) && Objects.equals(this.monitoringSubscription(), other.monitoringSubscription());
    }

    public String toString() {
        return ToString.builder((String)"CreateMonitoringSubscriptionRequest").add("DistributionId", (Object)this.distributionId()).add("MonitoringSubscription", (Object)this.monitoringSubscription()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DistributionId": {
                return Optional.ofNullable(clazz.cast(this.distributionId()));
            }
            case "MonitoringSubscription": {
                return Optional.ofNullable(clazz.cast(this.monitoringSubscription()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateMonitoringSubscriptionRequest, T> g) {
        return obj -> g.apply((CreateMonitoringSubscriptionRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudFrontRequest.BuilderImpl
    implements Builder {
        private String distributionId;
        private MonitoringSubscription monitoringSubscription;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateMonitoringSubscriptionRequest model) {
            super(model);
            this.distributionId(model.distributionId);
            this.monitoringSubscription(model.monitoringSubscription);
        }

        public final String getDistributionId() {
            return this.distributionId;
        }

        @Override
        public final Builder distributionId(String distributionId) {
            this.distributionId = distributionId;
            return this;
        }

        public final void setDistributionId(String distributionId) {
            this.distributionId = distributionId;
        }

        public final MonitoringSubscription.Builder getMonitoringSubscription() {
            return this.monitoringSubscription != null ? this.monitoringSubscription.toBuilder() : null;
        }

        @Override
        public final Builder monitoringSubscription(MonitoringSubscription monitoringSubscription) {
            this.monitoringSubscription = monitoringSubscription;
            return this;
        }

        public final void setMonitoringSubscription(MonitoringSubscription.BuilderImpl monitoringSubscription) {
            this.monitoringSubscription = monitoringSubscription != null ? monitoringSubscription.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateMonitoringSubscriptionRequest build() {
            return new CreateMonitoringSubscriptionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CloudFrontRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateMonitoringSubscriptionRequest> {
        public Builder distributionId(String var1);

        public Builder monitoringSubscription(MonitoringSubscription var1);

        default public Builder monitoringSubscription(Consumer<MonitoringSubscription.Builder> monitoringSubscription) {
            return this.monitoringSubscription((MonitoringSubscription)((MonitoringSubscription.Builder)MonitoringSubscription.builder().applyMutation(monitoringSubscription)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

