/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfront.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A complex type that lists the AWS accounts that were included in the <code>TrustedSigners</code> complex type, as
 * well as their active CloudFront key pair IDs, if any.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Signer implements SdkPojo, Serializable, ToCopyableBuilder<Signer.Builder, Signer> {
    private static final SdkField<String> AWS_ACCOUNT_NUMBER_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(Signer::awsAccountNumber))
            .setter(setter(Builder::awsAccountNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AwsAccountNumber")
                    .unmarshallLocationName("AwsAccountNumber").build()).build();

    private static final SdkField<KeyPairIds> KEY_PAIR_IDS_FIELD = SdkField
            .<KeyPairIds> builder(MarshallingType.SDK_POJO)
            .getter(getter(Signer::keyPairIds))
            .setter(setter(Builder::keyPairIds))
            .constructor(KeyPairIds::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyPairIds")
                    .unmarshallLocationName("KeyPairIds").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AWS_ACCOUNT_NUMBER_FIELD,
            KEY_PAIR_IDS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String awsAccountNumber;

    private final KeyPairIds keyPairIds;

    private Signer(BuilderImpl builder) {
        this.awsAccountNumber = builder.awsAccountNumber;
        this.keyPairIds = builder.keyPairIds;
    }

    /**
     * <p>
     * An AWS account that is included in the <code>TrustedSigners</code> complex type for this distribution. Valid
     * values include:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>self</code>, which is the AWS account used to create the distribution.
     * </p>
     * </li>
     * <li>
     * <p>
     * An AWS account number.
     * </p>
     * </li>
     * </ul>
     * 
     * @return An AWS account that is included in the <code>TrustedSigners</code> complex type for this distribution.
     *         Valid values include:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>self</code>, which is the AWS account used to create the distribution.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         An AWS account number.
     *         </p>
     *         </li>
     */
    public String awsAccountNumber() {
        return awsAccountNumber;
    }

    /**
     * <p>
     * A complex type that lists the active CloudFront key pairs, if any, that are associated with
     * <code>AwsAccountNumber</code>.
     * </p>
     * 
     * @return A complex type that lists the active CloudFront key pairs, if any, that are associated with
     *         <code>AwsAccountNumber</code>.
     */
    public KeyPairIds keyPairIds() {
        return keyPairIds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(awsAccountNumber());
        hashCode = 31 * hashCode + Objects.hashCode(keyPairIds());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Signer)) {
            return false;
        }
        Signer other = (Signer) obj;
        return Objects.equals(awsAccountNumber(), other.awsAccountNumber()) && Objects.equals(keyPairIds(), other.keyPairIds());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("Signer").add("AwsAccountNumber", awsAccountNumber()).add("KeyPairIds", keyPairIds()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AwsAccountNumber":
            return Optional.ofNullable(clazz.cast(awsAccountNumber()));
        case "KeyPairIds":
            return Optional.ofNullable(clazz.cast(keyPairIds()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Signer, T> g) {
        return obj -> g.apply((Signer) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Signer> {
        /**
         * <p>
         * An AWS account that is included in the <code>TrustedSigners</code> complex type for this distribution. Valid
         * values include:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>self</code>, which is the AWS account used to create the distribution.
         * </p>
         * </li>
         * <li>
         * <p>
         * An AWS account number.
         * </p>
         * </li>
         * </ul>
         * 
         * @param awsAccountNumber
         *        An AWS account that is included in the <code>TrustedSigners</code> complex type for this distribution.
         *        Valid values include:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>self</code>, which is the AWS account used to create the distribution.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        An AWS account number.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsAccountNumber(String awsAccountNumber);

        /**
         * <p>
         * A complex type that lists the active CloudFront key pairs, if any, that are associated with
         * <code>AwsAccountNumber</code>.
         * </p>
         * 
         * @param keyPairIds
         *        A complex type that lists the active CloudFront key pairs, if any, that are associated with
         *        <code>AwsAccountNumber</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keyPairIds(KeyPairIds keyPairIds);

        /**
         * <p>
         * A complex type that lists the active CloudFront key pairs, if any, that are associated with
         * <code>AwsAccountNumber</code>.
         * </p>
         * This is a convenience that creates an instance of the {@link KeyPairIds.Builder} avoiding the need to create
         * one manually via {@link KeyPairIds#builder()}.
         *
         * When the {@link Consumer} completes, {@link KeyPairIds.Builder#build()} is called immediately and its result
         * is passed to {@link #keyPairIds(KeyPairIds)}.
         * 
         * @param keyPairIds
         *        a consumer that will call methods on {@link KeyPairIds.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #keyPairIds(KeyPairIds)
         */
        default Builder keyPairIds(Consumer<KeyPairIds.Builder> keyPairIds) {
            return keyPairIds(KeyPairIds.builder().applyMutation(keyPairIds).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String awsAccountNumber;

        private KeyPairIds keyPairIds;

        private BuilderImpl() {
        }

        private BuilderImpl(Signer model) {
            awsAccountNumber(model.awsAccountNumber);
            keyPairIds(model.keyPairIds);
        }

        public final String getAwsAccountNumber() {
            return awsAccountNumber;
        }

        @Override
        public final Builder awsAccountNumber(String awsAccountNumber) {
            this.awsAccountNumber = awsAccountNumber;
            return this;
        }

        public final void setAwsAccountNumber(String awsAccountNumber) {
            this.awsAccountNumber = awsAccountNumber;
        }

        public final KeyPairIds.Builder getKeyPairIds() {
            return keyPairIds != null ? keyPairIds.toBuilder() : null;
        }

        @Override
        public final Builder keyPairIds(KeyPairIds keyPairIds) {
            this.keyPairIds = keyPairIds;
            return this;
        }

        public final void setKeyPairIds(KeyPairIds.BuilderImpl keyPairIds) {
            this.keyPairIds = keyPairIds != null ? keyPairIds.build() : null;
        }

        @Override
        public Signer build() {
            return new Signer(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
