/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cloudfront.model.AliasICPRecordal;
import software.amazon.awssdk.services.cloudfront.model.AliasICPRecordalsCopier;
import software.amazon.awssdk.services.cloudfront.model.Aliases;
import software.amazon.awssdk.services.cloudfront.model.CacheBehaviors;
import software.amazon.awssdk.services.cloudfront.model.CustomErrorResponses;
import software.amazon.awssdk.services.cloudfront.model.DefaultCacheBehavior;
import software.amazon.awssdk.services.cloudfront.model.HttpVersion;
import software.amazon.awssdk.services.cloudfront.model.OriginGroups;
import software.amazon.awssdk.services.cloudfront.model.Origins;
import software.amazon.awssdk.services.cloudfront.model.PriceClass;
import software.amazon.awssdk.services.cloudfront.model.Restrictions;
import software.amazon.awssdk.services.cloudfront.model.ViewerCertificate;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DistributionSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DistributionSummary> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DistributionSummary.getter(DistributionSummary::id)).setter(DistributionSummary.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").unmarshallLocationName("Id").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DistributionSummary.getter(DistributionSummary::arn)).setter(DistributionSummary.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ARN").unmarshallLocationName("ARN").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DistributionSummary.getter(DistributionSummary::status)).setter(DistributionSummary.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").unmarshallLocationName("Status").build()}).build();
    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(DistributionSummary.getter(DistributionSummary::lastModifiedTime)).setter(DistributionSummary.setter(Builder::lastModifiedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime").unmarshallLocationName("LastModifiedTime").build()}).build();
    private static final SdkField<String> DOMAIN_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DistributionSummary.getter(DistributionSummary::domainName)).setter(DistributionSummary.setter(Builder::domainName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainName").unmarshallLocationName("DomainName").build()}).build();
    private static final SdkField<Aliases> ALIASES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(DistributionSummary.getter(DistributionSummary::aliases)).setter(DistributionSummary.setter(Builder::aliases)).constructor(Aliases::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Aliases").unmarshallLocationName("Aliases").build()}).build();
    private static final SdkField<Origins> ORIGINS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(DistributionSummary.getter(DistributionSummary::origins)).setter(DistributionSummary.setter(Builder::origins)).constructor(Origins::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Origins").unmarshallLocationName("Origins").build()}).build();
    private static final SdkField<OriginGroups> ORIGIN_GROUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(DistributionSummary.getter(DistributionSummary::originGroups)).setter(DistributionSummary.setter(Builder::originGroups)).constructor(OriginGroups::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OriginGroups").unmarshallLocationName("OriginGroups").build()}).build();
    private static final SdkField<DefaultCacheBehavior> DEFAULT_CACHE_BEHAVIOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(DistributionSummary.getter(DistributionSummary::defaultCacheBehavior)).setter(DistributionSummary.setter(Builder::defaultCacheBehavior)).constructor(DefaultCacheBehavior::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultCacheBehavior").unmarshallLocationName("DefaultCacheBehavior").build()}).build();
    private static final SdkField<CacheBehaviors> CACHE_BEHAVIORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(DistributionSummary.getter(DistributionSummary::cacheBehaviors)).setter(DistributionSummary.setter(Builder::cacheBehaviors)).constructor(CacheBehaviors::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CacheBehaviors").unmarshallLocationName("CacheBehaviors").build()}).build();
    private static final SdkField<CustomErrorResponses> CUSTOM_ERROR_RESPONSES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(DistributionSummary.getter(DistributionSummary::customErrorResponses)).setter(DistributionSummary.setter(Builder::customErrorResponses)).constructor(CustomErrorResponses::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomErrorResponses").unmarshallLocationName("CustomErrorResponses").build()}).build();
    private static final SdkField<String> COMMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DistributionSummary.getter(DistributionSummary::comment)).setter(DistributionSummary.setter(Builder::comment)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Comment").unmarshallLocationName("Comment").build()}).build();
    private static final SdkField<String> PRICE_CLASS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DistributionSummary.getter(DistributionSummary::priceClassAsString)).setter(DistributionSummary.setter(Builder::priceClass)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PriceClass").unmarshallLocationName("PriceClass").build()}).build();
    private static final SdkField<Boolean> ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(DistributionSummary.getter(DistributionSummary::enabled)).setter(DistributionSummary.setter(Builder::enabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Enabled").unmarshallLocationName("Enabled").build()}).build();
    private static final SdkField<ViewerCertificate> VIEWER_CERTIFICATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(DistributionSummary.getter(DistributionSummary::viewerCertificate)).setter(DistributionSummary.setter(Builder::viewerCertificate)).constructor(ViewerCertificate::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ViewerCertificate").unmarshallLocationName("ViewerCertificate").build()}).build();
    private static final SdkField<Restrictions> RESTRICTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(DistributionSummary.getter(DistributionSummary::restrictions)).setter(DistributionSummary.setter(Builder::restrictions)).constructor(Restrictions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Restrictions").unmarshallLocationName("Restrictions").build()}).build();
    private static final SdkField<String> WEB_ACL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DistributionSummary.getter(DistributionSummary::webACLId)).setter(DistributionSummary.setter(Builder::webACLId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WebACLId").unmarshallLocationName("WebACLId").build()}).build();
    private static final SdkField<String> HTTP_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DistributionSummary.getter(DistributionSummary::httpVersionAsString)).setter(DistributionSummary.setter(Builder::httpVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HttpVersion").unmarshallLocationName("HttpVersion").build()}).build();
    private static final SdkField<Boolean> IS_IPV6_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(DistributionSummary.getter(DistributionSummary::isIPV6Enabled)).setter(DistributionSummary.setter(Builder::isIPV6Enabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsIPV6Enabled").unmarshallLocationName("IsIPV6Enabled").build()}).build();
    private static final SdkField<List<AliasICPRecordal>> ALIAS_ICP_RECORDALS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(DistributionSummary.getter(DistributionSummary::aliasICPRecordals)).setter(DistributionSummary.setter(Builder::aliasICPRecordals)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AliasICPRecordals").unmarshallLocationName("AliasICPRecordals").build(), ListTrait.builder().memberLocationName("AliasICPRecordal").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AliasICPRecordal::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AliasICPRecordal").unmarshallLocationName("AliasICPRecordal").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, ARN_FIELD, STATUS_FIELD, LAST_MODIFIED_TIME_FIELD, DOMAIN_NAME_FIELD, ALIASES_FIELD, ORIGINS_FIELD, ORIGIN_GROUPS_FIELD, DEFAULT_CACHE_BEHAVIOR_FIELD, CACHE_BEHAVIORS_FIELD, CUSTOM_ERROR_RESPONSES_FIELD, COMMENT_FIELD, PRICE_CLASS_FIELD, ENABLED_FIELD, VIEWER_CERTIFICATE_FIELD, RESTRICTIONS_FIELD, WEB_ACL_ID_FIELD, HTTP_VERSION_FIELD, IS_IPV6_ENABLED_FIELD, ALIAS_ICP_RECORDALS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String id;
    private final String arn;
    private final String status;
    private final Instant lastModifiedTime;
    private final String domainName;
    private final Aliases aliases;
    private final Origins origins;
    private final OriginGroups originGroups;
    private final DefaultCacheBehavior defaultCacheBehavior;
    private final CacheBehaviors cacheBehaviors;
    private final CustomErrorResponses customErrorResponses;
    private final String comment;
    private final String priceClass;
    private final Boolean enabled;
    private final ViewerCertificate viewerCertificate;
    private final Restrictions restrictions;
    private final String webACLId;
    private final String httpVersion;
    private final Boolean isIPV6Enabled;
    private final List<AliasICPRecordal> aliasICPRecordals;

    private DistributionSummary(BuilderImpl builder) {
        this.id = builder.id;
        this.arn = builder.arn;
        this.status = builder.status;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.domainName = builder.domainName;
        this.aliases = builder.aliases;
        this.origins = builder.origins;
        this.originGroups = builder.originGroups;
        this.defaultCacheBehavior = builder.defaultCacheBehavior;
        this.cacheBehaviors = builder.cacheBehaviors;
        this.customErrorResponses = builder.customErrorResponses;
        this.comment = builder.comment;
        this.priceClass = builder.priceClass;
        this.enabled = builder.enabled;
        this.viewerCertificate = builder.viewerCertificate;
        this.restrictions = builder.restrictions;
        this.webACLId = builder.webACLId;
        this.httpVersion = builder.httpVersion;
        this.isIPV6Enabled = builder.isIPV6Enabled;
        this.aliasICPRecordals = builder.aliasICPRecordals;
    }

    public String id() {
        return this.id;
    }

    public String arn() {
        return this.arn;
    }

    public String status() {
        return this.status;
    }

    public Instant lastModifiedTime() {
        return this.lastModifiedTime;
    }

    public String domainName() {
        return this.domainName;
    }

    public Aliases aliases() {
        return this.aliases;
    }

    public Origins origins() {
        return this.origins;
    }

    public OriginGroups originGroups() {
        return this.originGroups;
    }

    public DefaultCacheBehavior defaultCacheBehavior() {
        return this.defaultCacheBehavior;
    }

    public CacheBehaviors cacheBehaviors() {
        return this.cacheBehaviors;
    }

    public CustomErrorResponses customErrorResponses() {
        return this.customErrorResponses;
    }

    public String comment() {
        return this.comment;
    }

    public PriceClass priceClass() {
        return PriceClass.fromValue(this.priceClass);
    }

    public String priceClassAsString() {
        return this.priceClass;
    }

    public Boolean enabled() {
        return this.enabled;
    }

    public ViewerCertificate viewerCertificate() {
        return this.viewerCertificate;
    }

    public Restrictions restrictions() {
        return this.restrictions;
    }

    public String webACLId() {
        return this.webACLId;
    }

    public HttpVersion httpVersion() {
        return HttpVersion.fromValue(this.httpVersion);
    }

    public String httpVersionAsString() {
        return this.httpVersion;
    }

    public Boolean isIPV6Enabled() {
        return this.isIPV6Enabled;
    }

    public boolean hasAliasICPRecordals() {
        return this.aliasICPRecordals != null && !(this.aliasICPRecordals instanceof SdkAutoConstructList);
    }

    public List<AliasICPRecordal> aliasICPRecordals() {
        return this.aliasICPRecordals;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.domainName());
        hashCode = 31 * hashCode + Objects.hashCode(this.aliases());
        hashCode = 31 * hashCode + Objects.hashCode(this.origins());
        hashCode = 31 * hashCode + Objects.hashCode(this.originGroups());
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultCacheBehavior());
        hashCode = 31 * hashCode + Objects.hashCode(this.cacheBehaviors());
        hashCode = 31 * hashCode + Objects.hashCode(this.customErrorResponses());
        hashCode = 31 * hashCode + Objects.hashCode(this.comment());
        hashCode = 31 * hashCode + Objects.hashCode(this.priceClassAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.enabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.viewerCertificate());
        hashCode = 31 * hashCode + Objects.hashCode(this.restrictions());
        hashCode = 31 * hashCode + Objects.hashCode(this.webACLId());
        hashCode = 31 * hashCode + Objects.hashCode(this.httpVersionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.isIPV6Enabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.aliasICPRecordals());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DistributionSummary)) {
            return false;
        }
        DistributionSummary other = (DistributionSummary)obj;
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.status(), other.status()) && Objects.equals(this.lastModifiedTime(), other.lastModifiedTime()) && Objects.equals(this.domainName(), other.domainName()) && Objects.equals(this.aliases(), other.aliases()) && Objects.equals(this.origins(), other.origins()) && Objects.equals(this.originGroups(), other.originGroups()) && Objects.equals(this.defaultCacheBehavior(), other.defaultCacheBehavior()) && Objects.equals(this.cacheBehaviors(), other.cacheBehaviors()) && Objects.equals(this.customErrorResponses(), other.customErrorResponses()) && Objects.equals(this.comment(), other.comment()) && Objects.equals(this.priceClassAsString(), other.priceClassAsString()) && Objects.equals(this.enabled(), other.enabled()) && Objects.equals(this.viewerCertificate(), other.viewerCertificate()) && Objects.equals(this.restrictions(), other.restrictions()) && Objects.equals(this.webACLId(), other.webACLId()) && Objects.equals(this.httpVersionAsString(), other.httpVersionAsString()) && Objects.equals(this.isIPV6Enabled(), other.isIPV6Enabled()) && Objects.equals(this.aliasICPRecordals(), other.aliasICPRecordals());
    }

    public String toString() {
        return ToString.builder((String)"DistributionSummary").add("Id", (Object)this.id()).add("ARN", (Object)this.arn()).add("Status", (Object)this.status()).add("LastModifiedTime", (Object)this.lastModifiedTime()).add("DomainName", (Object)this.domainName()).add("Aliases", (Object)this.aliases()).add("Origins", (Object)this.origins()).add("OriginGroups", (Object)this.originGroups()).add("DefaultCacheBehavior", (Object)this.defaultCacheBehavior()).add("CacheBehaviors", (Object)this.cacheBehaviors()).add("CustomErrorResponses", (Object)this.customErrorResponses()).add("Comment", (Object)this.comment()).add("PriceClass", (Object)this.priceClassAsString()).add("Enabled", (Object)this.enabled()).add("ViewerCertificate", (Object)this.viewerCertificate()).add("Restrictions", (Object)this.restrictions()).add("WebACLId", (Object)this.webACLId()).add("HttpVersion", (Object)this.httpVersionAsString()).add("IsIPV6Enabled", (Object)this.isIPV6Enabled()).add("AliasICPRecordals", this.aliasICPRecordals()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "ARN": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
            case "LastModifiedTime": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedTime()));
            }
            case "DomainName": {
                return Optional.ofNullable(clazz.cast(this.domainName()));
            }
            case "Aliases": {
                return Optional.ofNullable(clazz.cast(this.aliases()));
            }
            case "Origins": {
                return Optional.ofNullable(clazz.cast(this.origins()));
            }
            case "OriginGroups": {
                return Optional.ofNullable(clazz.cast(this.originGroups()));
            }
            case "DefaultCacheBehavior": {
                return Optional.ofNullable(clazz.cast(this.defaultCacheBehavior()));
            }
            case "CacheBehaviors": {
                return Optional.ofNullable(clazz.cast(this.cacheBehaviors()));
            }
            case "CustomErrorResponses": {
                return Optional.ofNullable(clazz.cast(this.customErrorResponses()));
            }
            case "Comment": {
                return Optional.ofNullable(clazz.cast(this.comment()));
            }
            case "PriceClass": {
                return Optional.ofNullable(clazz.cast(this.priceClassAsString()));
            }
            case "Enabled": {
                return Optional.ofNullable(clazz.cast(this.enabled()));
            }
            case "ViewerCertificate": {
                return Optional.ofNullable(clazz.cast(this.viewerCertificate()));
            }
            case "Restrictions": {
                return Optional.ofNullable(clazz.cast(this.restrictions()));
            }
            case "WebACLId": {
                return Optional.ofNullable(clazz.cast(this.webACLId()));
            }
            case "HttpVersion": {
                return Optional.ofNullable(clazz.cast(this.httpVersionAsString()));
            }
            case "IsIPV6Enabled": {
                return Optional.ofNullable(clazz.cast(this.isIPV6Enabled()));
            }
            case "AliasICPRecordals": {
                return Optional.ofNullable(clazz.cast(this.aliasICPRecordals()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DistributionSummary, T> g) {
        return obj -> g.apply((DistributionSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private String arn;
        private String status;
        private Instant lastModifiedTime;
        private String domainName;
        private Aliases aliases;
        private Origins origins;
        private OriginGroups originGroups;
        private DefaultCacheBehavior defaultCacheBehavior;
        private CacheBehaviors cacheBehaviors;
        private CustomErrorResponses customErrorResponses;
        private String comment;
        private String priceClass;
        private Boolean enabled;
        private ViewerCertificate viewerCertificate;
        private Restrictions restrictions;
        private String webACLId;
        private String httpVersion;
        private Boolean isIPV6Enabled;
        private List<AliasICPRecordal> aliasICPRecordals = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DistributionSummary model) {
            this.id(model.id);
            this.arn(model.arn);
            this.status(model.status);
            this.lastModifiedTime(model.lastModifiedTime);
            this.domainName(model.domainName);
            this.aliases(model.aliases);
            this.origins(model.origins);
            this.originGroups(model.originGroups);
            this.defaultCacheBehavior(model.defaultCacheBehavior);
            this.cacheBehaviors(model.cacheBehaviors);
            this.customErrorResponses(model.customErrorResponses);
            this.comment(model.comment);
            this.priceClass(model.priceClass);
            this.enabled(model.enabled);
            this.viewerCertificate(model.viewerCertificate);
            this.restrictions(model.restrictions);
            this.webACLId(model.webACLId);
            this.httpVersion(model.httpVersion);
            this.isIPV6Enabled(model.isIPV6Enabled);
            this.aliasICPRecordals(model.aliasICPRecordals);
        }

        public final String getId() {
            return this.id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getArn() {
            return this.arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final Instant getLastModifiedTime() {
            return this.lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        public final String getDomainName() {
            return this.domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        public final Aliases.Builder getAliases() {
            return this.aliases != null ? this.aliases.toBuilder() : null;
        }

        @Override
        public final Builder aliases(Aliases aliases) {
            this.aliases = aliases;
            return this;
        }

        public final void setAliases(Aliases.BuilderImpl aliases) {
            this.aliases = aliases != null ? aliases.build() : null;
        }

        public final Origins.Builder getOrigins() {
            return this.origins != null ? this.origins.toBuilder() : null;
        }

        @Override
        public final Builder origins(Origins origins) {
            this.origins = origins;
            return this;
        }

        public final void setOrigins(Origins.BuilderImpl origins) {
            this.origins = origins != null ? origins.build() : null;
        }

        public final OriginGroups.Builder getOriginGroups() {
            return this.originGroups != null ? this.originGroups.toBuilder() : null;
        }

        @Override
        public final Builder originGroups(OriginGroups originGroups) {
            this.originGroups = originGroups;
            return this;
        }

        public final void setOriginGroups(OriginGroups.BuilderImpl originGroups) {
            this.originGroups = originGroups != null ? originGroups.build() : null;
        }

        public final DefaultCacheBehavior.Builder getDefaultCacheBehavior() {
            return this.defaultCacheBehavior != null ? this.defaultCacheBehavior.toBuilder() : null;
        }

        @Override
        public final Builder defaultCacheBehavior(DefaultCacheBehavior defaultCacheBehavior) {
            this.defaultCacheBehavior = defaultCacheBehavior;
            return this;
        }

        public final void setDefaultCacheBehavior(DefaultCacheBehavior.BuilderImpl defaultCacheBehavior) {
            this.defaultCacheBehavior = defaultCacheBehavior != null ? defaultCacheBehavior.build() : null;
        }

        public final CacheBehaviors.Builder getCacheBehaviors() {
            return this.cacheBehaviors != null ? this.cacheBehaviors.toBuilder() : null;
        }

        @Override
        public final Builder cacheBehaviors(CacheBehaviors cacheBehaviors) {
            this.cacheBehaviors = cacheBehaviors;
            return this;
        }

        public final void setCacheBehaviors(CacheBehaviors.BuilderImpl cacheBehaviors) {
            this.cacheBehaviors = cacheBehaviors != null ? cacheBehaviors.build() : null;
        }

        public final CustomErrorResponses.Builder getCustomErrorResponses() {
            return this.customErrorResponses != null ? this.customErrorResponses.toBuilder() : null;
        }

        @Override
        public final Builder customErrorResponses(CustomErrorResponses customErrorResponses) {
            this.customErrorResponses = customErrorResponses;
            return this;
        }

        public final void setCustomErrorResponses(CustomErrorResponses.BuilderImpl customErrorResponses) {
            this.customErrorResponses = customErrorResponses != null ? customErrorResponses.build() : null;
        }

        public final String getComment() {
            return this.comment;
        }

        @Override
        public final Builder comment(String comment) {
            this.comment = comment;
            return this;
        }

        public final void setComment(String comment) {
            this.comment = comment;
        }

        public final String getPriceClassAsString() {
            return this.priceClass;
        }

        @Override
        public final Builder priceClass(String priceClass) {
            this.priceClass = priceClass;
            return this;
        }

        @Override
        public final Builder priceClass(PriceClass priceClass) {
            this.priceClass(priceClass == null ? null : priceClass.toString());
            return this;
        }

        public final void setPriceClass(String priceClass) {
            this.priceClass = priceClass;
        }

        public final Boolean getEnabled() {
            return this.enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        public final ViewerCertificate.Builder getViewerCertificate() {
            return this.viewerCertificate != null ? this.viewerCertificate.toBuilder() : null;
        }

        @Override
        public final Builder viewerCertificate(ViewerCertificate viewerCertificate) {
            this.viewerCertificate = viewerCertificate;
            return this;
        }

        public final void setViewerCertificate(ViewerCertificate.BuilderImpl viewerCertificate) {
            this.viewerCertificate = viewerCertificate != null ? viewerCertificate.build() : null;
        }

        public final Restrictions.Builder getRestrictions() {
            return this.restrictions != null ? this.restrictions.toBuilder() : null;
        }

        @Override
        public final Builder restrictions(Restrictions restrictions) {
            this.restrictions = restrictions;
            return this;
        }

        public final void setRestrictions(Restrictions.BuilderImpl restrictions) {
            this.restrictions = restrictions != null ? restrictions.build() : null;
        }

        public final String getWebACLId() {
            return this.webACLId;
        }

        @Override
        public final Builder webACLId(String webACLId) {
            this.webACLId = webACLId;
            return this;
        }

        public final void setWebACLId(String webACLId) {
            this.webACLId = webACLId;
        }

        public final String getHttpVersionAsString() {
            return this.httpVersion;
        }

        @Override
        public final Builder httpVersion(String httpVersion) {
            this.httpVersion = httpVersion;
            return this;
        }

        @Override
        public final Builder httpVersion(HttpVersion httpVersion) {
            this.httpVersion(httpVersion == null ? null : httpVersion.toString());
            return this;
        }

        public final void setHttpVersion(String httpVersion) {
            this.httpVersion = httpVersion;
        }

        public final Boolean getIsIPV6Enabled() {
            return this.isIPV6Enabled;
        }

        @Override
        public final Builder isIPV6Enabled(Boolean isIPV6Enabled) {
            this.isIPV6Enabled = isIPV6Enabled;
            return this;
        }

        public final void setIsIPV6Enabled(Boolean isIPV6Enabled) {
            this.isIPV6Enabled = isIPV6Enabled;
        }

        public final Collection<AliasICPRecordal.Builder> getAliasICPRecordals() {
            return this.aliasICPRecordals != null ? (Collection)this.aliasICPRecordals.stream().map(AliasICPRecordal::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder aliasICPRecordals(Collection<AliasICPRecordal> aliasICPRecordals) {
            this.aliasICPRecordals = AliasICPRecordalsCopier.copy(aliasICPRecordals);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder aliasICPRecordals(AliasICPRecordal ... aliasICPRecordals) {
            this.aliasICPRecordals(Arrays.asList(aliasICPRecordals));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder aliasICPRecordals(Consumer<AliasICPRecordal.Builder> ... aliasICPRecordals) {
            this.aliasICPRecordals(Stream.of(aliasICPRecordals).map(c -> (AliasICPRecordal)((AliasICPRecordal.Builder)AliasICPRecordal.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setAliasICPRecordals(Collection<AliasICPRecordal.BuilderImpl> aliasICPRecordals) {
            this.aliasICPRecordals = AliasICPRecordalsCopier.copyFromBuilder(aliasICPRecordals);
        }

        public DistributionSummary build() {
            return new DistributionSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DistributionSummary> {
        public Builder id(String var1);

        public Builder arn(String var1);

        public Builder status(String var1);

        public Builder lastModifiedTime(Instant var1);

        public Builder domainName(String var1);

        public Builder aliases(Aliases var1);

        default public Builder aliases(Consumer<Aliases.Builder> aliases) {
            return this.aliases((Aliases)((Aliases.Builder)Aliases.builder().applyMutation(aliases)).build());
        }

        public Builder origins(Origins var1);

        default public Builder origins(Consumer<Origins.Builder> origins) {
            return this.origins((Origins)((Origins.Builder)Origins.builder().applyMutation(origins)).build());
        }

        public Builder originGroups(OriginGroups var1);

        default public Builder originGroups(Consumer<OriginGroups.Builder> originGroups) {
            return this.originGroups((OriginGroups)((OriginGroups.Builder)OriginGroups.builder().applyMutation(originGroups)).build());
        }

        public Builder defaultCacheBehavior(DefaultCacheBehavior var1);

        default public Builder defaultCacheBehavior(Consumer<DefaultCacheBehavior.Builder> defaultCacheBehavior) {
            return this.defaultCacheBehavior((DefaultCacheBehavior)((DefaultCacheBehavior.Builder)DefaultCacheBehavior.builder().applyMutation(defaultCacheBehavior)).build());
        }

        public Builder cacheBehaviors(CacheBehaviors var1);

        default public Builder cacheBehaviors(Consumer<CacheBehaviors.Builder> cacheBehaviors) {
            return this.cacheBehaviors((CacheBehaviors)((CacheBehaviors.Builder)CacheBehaviors.builder().applyMutation(cacheBehaviors)).build());
        }

        public Builder customErrorResponses(CustomErrorResponses var1);

        default public Builder customErrorResponses(Consumer<CustomErrorResponses.Builder> customErrorResponses) {
            return this.customErrorResponses((CustomErrorResponses)((CustomErrorResponses.Builder)CustomErrorResponses.builder().applyMutation(customErrorResponses)).build());
        }

        public Builder comment(String var1);

        public Builder priceClass(String var1);

        public Builder priceClass(PriceClass var1);

        public Builder enabled(Boolean var1);

        public Builder viewerCertificate(ViewerCertificate var1);

        default public Builder viewerCertificate(Consumer<ViewerCertificate.Builder> viewerCertificate) {
            return this.viewerCertificate((ViewerCertificate)((ViewerCertificate.Builder)ViewerCertificate.builder().applyMutation(viewerCertificate)).build());
        }

        public Builder restrictions(Restrictions var1);

        default public Builder restrictions(Consumer<Restrictions.Builder> restrictions) {
            return this.restrictions((Restrictions)((Restrictions.Builder)Restrictions.builder().applyMutation(restrictions)).build());
        }

        public Builder webACLId(String var1);

        public Builder httpVersion(String var1);

        public Builder httpVersion(HttpVersion var1);

        public Builder isIPV6Enabled(Boolean var1);

        public Builder aliasICPRecordals(Collection<AliasICPRecordal> var1);

        public Builder aliasICPRecordals(AliasICPRecordal ... var1);

        public Builder aliasICPRecordals(Consumer<AliasICPRecordal.Builder> ... var1);
    }
}

