/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfront.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A streaming distribution Configuration and a list of tags to be associated with the streaming distribution.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class StreamingDistributionConfigWithTags implements SdkPojo, Serializable,
        ToCopyableBuilder<StreamingDistributionConfigWithTags.Builder, StreamingDistributionConfigWithTags> {
    private static final SdkField<StreamingDistributionConfig> STREAMING_DISTRIBUTION_CONFIG_FIELD = SdkField
            .<StreamingDistributionConfig> builder(MarshallingType.SDK_POJO)
            .getter(getter(StreamingDistributionConfigWithTags::streamingDistributionConfig))
            .setter(setter(Builder::streamingDistributionConfig))
            .constructor(StreamingDistributionConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StreamingDistributionConfig")
                    .unmarshallLocationName("StreamingDistributionConfig").build()).build();

    private static final SdkField<Tags> TAGS_FIELD = SdkField
            .<Tags> builder(MarshallingType.SDK_POJO)
            .getter(getter(StreamingDistributionConfigWithTags::tags))
            .setter(setter(Builder::tags))
            .constructor(Tags::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags")
                    .unmarshallLocationName("Tags").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            STREAMING_DISTRIBUTION_CONFIG_FIELD, TAGS_FIELD));

    private static final long serialVersionUID = 1L;

    private final StreamingDistributionConfig streamingDistributionConfig;

    private final Tags tags;

    private StreamingDistributionConfigWithTags(BuilderImpl builder) {
        this.streamingDistributionConfig = builder.streamingDistributionConfig;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * A streaming distribution Configuration.
     * </p>
     * 
     * @return A streaming distribution Configuration.
     */
    public StreamingDistributionConfig streamingDistributionConfig() {
        return streamingDistributionConfig;
    }

    /**
     * <p>
     * A complex type that contains zero or more <code>Tag</code> elements.
     * </p>
     * 
     * @return A complex type that contains zero or more <code>Tag</code> elements.
     */
    public Tags tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(streamingDistributionConfig());
        hashCode = 31 * hashCode + Objects.hashCode(tags());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StreamingDistributionConfigWithTags)) {
            return false;
        }
        StreamingDistributionConfigWithTags other = (StreamingDistributionConfigWithTags) obj;
        return Objects.equals(streamingDistributionConfig(), other.streamingDistributionConfig())
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("StreamingDistributionConfigWithTags")
                .add("StreamingDistributionConfig", streamingDistributionConfig()).add("Tags", tags()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StreamingDistributionConfig":
            return Optional.ofNullable(clazz.cast(streamingDistributionConfig()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StreamingDistributionConfigWithTags, T> g) {
        return obj -> g.apply((StreamingDistributionConfigWithTags) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, StreamingDistributionConfigWithTags> {
        /**
         * <p>
         * A streaming distribution Configuration.
         * </p>
         * 
         * @param streamingDistributionConfig
         *        A streaming distribution Configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder streamingDistributionConfig(StreamingDistributionConfig streamingDistributionConfig);

        /**
         * <p>
         * A streaming distribution Configuration.
         * </p>
         * This is a convenience that creates an instance of the {@link StreamingDistributionConfig.Builder} avoiding
         * the need to create one manually via {@link StreamingDistributionConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link StreamingDistributionConfig.Builder#build()} is called
         * immediately and its result is passed to {@link #streamingDistributionConfig(StreamingDistributionConfig)}.
         * 
         * @param streamingDistributionConfig
         *        a consumer that will call methods on {@link StreamingDistributionConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #streamingDistributionConfig(StreamingDistributionConfig)
         */
        default Builder streamingDistributionConfig(Consumer<StreamingDistributionConfig.Builder> streamingDistributionConfig) {
            return streamingDistributionConfig(StreamingDistributionConfig.builder().applyMutation(streamingDistributionConfig)
                    .build());
        }

        /**
         * <p>
         * A complex type that contains zero or more <code>Tag</code> elements.
         * </p>
         * 
         * @param tags
         *        A complex type that contains zero or more <code>Tag</code> elements.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tags tags);

        /**
         * <p>
         * A complex type that contains zero or more <code>Tag</code> elements.
         * </p>
         * This is a convenience that creates an instance of the {@link Tags.Builder} avoiding the need to create one
         * manually via {@link Tags#builder()}.
         *
         * When the {@link Consumer} completes, {@link Tags.Builder#build()} is called immediately and its result is
         * passed to {@link #tags(Tags)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link Tags.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(Tags)
         */
        default Builder tags(Consumer<Tags.Builder> tags) {
            return tags(Tags.builder().applyMutation(tags).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private StreamingDistributionConfig streamingDistributionConfig;

        private Tags tags;

        private BuilderImpl() {
        }

        private BuilderImpl(StreamingDistributionConfigWithTags model) {
            streamingDistributionConfig(model.streamingDistributionConfig);
            tags(model.tags);
        }

        public final StreamingDistributionConfig.Builder getStreamingDistributionConfig() {
            return streamingDistributionConfig != null ? streamingDistributionConfig.toBuilder() : null;
        }

        @Override
        public final Builder streamingDistributionConfig(StreamingDistributionConfig streamingDistributionConfig) {
            this.streamingDistributionConfig = streamingDistributionConfig;
            return this;
        }

        public final void setStreamingDistributionConfig(StreamingDistributionConfig.BuilderImpl streamingDistributionConfig) {
            this.streamingDistributionConfig = streamingDistributionConfig != null ? streamingDistributionConfig.build() : null;
        }

        public final Tags.Builder getTags() {
            return tags != null ? tags.toBuilder() : null;
        }

        @Override
        public final Builder tags(Tags tags) {
            this.tags = tags;
            return this;
        }

        public final void setTags(Tags.BuilderImpl tags) {
            this.tags = tags != null ? tags.build() : null;
        }

        @Override
        public StreamingDistributionConfigWithTags build() {
            return new StreamingDistributionConfigWithTags(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
