/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.model;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.services.cloudfront.model.ActiveTrustedSigners;
import software.amazon.awssdk.services.cloudfront.model.StreamingDistributionConfig;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class StreamingDistribution
implements ToCopyableBuilder<Builder, StreamingDistribution> {
    private final String id;
    private final String arn;
    private final String status;
    private final Instant lastModifiedTime;
    private final String domainName;
    private final ActiveTrustedSigners activeTrustedSigners;
    private final StreamingDistributionConfig streamingDistributionConfig;

    private StreamingDistribution(BuilderImpl builder) {
        this.id = builder.id;
        this.arn = builder.arn;
        this.status = builder.status;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.domainName = builder.domainName;
        this.activeTrustedSigners = builder.activeTrustedSigners;
        this.streamingDistributionConfig = builder.streamingDistributionConfig;
    }

    public String id() {
        return this.id;
    }

    public String arn() {
        return this.arn;
    }

    public String status() {
        return this.status;
    }

    public Instant lastModifiedTime() {
        return this.lastModifiedTime;
    }

    public String domainName() {
        return this.domainName;
    }

    public ActiveTrustedSigners activeTrustedSigners() {
        return this.activeTrustedSigners;
    }

    public StreamingDistributionConfig streamingDistributionConfig() {
        return this.streamingDistributionConfig;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.domainName());
        hashCode = 31 * hashCode + Objects.hashCode(this.activeTrustedSigners());
        hashCode = 31 * hashCode + Objects.hashCode(this.streamingDistributionConfig());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StreamingDistribution)) {
            return false;
        }
        StreamingDistribution other = (StreamingDistribution)obj;
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.status(), other.status()) && Objects.equals(this.lastModifiedTime(), other.lastModifiedTime()) && Objects.equals(this.domainName(), other.domainName()) && Objects.equals(this.activeTrustedSigners(), other.activeTrustedSigners()) && Objects.equals(this.streamingDistributionConfig(), other.streamingDistributionConfig());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.id() != null) {
            sb.append("Id: ").append(this.id()).append(",");
        }
        if (this.arn() != null) {
            sb.append("ARN: ").append(this.arn()).append(",");
        }
        if (this.status() != null) {
            sb.append("Status: ").append(this.status()).append(",");
        }
        if (this.lastModifiedTime() != null) {
            sb.append("LastModifiedTime: ").append(this.lastModifiedTime()).append(",");
        }
        if (this.domainName() != null) {
            sb.append("DomainName: ").append(this.domainName()).append(",");
        }
        if (this.activeTrustedSigners() != null) {
            sb.append("ActiveTrustedSigners: ").append(this.activeTrustedSigners()).append(",");
        }
        if (this.streamingDistributionConfig() != null) {
            sb.append("StreamingDistributionConfig: ").append(this.streamingDistributionConfig()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Id": {
                return Optional.of(clazz.cast(this.id()));
            }
            case "ARN": {
                return Optional.of(clazz.cast(this.arn()));
            }
            case "Status": {
                return Optional.of(clazz.cast(this.status()));
            }
            case "LastModifiedTime": {
                return Optional.of(clazz.cast(this.lastModifiedTime()));
            }
            case "DomainName": {
                return Optional.of(clazz.cast(this.domainName()));
            }
            case "ActiveTrustedSigners": {
                return Optional.of(clazz.cast(this.activeTrustedSigners()));
            }
            case "StreamingDistributionConfig": {
                return Optional.of(clazz.cast(this.streamingDistributionConfig()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private String arn;
        private String status;
        private Instant lastModifiedTime;
        private String domainName;
        private ActiveTrustedSigners activeTrustedSigners;
        private StreamingDistributionConfig streamingDistributionConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(StreamingDistribution model) {
            this.id(model.id);
            this.arn(model.arn);
            this.status(model.status);
            this.lastModifiedTime(model.lastModifiedTime);
            this.domainName(model.domainName);
            this.activeTrustedSigners(model.activeTrustedSigners);
            this.streamingDistributionConfig(model.streamingDistributionConfig);
        }

        public final String getId() {
            return this.id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getARN() {
            return this.arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setARN(String arn) {
            this.arn = arn;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final Instant getLastModifiedTime() {
            return this.lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        public final String getDomainName() {
            return this.domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        public final ActiveTrustedSigners.Builder getActiveTrustedSigners() {
            return this.activeTrustedSigners != null ? this.activeTrustedSigners.toBuilder() : null;
        }

        @Override
        public final Builder activeTrustedSigners(ActiveTrustedSigners activeTrustedSigners) {
            this.activeTrustedSigners = activeTrustedSigners;
            return this;
        }

        public final void setActiveTrustedSigners(ActiveTrustedSigners.BuilderImpl activeTrustedSigners) {
            this.activeTrustedSigners = activeTrustedSigners != null ? activeTrustedSigners.build() : null;
        }

        public final StreamingDistributionConfig.Builder getStreamingDistributionConfig() {
            return this.streamingDistributionConfig != null ? this.streamingDistributionConfig.toBuilder() : null;
        }

        @Override
        public final Builder streamingDistributionConfig(StreamingDistributionConfig streamingDistributionConfig) {
            this.streamingDistributionConfig = streamingDistributionConfig;
            return this;
        }

        public final void setStreamingDistributionConfig(StreamingDistributionConfig.BuilderImpl streamingDistributionConfig) {
            this.streamingDistributionConfig = streamingDistributionConfig != null ? streamingDistributionConfig.build() : null;
        }

        public StreamingDistribution build() {
            return new StreamingDistribution(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, StreamingDistribution> {
        public Builder id(String var1);

        public Builder arn(String var1);

        public Builder status(String var1);

        public Builder lastModifiedTime(Instant var1);

        public Builder domainName(String var1);

        public Builder activeTrustedSigners(ActiveTrustedSigners var1);

        default public Builder activeTrustedSigners(Consumer<ActiveTrustedSigners.Builder> activeTrustedSigners) {
            return this.activeTrustedSigners((ActiveTrustedSigners)((ActiveTrustedSigners.Builder)ActiveTrustedSigners.builder().apply(activeTrustedSigners)).build());
        }

        public Builder streamingDistributionConfig(StreamingDistributionConfig var1);

        default public Builder streamingDistributionConfig(Consumer<StreamingDistributionConfig.Builder> streamingDistributionConfig) {
            return this.streamingDistributionConfig((StreamingDistributionConfig)((StreamingDistributionConfig.Builder)StreamingDistributionConfig.builder().apply(streamingDistributionConfig)).build());
        }
    }
}

