/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.transform;

import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.core.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.core.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.cloudfront.model.ViewerCertificate;

public class ViewerCertificateUnmarshaller
implements Unmarshaller<ViewerCertificate, StaxUnmarshallerContext> {
    private static final ViewerCertificateUnmarshaller INSTANCE = new ViewerCertificateUnmarshaller();

    public ViewerCertificate unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        ViewerCertificate.Builder viewerCertificate = ViewerCertificate.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("CloudFrontDefaultCertificate", targetDepth)) {
                    viewerCertificate.cloudFrontDefaultCertificate(SimpleTypeStaxUnmarshallers.BooleanUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("IAMCertificateId", targetDepth)) {
                    viewerCertificate.iamCertificateId(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("ACMCertificateArn", targetDepth)) {
                    viewerCertificate.acmCertificateArn(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("SSLSupportMethod", targetDepth)) {
                    viewerCertificate.sslSupportMethod(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("MinimumProtocolVersion", targetDepth)) {
                    viewerCertificate.minimumProtocolVersion(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Certificate", targetDepth)) {
                    viewerCertificate.certificate(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("CertificateSource", targetDepth)) continue;
                viewerCertificate.certificateSource(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (ViewerCertificate)viewerCertificate.build();
    }

    public static ViewerCertificateUnmarshaller getInstance() {
        return INSTANCE;
    }
}

