/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.paginators;

import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.NextPageFetcher;
import software.amazon.awssdk.core.pagination.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.services.cloudfront.CloudFrontClient;
import software.amazon.awssdk.services.cloudfront.model.ListStreamingDistributionsRequest;
import software.amazon.awssdk.services.cloudfront.model.ListStreamingDistributionsResponse;
import software.amazon.awssdk.services.cloudfront.model.StreamingDistributionSummary;

public final class ListStreamingDistributionsPaginator
implements SdkIterable<ListStreamingDistributionsResponse> {
    private final CloudFrontClient client;
    private final ListStreamingDistributionsRequest firstRequest;
    private final NextPageFetcher nextPageFetcher;

    public ListStreamingDistributionsPaginator(CloudFrontClient client, ListStreamingDistributionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListStreamingDistributionsResponseFetcher();
    }

    public Iterator<ListStreamingDistributionsResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public SdkIterable<StreamingDistributionSummary> items() {
        Function<ListStreamingDistributionsResponse, Iterator> getIterator = response -> response != null ? response.streamingDistributionList().items().iterator() : null;
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    private class ListStreamingDistributionsResponseFetcher
    implements NextPageFetcher<ListStreamingDistributionsResponse> {
        private ListStreamingDistributionsResponseFetcher() {
        }

        public boolean hasNextPage(ListStreamingDistributionsResponse previousPage) {
            return previousPage.streamingDistributionList().isTruncated();
        }

        public ListStreamingDistributionsResponse nextPage(ListStreamingDistributionsResponse previousPage) {
            if (previousPage == null) {
                return ListStreamingDistributionsPaginator.this.client.listStreamingDistributions(ListStreamingDistributionsPaginator.this.firstRequest);
            }
            return ListStreamingDistributionsPaginator.this.client.listStreamingDistributions((ListStreamingDistributionsRequest)((Object)ListStreamingDistributionsPaginator.this.firstRequest.toBuilder().marker(previousPage.streamingDistributionList().nextMarker()).build()));
        }
    }
}

