/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.services.cloudfront.model.CertificateSource;
import software.amazon.awssdk.services.cloudfront.model.MinimumProtocolVersion;
import software.amazon.awssdk.services.cloudfront.model.SSLSupportMethod;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ViewerCertificate
implements ToCopyableBuilder<Builder, ViewerCertificate> {
    private final Boolean cloudFrontDefaultCertificate;
    private final String iamCertificateId;
    private final String acmCertificateArn;
    private final String sslSupportMethod;
    private final String minimumProtocolVersion;
    private final String certificate;
    private final String certificateSource;

    private ViewerCertificate(BuilderImpl builder) {
        this.cloudFrontDefaultCertificate = builder.cloudFrontDefaultCertificate;
        this.iamCertificateId = builder.iamCertificateId;
        this.acmCertificateArn = builder.acmCertificateArn;
        this.sslSupportMethod = builder.sslSupportMethod;
        this.minimumProtocolVersion = builder.minimumProtocolVersion;
        this.certificate = builder.certificate;
        this.certificateSource = builder.certificateSource;
    }

    public Boolean cloudFrontDefaultCertificate() {
        return this.cloudFrontDefaultCertificate;
    }

    public String iamCertificateId() {
        return this.iamCertificateId;
    }

    public String acmCertificateArn() {
        return this.acmCertificateArn;
    }

    public SSLSupportMethod sslSupportMethod() {
        return SSLSupportMethod.fromValue(this.sslSupportMethod);
    }

    public String sslSupportMethodString() {
        return this.sslSupportMethod;
    }

    public MinimumProtocolVersion minimumProtocolVersion() {
        return MinimumProtocolVersion.fromValue(this.minimumProtocolVersion);
    }

    public String minimumProtocolVersionString() {
        return this.minimumProtocolVersion;
    }

    public String certificate() {
        return this.certificate;
    }

    public CertificateSource certificateSource() {
        return CertificateSource.fromValue(this.certificateSource);
    }

    public String certificateSourceString() {
        return this.certificateSource;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.cloudFrontDefaultCertificate());
        hashCode = 31 * hashCode + Objects.hashCode(this.iamCertificateId());
        hashCode = 31 * hashCode + Objects.hashCode(this.acmCertificateArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.sslSupportMethodString());
        hashCode = 31 * hashCode + Objects.hashCode(this.minimumProtocolVersionString());
        hashCode = 31 * hashCode + Objects.hashCode(this.certificate());
        hashCode = 31 * hashCode + Objects.hashCode(this.certificateSourceString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ViewerCertificate)) {
            return false;
        }
        ViewerCertificate other = (ViewerCertificate)obj;
        return Objects.equals(this.cloudFrontDefaultCertificate(), other.cloudFrontDefaultCertificate()) && Objects.equals(this.iamCertificateId(), other.iamCertificateId()) && Objects.equals(this.acmCertificateArn(), other.acmCertificateArn()) && Objects.equals(this.sslSupportMethodString(), other.sslSupportMethodString()) && Objects.equals(this.minimumProtocolVersionString(), other.minimumProtocolVersionString()) && Objects.equals(this.certificate(), other.certificate()) && Objects.equals(this.certificateSourceString(), other.certificateSourceString());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.cloudFrontDefaultCertificate() != null) {
            sb.append("CloudFrontDefaultCertificate: ").append(this.cloudFrontDefaultCertificate()).append(",");
        }
        if (this.iamCertificateId() != null) {
            sb.append("IAMCertificateId: ").append(this.iamCertificateId()).append(",");
        }
        if (this.acmCertificateArn() != null) {
            sb.append("ACMCertificateArn: ").append(this.acmCertificateArn()).append(",");
        }
        if (this.sslSupportMethodString() != null) {
            sb.append("SSLSupportMethod: ").append(this.sslSupportMethodString()).append(",");
        }
        if (this.minimumProtocolVersionString() != null) {
            sb.append("MinimumProtocolVersion: ").append(this.minimumProtocolVersionString()).append(",");
        }
        if (this.certificate() != null) {
            sb.append("Certificate: ").append(this.certificate()).append(",");
        }
        if (this.certificateSourceString() != null) {
            sb.append("CertificateSource: ").append(this.certificateSourceString()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CloudFrontDefaultCertificate": {
                return Optional.of(clazz.cast(this.cloudFrontDefaultCertificate()));
            }
            case "IAMCertificateId": {
                return Optional.of(clazz.cast(this.iamCertificateId()));
            }
            case "ACMCertificateArn": {
                return Optional.of(clazz.cast(this.acmCertificateArn()));
            }
            case "SSLSupportMethod": {
                return Optional.of(clazz.cast(this.sslSupportMethodString()));
            }
            case "MinimumProtocolVersion": {
                return Optional.of(clazz.cast(this.minimumProtocolVersionString()));
            }
            case "Certificate": {
                return Optional.of(clazz.cast(this.certificate()));
            }
            case "CertificateSource": {
                return Optional.of(clazz.cast(this.certificateSourceString()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private Boolean cloudFrontDefaultCertificate;
        private String iamCertificateId;
        private String acmCertificateArn;
        private String sslSupportMethod;
        private String minimumProtocolVersion;
        private String certificate;
        private String certificateSource;

        private BuilderImpl() {
        }

        private BuilderImpl(ViewerCertificate model) {
            this.cloudFrontDefaultCertificate(model.cloudFrontDefaultCertificate);
            this.iamCertificateId(model.iamCertificateId);
            this.acmCertificateArn(model.acmCertificateArn);
            this.sslSupportMethod(model.sslSupportMethod);
            this.minimumProtocolVersion(model.minimumProtocolVersion);
            this.certificate(model.certificate);
            this.certificateSource(model.certificateSource);
        }

        public final Boolean getCloudFrontDefaultCertificate() {
            return this.cloudFrontDefaultCertificate;
        }

        @Override
        public final Builder cloudFrontDefaultCertificate(Boolean cloudFrontDefaultCertificate) {
            this.cloudFrontDefaultCertificate = cloudFrontDefaultCertificate;
            return this;
        }

        public final void setCloudFrontDefaultCertificate(Boolean cloudFrontDefaultCertificate) {
            this.cloudFrontDefaultCertificate = cloudFrontDefaultCertificate;
        }

        public final String getIAMCertificateId() {
            return this.iamCertificateId;
        }

        @Override
        public final Builder iamCertificateId(String iamCertificateId) {
            this.iamCertificateId = iamCertificateId;
            return this;
        }

        public final void setIAMCertificateId(String iamCertificateId) {
            this.iamCertificateId = iamCertificateId;
        }

        public final String getACMCertificateArn() {
            return this.acmCertificateArn;
        }

        @Override
        public final Builder acmCertificateArn(String acmCertificateArn) {
            this.acmCertificateArn = acmCertificateArn;
            return this;
        }

        public final void setACMCertificateArn(String acmCertificateArn) {
            this.acmCertificateArn = acmCertificateArn;
        }

        public final String getSSLSupportMethod() {
            return this.sslSupportMethod;
        }

        @Override
        public final Builder sslSupportMethod(String sslSupportMethod) {
            this.sslSupportMethod = sslSupportMethod;
            return this;
        }

        @Override
        public final Builder sslSupportMethod(SSLSupportMethod sslSupportMethod) {
            this.sslSupportMethod(sslSupportMethod.toString());
            return this;
        }

        public final void setSSLSupportMethod(String sslSupportMethod) {
            this.sslSupportMethod = sslSupportMethod;
        }

        public final String getMinimumProtocolVersion() {
            return this.minimumProtocolVersion;
        }

        @Override
        public final Builder minimumProtocolVersion(String minimumProtocolVersion) {
            this.minimumProtocolVersion = minimumProtocolVersion;
            return this;
        }

        @Override
        public final Builder minimumProtocolVersion(MinimumProtocolVersion minimumProtocolVersion) {
            this.minimumProtocolVersion(minimumProtocolVersion.toString());
            return this;
        }

        public final void setMinimumProtocolVersion(String minimumProtocolVersion) {
            this.minimumProtocolVersion = minimumProtocolVersion;
        }

        public final String getCertificate() {
            return this.certificate;
        }

        @Override
        public final Builder certificate(String certificate) {
            this.certificate = certificate;
            return this;
        }

        public final void setCertificate(String certificate) {
            this.certificate = certificate;
        }

        public final String getCertificateSource() {
            return this.certificateSource;
        }

        @Override
        public final Builder certificateSource(String certificateSource) {
            this.certificateSource = certificateSource;
            return this;
        }

        @Override
        public final Builder certificateSource(CertificateSource certificateSource) {
            this.certificateSource(certificateSource.toString());
            return this;
        }

        public final void setCertificateSource(String certificateSource) {
            this.certificateSource = certificateSource;
        }

        public ViewerCertificate build() {
            return new ViewerCertificate(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ViewerCertificate> {
        public Builder cloudFrontDefaultCertificate(Boolean var1);

        public Builder iamCertificateId(String var1);

        public Builder acmCertificateArn(String var1);

        public Builder sslSupportMethod(String var1);

        public Builder sslSupportMethod(SSLSupportMethod var1);

        public Builder minimumProtocolVersion(String var1);

        public Builder minimumProtocolVersion(MinimumProtocolVersion var1);

        public Builder certificate(String var1);

        public Builder certificateSource(String var1);

        public Builder certificateSource(CertificateSource var1);
    }
}

