/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.cloudfront.model.CacheBehavior;
import software.amazon.awssdk.services.cloudfront.model.CacheBehaviorListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CacheBehaviors
implements ToCopyableBuilder<Builder, CacheBehaviors> {
    private final Integer quantity;
    private final List<CacheBehavior> items;

    private CacheBehaviors(BuilderImpl builder) {
        this.quantity = builder.quantity;
        this.items = builder.items;
    }

    public Integer quantity() {
        return this.quantity;
    }

    public List<CacheBehavior> items() {
        return this.items;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.quantity());
        hashCode = 31 * hashCode + Objects.hashCode(this.items());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CacheBehaviors)) {
            return false;
        }
        CacheBehaviors other = (CacheBehaviors)obj;
        return Objects.equals(this.quantity(), other.quantity()) && Objects.equals(this.items(), other.items());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.quantity() != null) {
            sb.append("Quantity: ").append(this.quantity()).append(",");
        }
        if (this.items() != null) {
            sb.append("Items: ").append(this.items()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Quantity": {
                return Optional.of(clazz.cast(this.quantity()));
            }
            case "Items": {
                return Optional.of(clazz.cast(this.items()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private Integer quantity;
        private List<CacheBehavior> items;

        private BuilderImpl() {
        }

        private BuilderImpl(CacheBehaviors model) {
            this.quantity(model.quantity);
            this.items(model.items);
        }

        public final Integer getQuantity() {
            return this.quantity;
        }

        @Override
        public final Builder quantity(Integer quantity) {
            this.quantity = quantity;
            return this;
        }

        public final void setQuantity(Integer quantity) {
            this.quantity = quantity;
        }

        public final Collection<CacheBehavior.Builder> getItems() {
            return this.items != null ? (Collection)this.items.stream().map(CacheBehavior::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder items(Collection<CacheBehavior> items) {
            this.items = CacheBehaviorListCopier.copy(items);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder items(CacheBehavior ... items) {
            this.items(Arrays.asList(items));
            return this;
        }

        public final void setItems(Collection<CacheBehavior.BuilderImpl> items) {
            this.items = CacheBehaviorListCopier.copyFromBuilder(items);
        }

        public CacheBehaviors build() {
            return new CacheBehaviors(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, CacheBehaviors> {
        public Builder quantity(Integer var1);

        public Builder items(Collection<CacheBehavior> var1);

        public Builder items(CacheBehavior ... var1);
    }
}

