/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import software.amazon.awssdk.services.cloudfront.model.TagKeyListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class TagKeys
implements ToCopyableBuilder<Builder, TagKeys> {
    private final List<String> items;

    private TagKeys(BuilderImpl builder) {
        this.items = builder.items;
    }

    public List<String> items() {
        return this.items;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.items() == null ? 0 : this.items().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TagKeys)) {
            return false;
        }
        TagKeys other = (TagKeys)obj;
        if (other.items() == null ^ this.items() == null) {
            return false;
        }
        return other.items() == null || other.items().equals(this.items());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.items() != null) {
            sb.append("Items: ").append(this.items()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Items": {
                return Optional.of(clazz.cast(this.items()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> items;

        private BuilderImpl() {
        }

        private BuilderImpl(TagKeys model) {
            this.items(model.items);
        }

        public final Collection<String> getItems() {
            return this.items;
        }

        @Override
        public final Builder items(Collection<String> items) {
            this.items = TagKeyListCopier.copy(items);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder items(String ... items) {
            this.items(Arrays.asList(items));
            return this;
        }

        public final void setItems(Collection<String> items) {
            this.items = TagKeyListCopier.copy(items);
        }

        public TagKeys build() {
            return new TagKeys(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, TagKeys> {
        public Builder items(Collection<String> var1);

        public Builder items(String ... var1);
    }
}

