/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.model;

import java.util.Optional;
import software.amazon.awssdk.services.cloudfront.model.CustomHeaders;
import software.amazon.awssdk.services.cloudfront.model.CustomOriginConfig;
import software.amazon.awssdk.services.cloudfront.model.S3OriginConfig;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class Origin
implements ToCopyableBuilder<Builder, Origin> {
    private final String id;
    private final String domainName;
    private final String originPath;
    private final CustomHeaders customHeaders;
    private final S3OriginConfig s3OriginConfig;
    private final CustomOriginConfig customOriginConfig;

    private Origin(BuilderImpl builder) {
        this.id = builder.id;
        this.domainName = builder.domainName;
        this.originPath = builder.originPath;
        this.customHeaders = builder.customHeaders;
        this.s3OriginConfig = builder.s3OriginConfig;
        this.customOriginConfig = builder.customOriginConfig;
    }

    public String id() {
        return this.id;
    }

    public String domainName() {
        return this.domainName;
    }

    public String originPath() {
        return this.originPath;
    }

    public CustomHeaders customHeaders() {
        return this.customHeaders;
    }

    public S3OriginConfig s3OriginConfig() {
        return this.s3OriginConfig;
    }

    public CustomOriginConfig customOriginConfig() {
        return this.customOriginConfig;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.id() == null ? 0 : this.id().hashCode());
        hashCode = 31 * hashCode + (this.domainName() == null ? 0 : this.domainName().hashCode());
        hashCode = 31 * hashCode + (this.originPath() == null ? 0 : this.originPath().hashCode());
        hashCode = 31 * hashCode + (this.customHeaders() == null ? 0 : this.customHeaders().hashCode());
        hashCode = 31 * hashCode + (this.s3OriginConfig() == null ? 0 : this.s3OriginConfig().hashCode());
        hashCode = 31 * hashCode + (this.customOriginConfig() == null ? 0 : this.customOriginConfig().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Origin)) {
            return false;
        }
        Origin other = (Origin)obj;
        if (other.id() == null ^ this.id() == null) {
            return false;
        }
        if (other.id() != null && !other.id().equals(this.id())) {
            return false;
        }
        if (other.domainName() == null ^ this.domainName() == null) {
            return false;
        }
        if (other.domainName() != null && !other.domainName().equals(this.domainName())) {
            return false;
        }
        if (other.originPath() == null ^ this.originPath() == null) {
            return false;
        }
        if (other.originPath() != null && !other.originPath().equals(this.originPath())) {
            return false;
        }
        if (other.customHeaders() == null ^ this.customHeaders() == null) {
            return false;
        }
        if (other.customHeaders() != null && !other.customHeaders().equals(this.customHeaders())) {
            return false;
        }
        if (other.s3OriginConfig() == null ^ this.s3OriginConfig() == null) {
            return false;
        }
        if (other.s3OriginConfig() != null && !other.s3OriginConfig().equals(this.s3OriginConfig())) {
            return false;
        }
        if (other.customOriginConfig() == null ^ this.customOriginConfig() == null) {
            return false;
        }
        return other.customOriginConfig() == null || other.customOriginConfig().equals(this.customOriginConfig());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.id() != null) {
            sb.append("Id: ").append(this.id()).append(",");
        }
        if (this.domainName() != null) {
            sb.append("DomainName: ").append(this.domainName()).append(",");
        }
        if (this.originPath() != null) {
            sb.append("OriginPath: ").append(this.originPath()).append(",");
        }
        if (this.customHeaders() != null) {
            sb.append("CustomHeaders: ").append(this.customHeaders()).append(",");
        }
        if (this.s3OriginConfig() != null) {
            sb.append("S3OriginConfig: ").append(this.s3OriginConfig()).append(",");
        }
        if (this.customOriginConfig() != null) {
            sb.append("CustomOriginConfig: ").append(this.customOriginConfig()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Id": {
                return Optional.of(clazz.cast(this.id()));
            }
            case "DomainName": {
                return Optional.of(clazz.cast(this.domainName()));
            }
            case "OriginPath": {
                return Optional.of(clazz.cast(this.originPath()));
            }
            case "CustomHeaders": {
                return Optional.of(clazz.cast(this.customHeaders()));
            }
            case "S3OriginConfig": {
                return Optional.of(clazz.cast(this.s3OriginConfig()));
            }
            case "CustomOriginConfig": {
                return Optional.of(clazz.cast(this.customOriginConfig()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private String domainName;
        private String originPath;
        private CustomHeaders customHeaders;
        private S3OriginConfig s3OriginConfig;
        private CustomOriginConfig customOriginConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(Origin model) {
            this.id(model.id);
            this.domainName(model.domainName);
            this.originPath(model.originPath);
            this.customHeaders(model.customHeaders);
            this.s3OriginConfig(model.s3OriginConfig);
            this.customOriginConfig(model.customOriginConfig);
        }

        public final String getId() {
            return this.id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getDomainName() {
            return this.domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        public final String getOriginPath() {
            return this.originPath;
        }

        @Override
        public final Builder originPath(String originPath) {
            this.originPath = originPath;
            return this;
        }

        public final void setOriginPath(String originPath) {
            this.originPath = originPath;
        }

        public final CustomHeaders.Builder getCustomHeaders() {
            return this.customHeaders != null ? this.customHeaders.toBuilder() : null;
        }

        @Override
        public final Builder customHeaders(CustomHeaders customHeaders) {
            this.customHeaders = customHeaders;
            return this;
        }

        public final void setCustomHeaders(CustomHeaders.BuilderImpl customHeaders) {
            this.customHeaders = customHeaders != null ? customHeaders.build() : null;
        }

        public final S3OriginConfig.Builder getS3OriginConfig() {
            return this.s3OriginConfig != null ? this.s3OriginConfig.toBuilder() : null;
        }

        @Override
        public final Builder s3OriginConfig(S3OriginConfig s3OriginConfig) {
            this.s3OriginConfig = s3OriginConfig;
            return this;
        }

        public final void setS3OriginConfig(S3OriginConfig.BuilderImpl s3OriginConfig) {
            this.s3OriginConfig = s3OriginConfig != null ? s3OriginConfig.build() : null;
        }

        public final CustomOriginConfig.Builder getCustomOriginConfig() {
            return this.customOriginConfig != null ? this.customOriginConfig.toBuilder() : null;
        }

        @Override
        public final Builder customOriginConfig(CustomOriginConfig customOriginConfig) {
            this.customOriginConfig = customOriginConfig;
            return this;
        }

        public final void setCustomOriginConfig(CustomOriginConfig.BuilderImpl customOriginConfig) {
            this.customOriginConfig = customOriginConfig != null ? customOriginConfig.build() : null;
        }

        public Origin build() {
            return new Origin(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Origin> {
        public Builder id(String var1);

        public Builder domainName(String var1);

        public Builder originPath(String var1);

        public Builder customHeaders(CustomHeaders var1);

        public Builder s3OriginConfig(S3OriginConfig var1);

        public Builder customOriginConfig(CustomOriginConfig var1);
    }
}

