/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.transform;

import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.cloudfront.model.OriginSslProtocols;

public class OriginSslProtocolsUnmarshaller
implements Unmarshaller<OriginSslProtocols, StaxUnmarshallerContext> {
    private static final OriginSslProtocolsUnmarshaller INSTANCE = new OriginSslProtocolsUnmarshaller();

    public OriginSslProtocols unmarshall(StaxUnmarshallerContext context) throws Exception {
        OriginSslProtocols.Builder originSslProtocols;
        block6: {
            originSslProtocols = OriginSslProtocols.builder();
            int originalDepth = context.getCurrentDepth();
            int targetDepth = originalDepth + 1;
            if (context.isStartOfDocument()) {
                ++targetDepth;
            }
            ArrayList<String> items = null;
            while (true) {
                XMLEvent xmlEvent;
                if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                    originSslProtocols.items(items);
                    break block6;
                }
                if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                    if (context.testExpression("Quantity", targetDepth)) {
                        originSslProtocols.quantity(SimpleTypeStaxUnmarshallers.IntegerUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("Items", targetDepth)) {
                        items = new ArrayList<String>();
                        continue;
                    }
                    if (!context.testExpression("Items/SslProtocol", targetDepth)) continue;
                    items.add(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
            }
            originSslProtocols.items(items);
        }
        return (OriginSslProtocols)originSslProtocols.build();
    }

    public static OriginSslProtocolsUnmarshaller getInstance() {
        return INSTANCE;
    }
}

