/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.transform;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.runtime.transform.PathMarshallers;
import software.amazon.awssdk.services.cloudfront.model.DeleteDistributionRequest;
import software.amazon.awssdk.util.StringUtils;

public class DeleteDistributionRequestMarshaller
implements Marshaller<Request<DeleteDistributionRequest>, DeleteDistributionRequest> {
    public Request<DeleteDistributionRequest> marshall(DeleteDistributionRequest deleteDistributionRequest) {
        if (deleteDistributionRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)deleteDistributionRequest, "CloudFrontClient");
        request.setHttpMethod(HttpMethodName.DELETE);
        if (deleteDistributionRequest.ifMatch() != null) {
            request.addHeader("If-Match", StringUtils.fromString((String)deleteDistributionRequest.ifMatch()));
        }
        String uriResourcePath = "/2017-03-25/distribution/{Id}";
        uriResourcePath = PathMarshallers.NON_GREEDY.marshall(uriResourcePath, "Id", deleteDistributionRequest.id());
        request.setResourcePath(uriResourcePath);
        return request;
    }
}

